/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.inputs;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.mapreduce.Input;
import com.google.appengine.tools.mapreduce.InputReader;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public class RandomLongInput
extends Input<Long> {
    private static final long serialVersionUID = 524476737411668844L;
    private final long valuesTotal;
    private final int shardCount;
    private Long seed = null;

    public RandomLongInput(long valuesTotal, int shardCount) {
        Preconditions.checkArgument(valuesTotal >= 0L, "valuesTotal should be >=0: %s", valuesTotal);
        Preconditions.checkArgument(shardCount > 0, "shardCount should be >0: %s", shardCount);
        this.valuesTotal = valuesTotal;
        this.shardCount = shardCount;
    }

    public RandomLongInput setSeed(Long seed) {
        this.seed = seed;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valuesTotal + ", " + this.shardCount + ")";
    }

    @Override
    public List<? extends InputReader<Long>> createReaders() throws IOException {
        ImmutableList.Builder b = ImmutableList.builder();
        long valuesPerShard = this.valuesTotal / (long)this.shardCount;
        long remainder = this.valuesTotal % (long)this.shardCount;
        for (int i = 0; i < this.shardCount; ++i) {
            long countHere = valuesPerShard + (long)((long)i < remainder ? 1 : 0);
            b.add(new Reader(this.seed == null ? null : Long.valueOf(this.seed + (long)i), countHere));
        }
        return b.build();
    }

    private static class Reader
    extends InputReader<Long> {
        private static final long serialVersionUID = 764351972869495917L;
        private final Random random;
        private long emitted = 0L;
        private long toEmit;

        private Reader(Long seed, long toEmit) {
            this.toEmit = toEmit;
            this.random = seed == null ? new SecureRandom() : new Random(seed);
        }

        @Override
        public Double getProgress() {
            return this.toEmit <= 0L ? 1.0 : (double)this.emitted / (double)this.toEmit;
        }

        @Override
        public Long next() {
            if (this.emitted >= this.toEmit) {
                throw new NoSuchElementException();
            }
            ++this.emitted;
            return this.random.nextLong();
        }
    }
}

