/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.outputs;

import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.google.common.collect.Lists;
import com.google.appengine.tools.mapreduce.Output;
import com.google.appengine.tools.mapreduce.OutputWriter;
import com.google.appengine.tools.mapreduce.impl.util.FileUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BlobFileOutput
extends Output<ByteBuffer, List<AppEngineFile>> {
    private static final long serialVersionUID = 868276534742230776L;
    private static final Logger log = Logger.getLogger(BlobFileOutput.class.getName());
    private static final FileService FILE_SERVICE = FileServiceFactory.getFileService();
    private final int numShards;
    private final String mimeType;
    private final String fileNamePattern;

    public BlobFileOutput(int numShards, String mimeType, String fileNamePattern) {
        this.numShards = numShards;
        this.mimeType = Preconditions.checkNotNull(mimeType, "Null mimeType");
        this.fileNamePattern = Preconditions.checkNotNull(fileNamePattern, "Null fileNamePattern");
    }

    @Override
    public List<? extends OutputWriter<ByteBuffer>> createWriters() {
        ImmutableList.Builder out = ImmutableList.builder();
        for (int i = 0; i < this.numShards; ++i) {
            out.add(new Writer(this.mimeType, String.format(this.fileNamePattern, i)));
        }
        return out.build();
    }

    @Override
    public List<AppEngineFile> finish(List<? extends OutputWriter<ByteBuffer>> writers) {
        ArrayList<AppEngineFile> out = Lists.newArrayList();
        for (OutputWriter<ByteBuffer> outputWriter : writers) {
            Writer writer = (Writer)outputWriter;
            out.add(writer.file);
        }
        return out;
    }

    private static class Writer
    extends OutputWriter<ByteBuffer> {
        private static final long serialVersionUID = 731097023265864883L;
        private final String mimeType;
        private final String fileName;
        private AppEngineFile file = null;
        private transient FileWriteChannel channel;

        Writer(String mimeType, String fileName) {
            this.mimeType = Preconditions.checkNotNull(mimeType, "Null mimeType");
            this.fileName = Preconditions.checkNotNull(fileName, "Null fileName");
        }

        private void ensureOpen() throws IOException {
            if (this.channel != null) {
                return;
            }
            if (this.file == null) {
                this.file = FILE_SERVICE.createNewBlobFile(this.mimeType, this.fileName);
            }
            this.channel = FILE_SERVICE.openWriteChannel(this.file, false);
        }

        @Override
        public void write(ByteBuffer bytes) throws IOException {
            this.ensureOpen();
            this.channel.write(bytes);
        }

        @Override
        public void close() throws IOException {
            if (this.file == null) {
                return;
            }
            if (this.channel != null) {
                this.channel.close();
            }
            FileUtil.ensureFinalized(this.file);
        }
    }
}

