/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.outputs;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.google.common.collect.Lists;
import com.google.appengine.tools.mapreduce.Output;
import com.google.appengine.tools.mapreduce.OutputWriter;
import java.io.IOException;
import java.util.List;

public class InMemoryOutput<O>
extends Output<O, List<List<O>>> {
    private static final long serialVersionUID = 184437617254585618L;
    private final int shardCount;

    public static <O> InMemoryOutput<O> create(int numShards) {
        return new InMemoryOutput<O>(numShards);
    }

    public InMemoryOutput(int shardCount) {
        Preconditions.checkArgument(shardCount >= 0, "Negative shardCount: %s", shardCount);
        this.shardCount = shardCount;
    }

    @Override
    public List<? extends OutputWriter<O>> createWriters() {
        ImmutableList.Builder out = ImmutableList.builder();
        for (int i = 0; i < this.shardCount; ++i) {
            out.add(new Writer());
        }
        return out.build();
    }

    @Override
    public List<List<O>> finish(List<? extends OutputWriter<O>> writers) {
        ImmutableList.Builder out = ImmutableList.builder();
        for (OutputWriter<O> w : writers) {
            Writer writer = (Writer)w;
            out.add(ImmutableList.copyOf(writer.accu));
        }
        return out.build();
    }

    private static class Writer<O>
    extends OutputWriter<O> {
        private static final long serialVersionUID = 528522943983621278L;
        private boolean closed = false;
        private final List<O> accu = Lists.newArrayList();

        private Writer() {
        }

        public String toString() {
            return "InMemoryOutput.Writer(" + this.accu.size() + " items" + (this.closed ? ", closed" : " so far") + ")";
        }

        @Override
        public void write(O value) throws IOException {
            Preconditions.checkState(!this.closed, "%s: Already closed", this);
            this.accu.add(value);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

