/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.outputs;

import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.mapreduce.Output;
import com.google.appengine.tools.mapreduce.OutputWriter;
import java.util.List;

public class NoOutput<O, R>
extends Output<O, R> {
    private static final long serialVersionUID = 965415182637510898L;
    private final int numShards;

    public static <O, R> NoOutput<O, R> create(int numShards) {
        return new NoOutput<O, R>(numShards);
    }

    public NoOutput(int numShards) {
        this.numShards = numShards;
    }

    @Override
    public List<? extends OutputWriter<O>> createWriters() {
        ImmutableList.Builder out = ImmutableList.builder();
        for (int i = 0; i < this.numShards; ++i) {
            out.add(new Writer());
        }
        return out.build();
    }

    @Override
    public R finish(List<? extends OutputWriter<O>> writers) {
        return null;
    }

    private static class Writer<O>
    extends OutputWriter<O> {
        private static final long serialVersionUID = 524459343516880300L;

        private Writer() {
        }

        @Override
        public void write(O object) {
            throw new RuntimeException("Attempt to write to NoOutput: " + object);
        }

        @Override
        public void close() {
        }
    }
}

