/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.outputs;

import com.google.appengine.labs.repackaged.com.google.common.base.Function;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.mapreduce.Output;
import com.google.appengine.tools.mapreduce.OutputWriter;
import com.google.appengine.tools.mapreduce.outputs.ForwardingOutputWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Logger;

public class StringOutput<O, R>
extends Output<O, R> {
    private static final long serialVersionUID = 390838532348847158L;
    private static final Logger log = Logger.getLogger(StringOutput.class.getName());
    private final Function<O, String> fn;
    private final String terminator;
    private final String charsetName;
    private final Output<ByteBuffer, R> sink;

    public StringOutput(Function<O, String> fn, String terminator, String charsetName, Output<ByteBuffer, R> sink) {
        this.fn = Preconditions.checkNotNull(fn, "Null fn");
        this.terminator = Preconditions.checkNotNull(terminator, "Null terminator");
        this.charsetName = Preconditions.checkNotNull(charsetName, "Null charsetName");
        this.sink = Preconditions.checkNotNull(sink, "Null sink");
        Charset.forName(charsetName);
    }

    public StringOutput(String terminator, String charsetName, Output<ByteBuffer, R> sink) {
        this(new ToStringFn(), terminator, charsetName, sink);
    }

    public StringOutput(String terminator, Output<ByteBuffer, R> sink) {
        this(terminator, "UTF-8", sink);
    }

    @Override
    public List<? extends OutputWriter<O>> createWriters() throws IOException {
        List<OutputWriter<ByteBuffer>> sinkWriters = this.sink.createWriters();
        ImmutableList.Builder out = ImmutableList.builder();
        for (OutputWriter<ByteBuffer> sinkWriter : sinkWriters) {
            out.add(new Writer<O>(sinkWriter, this.fn, this.terminator, this.charsetName));
        }
        return out.build();
    }

    @Override
    public R finish(List<? extends OutputWriter<O>> writers) throws IOException {
        ImmutableList.Builder sinkWriters = ImmutableList.builder();
        for (OutputWriter<O> w : writers) {
            Writer writer = (Writer)w;
            sinkWriters.add(writer.out);
        }
        return this.sink.finish((List<OutputWriter<ByteBuffer>>)((Object)sinkWriters.build()));
    }

    private static class ToStringFn<O>
    implements Function<O, String>,
    Serializable {
        private static final long serialVersionUID = 158579098752936256L;

        private ToStringFn() {
        }

        @Override
        public String apply(O in) {
            return "" + in;
        }
    }

    private static class Writer<O>
    extends ForwardingOutputWriter<O> {
        private static final long serialVersionUID = 142086167097140914L;
        private final OutputWriter<ByteBuffer> out;
        private final Function<O, String> fn;
        private final String terminator;
        private final String charsetName;
        private transient Charset charset;

        Writer(OutputWriter<ByteBuffer> out, Function<O, String> fn, String terminator, String charsetName) {
            this.out = Preconditions.checkNotNull(out, "Null out");
            this.fn = Preconditions.checkNotNull(fn, "Null fn");
            this.terminator = Preconditions.checkNotNull(terminator, "Null terminator");
            this.charsetName = Preconditions.checkNotNull(charsetName, "Null charsetName");
        }

        @Override
        public void beginSlice() throws IOException {
            super.beginSlice();
            this.charset = Charset.forName(this.charsetName);
        }

        @Override
        protected OutputWriter<?> getDelegate() {
            return this.out;
        }

        @Override
        public void write(O value) throws IOException {
            this.out.write(this.charset.encode(this.fn.apply(value) + this.terminator));
        }
    }
}

