/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.FutureList;
import com.google.appengine.tools.pipeline.FutureValue;
import com.google.appengine.tools.pipeline.ImmediateValue;
import com.google.appengine.tools.pipeline.Job0;
import com.google.appengine.tools.pipeline.Job1;
import com.google.appengine.tools.pipeline.Job2;
import com.google.appengine.tools.pipeline.Job3;
import com.google.appengine.tools.pipeline.Job4;
import com.google.appengine.tools.pipeline.Job5;
import com.google.appengine.tools.pipeline.Job6;
import com.google.appengine.tools.pipeline.JobSetting;
import com.google.appengine.tools.pipeline.PromisedValue;
import com.google.appengine.tools.pipeline.Value;
import com.google.appengine.tools.pipeline.impl.FutureValueImpl;
import com.google.appengine.tools.pipeline.impl.PipelineManager;
import com.google.appengine.tools.pipeline.impl.PromisedValueImpl;
import com.google.appengine.tools.pipeline.impl.backend.UpdateSpec;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import java.io.Serializable;
import java.util.List;

public abstract class Job<E>
implements Serializable {
    private static final long serialVersionUID = 868736209042268959L;
    private transient JobRecord thisJobRecord;
    private transient UpdateSpec updateSpec;
    private transient String currentRunGUID;

    private void setJobRecord(JobRecord jobRecord) {
        this.thisJobRecord = jobRecord;
    }

    private void setUpdateSpec(UpdateSpec spec) {
        this.updateSpec = spec;
    }

    private void setCurrentRunGuid(String guid) {
        this.currentRunGUID = guid;
    }

    protected <T> FutureValue<T> futureCallUnchecked(JobSetting[] settings, Job<?> jobInstance, Object ... params) {
        JobRecord childJobRecord = PipelineManager.registerNewJobRecord(this.updateSpec, settings, this.thisJobRecord, this.currentRunGUID, jobInstance, params);
        this.thisJobRecord.appendChildKey(childJobRecord.getKey());
        return new FutureValueImpl(childJobRecord.getOutputSlotInflated());
    }

    protected <T> FutureValue<T> futureCall(Job0<T> jobInstance, JobSetting ... settings) {
        return this.futureCallUnchecked(settings, jobInstance, new Object[0]);
    }

    protected <T, T1> FutureValue<T> futureCall(Job1<T, T1> jobInstance, Value<T1> v1, JobSetting ... settings) {
        return this.futureCallUnchecked(settings, jobInstance, v1);
    }

    protected <T, T1, T2> FutureValue<T> futureCall(Job2<T, T1, T2> jobInstance, Value<T1> v1, Value<T2> v2, JobSetting ... settings) {
        return this.futureCallUnchecked(settings, jobInstance, v1, v2);
    }

    protected <T, T1, T2, T3> FutureValue<T> futureCall(Job3<T, T1, T2, T3> jobInstance, Value<T1> v1, Value<T2> v2, Value<T3> v3, JobSetting ... settings) {
        return this.futureCallUnchecked(settings, jobInstance, v1, v2, v3);
    }

    protected <T, T1, T2, T3, T4> FutureValue<T> futureCall(Job4<T, T1, T2, T3, T4> jobInstance, Value<T1> v1, Value<T2> v2, Value<T3> v3, Value<T4> v4, JobSetting ... settings) {
        return this.futureCallUnchecked(settings, jobInstance, v1, v2, v3, v4);
    }

    protected <T, T1, T2, T3, T4, T5> FutureValue<T> futureCall(Job5<T, T1, T2, T3, T4, T5> jobInstance, Value<T1> v1, Value<T2> v2, Value<T3> v3, Value<T4> v4, Value<T5> v5, JobSetting ... settings) {
        return this.futureCallUnchecked(settings, jobInstance, v1, v2, v3, v4, v5);
    }

    protected <T, T1, T2, T3, T4, T5, T6> FutureValue<T> futureCall(Job6<T, T1, T2, T3, T4, T5, T6> jobInstance, Value<T1> v1, Value<T2> v2, Value<T3> v3, Value<T4> v4, Value<T5> v5, Value<T6> v6, JobSetting ... settings) {
        return this.futureCallUnchecked(settings, jobInstance, v1, v2, v3, v4, v5, v6);
    }

    protected <F> PromisedValue<F> newPromise(Class<F> klass) {
        PromisedValueImpl promisedValue = new PromisedValueImpl(this.getPipelineKey(), this.thisJobRecord.getKey(), this.currentRunGUID);
        this.updateSpec.getNonTransactionalGroup().includeSlot(promisedValue.getSlot());
        return promisedValue;
    }

    public static <F> ImmediateValue<F> immediate(F value) {
        return new ImmediateValue<F>(value);
    }

    public static JobSetting.WaitForSetting waitFor(FutureValue<?> fv) {
        return new JobSetting.WaitForSetting(fv);
    }

    public static JobSetting.BackoffFactor backOffFactor(int factor) {
        return new JobSetting.BackoffFactor(factor);
    }

    public static JobSetting.BackoffSeconds backOffSeconds(int seconds) {
        return new JobSetting.BackoffSeconds(seconds);
    }

    public static JobSetting.MaxAttempts maxAttempts(int attempts) {
        return new JobSetting.MaxAttempts(attempts);
    }

    public static JobSetting.OnBackend onBackend(String backend) {
        return new JobSetting.OnBackend(backend);
    }

    public static <F> FutureList<F> futureList(List<? extends Value<F>> listOfValues) {
        return new FutureList(listOfValues);
    }

    protected Key getJobKey() {
        return this.thisJobRecord.getKey();
    }

    protected Key getPipelineKey() {
        return this.thisJobRecord.getRootJobKey();
    }

    protected void setStatusConsoleUrl(String url) {
        this.thisJobRecord.setStatusConsoleUrl(url);
    }
}

