/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.backend;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.tools.pipeline.NoSuchObjectException;
import com.google.appengine.tools.pipeline.impl.backend.AppEngineTaskQueue;
import com.google.appengine.tools.pipeline.impl.backend.PipelineBackEnd;
import com.google.appengine.tools.pipeline.impl.backend.UpdateSpec;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.FanoutTaskRecord;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.PipelineObjects;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.tasks.DeletePipelineTask;
import com.google.appengine.tools.pipeline.impl.tasks.FanoutTask;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import com.google.appengine.tools.pipeline.impl.util.SerializationUtils;
import com.google.appengine.tools.pipeline.impl.util.TestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;

public class AppEngineBackEnd
implements PipelineBackEnd {
    private static final Logger logger = Logger.getLogger(AppEngineBackEnd.class.getName());
    private static final int MAX_ENTITIES_PER_GET = 100;
    private static Random random = new Random();
    private DatastoreService dataStore = DatastoreServiceFactory.getDatastoreService();
    private AppEngineTaskQueue taskQueue = new AppEngineTaskQueue();

    private void putAll(Collection<? extends PipelineModelObject> objects) {
        ArrayList<Entity> entityList = new ArrayList<Entity>(objects.size());
        for (PipelineModelObject pipelineModelObject : objects) {
            logger.finest("Storing: " + pipelineModelObject);
            entityList.add(pipelineModelObject.toEntity());
        }
        this.dataStore.put(entityList);
    }

    private void saveAll(UpdateSpec.Group group) {
        this.putAll(group.getBarriers());
        this.putAll(group.getJobs());
        this.putAll(group.getSlots());
        this.putAll(group.getJobInstanceRecords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transactionallySaveAll(UpdateSpec.Transaction transactionSpec, Key rootJobKey, Key jobKey, JobRecord.State ... expectedStates) {
        Transaction transaction = this.dataStore.beginTransaction();
        try {
            UpdateSpec.TransactionWithTasks transactionWithTasks;
            Collection<Task> tasks;
            if (jobKey != null && expectedStates != null) {
                Entity entity = null;
                try {
                    entity = this.dataStore.get(jobKey);
                }
                catch (EntityNotFoundException e) {
                    throw new RuntimeException("Fatal Pipeline corruption error. No JobRecord found with key = " + jobKey);
                }
                JobRecord jobRecord = new JobRecord(entity);
                JobRecord.State state = jobRecord.getState();
                boolean stateIsExpected = false;
                for (JobRecord.State expectedState : expectedStates) {
                    if (state != expectedState) continue;
                    stateIsExpected = true;
                    break;
                }
                if (!stateIsExpected) {
                    logger.finest("Job " + jobRecord + " is not in one of the expected states: " + expectedStates + " and so transactionallySaveAll() will not continue.");
                    return;
                }
            }
            this.saveAll(transactionSpec);
            if (transactionSpec instanceof UpdateSpec.TransactionWithTasks && (tasks = (transactionWithTasks = (UpdateSpec.TransactionWithTasks)transactionSpec).getTasks()).size() > 0) {
                byte[] encodedTasks = FanoutTask.encodeTasks(tasks);
                FanoutTaskRecord ftRecord = new FanoutTaskRecord(rootJobKey, encodedTasks);
                this.dataStore.put(null, ftRecord.toEntity());
                FanoutTask fannoutTask = new FanoutTask(ftRecord.getKey());
                this.taskQueue.enqueue(fannoutTask);
            }
            transaction.commit();
        }
        finally {
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    private void tryFiveTimes(Operation operation) {
        int attempts = 1;
        while (true) {
            try {
                operation.perform();
                return;
            }
            catch (ConcurrentModificationException e) {
                String logMessage = "ConcurrentModificationException during " + operation.getName() + " attempt " + attempts + ".";
                if (attempts++ < 5) {
                    logger.finest(logMessage + " Trying again.");
                    try {
                        Thread.sleep((long)(((double)random.nextFloat() + 0.05) * 4000.0));
                    }
                    catch (InterruptedException f) {}
                    continue;
                }
                logger.info(logMessage);
                throw e;
            }
            break;
        }
    }

    @Override
    public void enqueue(Task task) {
        this.taskQueue.enqueue(task);
    }

    @Override
    public void saveWithJobStateCheck(final UpdateSpec updateSpec, final Key jobKey, final JobRecord.State ... expectedStates) {
        this.tryFiveTimes(new Operation("save"){

            @Override
            public void perform() {
                AppEngineBackEnd.this.saveAll(updateSpec.getNonTransactionalGroup());
            }
        });
        for (final UpdateSpec.Transaction transactionSpec : updateSpec.getTransactions()) {
            this.tryFiveTimes(new Operation("save"){

                @Override
                public void perform() {
                    AppEngineBackEnd.this.transactionallySaveAll(transactionSpec, updateSpec.getRootJobKey(), null, new JobRecord.State[0]);
                }
            });
        }
        TestUtils.throwHereForTesting("AppEngineBackeEnd.saveWithJobStateCheck.beforeFinalTransaction");
        this.tryFiveTimes(new Operation("save"){

            @Override
            public void perform() {
                AppEngineBackEnd.this.transactionallySaveAll(updateSpec.getFinalTransaction(), updateSpec.getRootJobKey(), jobKey, expectedStates);
            }
        });
    }

    @Override
    public void save(UpdateSpec updateSpec) {
        this.saveWithJobStateCheck(updateSpec, null, new JobRecord.State[0]);
    }

    private Entity queryEntity(Key key) throws EntityNotFoundException {
        return this.dataStore.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entity transactionallyQueryEntity(Key key) throws EntityNotFoundException {
        Transaction transaction = this.dataStore.beginTransaction();
        try {
            Entity entity = this.queryEntity(key);
            return entity;
        }
        finally {
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Key, Entity> transactionallyQueryEntities(Collection<Key> keys) {
        Transaction transaction = this.dataStore.beginTransaction();
        try {
            Map map = this.dataStore.get(keys);
            return map;
        }
        finally {
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    @Override
    public JobRecord queryJob(Key jobKey, JobRecord.InflationType inflationType) throws NoSuchObjectException {
        try {
            Entity entity = this.transactionallyQueryEntity(jobKey);
            JobRecord jobRecord = new JobRecord(entity);
            Barrier runBarrier = null;
            Barrier finalizeBarrier = null;
            Slot outputSlot = null;
            JobInstanceRecord jobInstanceRecord = null;
            switch (inflationType) {
                case FOR_RUN: {
                    runBarrier = this.queryBarrier(jobRecord.getRunBarrierKey(), true, true);
                    finalizeBarrier = this.queryBarrier(jobRecord.getFinalizeBarrierKey(), false, true);
                    jobInstanceRecord = this.queryJobInstanceRecord(jobRecord.getJobInstanceKey());
                    outputSlot = this.querySlot(jobRecord.getOutputSlotKey(), false);
                    break;
                }
                case FOR_FINALIZE: {
                    finalizeBarrier = this.queryBarrier(jobRecord.getFinalizeBarrierKey(), true, true);
                    outputSlot = this.querySlot(jobRecord.getOutputSlotKey(), false);
                    break;
                }
                case FOR_OUTPUT: {
                    outputSlot = this.querySlot(jobRecord.getOutputSlotKey(), false);
                    break;
                }
            }
            jobRecord.inflate(runBarrier, finalizeBarrier, outputSlot, jobInstanceRecord);
            logger.finest("Query returned: " + jobRecord);
            return jobRecord;
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchObjectException(jobKey.toString(), e);
        }
    }

    private Barrier queryBarrier(Key barrierKey, boolean inflate, boolean startNewTransaction) throws EntityNotFoundException {
        Entity entity = startNewTransaction ? this.transactionallyQueryEntity(barrierKey) : this.queryEntity(barrierKey);
        Barrier barrier = new Barrier(entity);
        if (inflate) {
            ArrayList<Barrier> barriers = new ArrayList<Barrier>(1);
            barriers.add(barrier);
            this.inflateBarriers(barriers);
        }
        logger.finest("Querying returned: " + barrier);
        return barrier;
    }

    private JobInstanceRecord queryJobInstanceRecord(Key key) throws EntityNotFoundException {
        Entity entity = this.queryEntity(key);
        return new JobInstanceRecord(entity);
    }

    private void inflateBarriers(Collection<Barrier> barriers) {
        HashSet<Key> keySet = new HashSet<Key>(barriers.size() * 5);
        for (Barrier barrier : barriers) {
            for (Key key : barrier.getWaitingOnKeys()) {
                keySet.add(key);
            }
        }
        Map entityMap = this.dataStore.get(keySet);
        HashMap<Key, Slot> slotMap = new HashMap<Key, Slot>(entityMap.size());
        for (Key key : entityMap.keySet()) {
            Slot s = new Slot((Entity)entityMap.get(key));
            slotMap.put(key, s);
        }
        for (Barrier barrier : barriers) {
            barrier.inflate(slotMap);
        }
    }

    private Map<Key, Entity> getAll(List<Key> keys) throws NoSuchObjectException {
        HashMap<Key, Entity> out = new HashMap<Key, Entity>(keys.size());
        int start = 0;
        while (start < keys.size()) {
            int end = Math.min(keys.size(), start + 100);
            List<Key> batch = keys.subList(start, end);
            Map results = this.dataStore.get(null, batch);
            if (results.size() != batch.size()) {
                ArrayList<Key> missing = new ArrayList<Key>(batch);
                missing.removeAll(results.keySet());
                logger.severe("Missing entities for keys: " + missing + " (and perhaps others)");
                throw new NoSuchObjectException("" + missing.get(0));
            }
            out.putAll(results);
            start = end;
        }
        return out;
    }

    @Override
    public Slot querySlot(Key slotKey, boolean inflate) throws NoSuchObjectException {
        Entity entity;
        try {
            entity = this.transactionallyQueryEntity(slotKey);
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchObjectException(slotKey.toString(), e);
        }
        Slot slot = new Slot(entity);
        if (inflate) {
            Map<Key, Entity> entities = this.getAll(slot.getWaitingOnMeKeys());
            HashMap<Key, Barrier> barriers = new HashMap<Key, Barrier>(entities.size());
            for (Map.Entry<Key, Entity> entry : entities.entrySet()) {
                barriers.put(entry.getKey(), new Barrier(entry.getValue()));
            }
            slot.inflate(barriers);
            this.inflateBarriers(barriers.values());
        }
        return slot;
    }

    @Override
    public Object serlializeValue(Object value) throws IOException {
        return new Blob(SerializationUtils.serialize(value));
    }

    @Override
    public Object deserializeValue(Object serializedVersion) throws IOException {
        return SerializationUtils.deserialize(((Blob)serializedVersion).getBytes());
    }

    @Override
    public void handleFanoutTask(FanoutTask fanoutTask) throws NoSuchObjectException {
        Key fanoutTaskRecordKey = fanoutTask.getRecordKey();
        Entity entity = null;
        try {
            entity = this.dataStore.get(null, fanoutTaskRecordKey);
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchObjectException(fanoutTaskRecordKey.toString(), e);
        }
        FanoutTaskRecord ftRecord = new FanoutTaskRecord(entity);
        byte[] encodedBytes = ftRecord.getPayload();
        this.taskQueue.enqueue(FanoutTask.decodeTasks(encodedBytes));
    }

    public Iterable<Entity> queryAll(String kind, Key rootJobKey, boolean keysOnly, FetchOptions fetchOptions) {
        Query query = new Query(kind);
        if (keysOnly) {
            query.setKeysOnly();
        }
        query.addFilter("rootJobKey", Query.FilterOperator.EQUAL, (Object)rootJobKey);
        PreparedQuery preparedQuery = this.dataStore.prepare(query);
        Iterable returnValue = null != fetchOptions ? preparedQuery.asIterable(fetchOptions) : preparedQuery.asIterable();
        return returnValue;
    }

    private <E extends PipelineModelObject> void putAll(Map<Key, E> listOfObjects, Instantiator<E> instantiator, String kind, Key rootJobKey) {
        for (Entity entity : this.queryAll(kind, rootJobKey, false, null)) {
            listOfObjects.put(entity.getKey(), instantiator.newObject(entity));
        }
    }

    @Override
    public PipelineObjects queryFullPipeline(Key rootJobKey) {
        HashMap<Key, JobRecord> jobs = new HashMap<Key, JobRecord>();
        HashMap<Key, Slot> slots = new HashMap<Key, Slot>();
        HashMap<Key, Barrier> barriers = new HashMap<Key, Barrier>();
        HashMap<Key, JobInstanceRecord> jobInstanceRecords = new HashMap<Key, JobInstanceRecord>();
        this.putAll(barriers, new Instantiator<Barrier>(){

            @Override
            public Barrier newObject(Entity entity) {
                return new Barrier(entity);
            }
        }, "pipeline-barrier", rootJobKey);
        this.putAll(slots, new Instantiator<Slot>(){

            @Override
            public Slot newObject(Entity entity) {
                return new Slot(entity);
            }
        }, "pipeline-slot", rootJobKey);
        this.putAll(jobs, new Instantiator<JobRecord>(){

            @Override
            public JobRecord newObject(Entity entity) {
                JobRecord jobRecord = new JobRecord(entity);
                return jobRecord;
            }
        }, "pipeline-job", rootJobKey);
        this.putAll(jobInstanceRecords, new Instantiator<JobInstanceRecord>(){

            @Override
            public JobInstanceRecord newObject(Entity entity) {
                return new JobInstanceRecord(entity);
            }
        }, "pipeline-jobInstanceRecord", rootJobKey);
        return new PipelineObjects(rootJobKey, jobs, slots, barriers, jobInstanceRecords);
    }

    private int deleteN(String kind, Key rootJobKey, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be positive");
        }
        logger.info("Deleting  " + n + " " + kind + "s with rootJobKey=" + rootJobKey);
        LinkedList<Key> keyList = new LinkedList<Key>();
        FetchOptions fetchOptions = FetchOptions.Builder.withLimit((int)n).chunkSize(Math.min(n, 500));
        for (Entity entity : this.queryAll(kind, rootJobKey, true, fetchOptions)) {
            keyList.add(entity.getKey());
        }
        this.dataStore.delete(keyList);
        return keyList.size();
    }

    private void deleteAll(String kind, Key rootJobKey) {
        logger.info("Deleting all " + kind + " with rootJobKey=" + rootJobKey);
        while (this.deleteN(kind, rootJobKey, 2000) > 0) {
        }
    }

    @Override
    public void deletePipeline(Key rootJobKey, boolean force, boolean async) throws NoSuchObjectException, IllegalStateException {
        if (!force) {
            JobRecord rootJobRecord = this.queryJob(rootJobKey, JobRecord.InflationType.NONE);
            switch (rootJobRecord.getState()) {
                case FINALIZED: 
                case STOPPED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Pipeline is still running: " + rootJobRecord);
                }
            }
        }
        if (async) {
            DeletePipelineTask task = new DeletePipelineTask(rootJobKey, null, force);
            this.taskQueue.enqueue(task);
            return;
        }
        this.deleteAll("pipeline-job", rootJobKey);
        this.deleteAll("pipeline-slot", rootJobKey);
        this.deleteAll("pipeline-barrier", rootJobKey);
        this.deleteAll("pipeline-jobInstanceRecord", rootJobKey);
        this.deleteAll("pipeline-fanoutTask", rootJobKey);
    }

    private static interface Instantiator<E extends PipelineModelObject> {
        public E newObject(Entity var1);
    }

    private abstract class Operation {
        private String name;

        Operation(String name) {
            this.name = name;
        }

        public abstract void perform();

        public String getName() {
            return this.name;
        }
    }
}

