/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.backend;

import com.google.appengine.api.backends.BackendServiceFactory;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.tools.pipeline.impl.backend.PipelineTaskQueue;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Logger;

public class AppEngineTaskQueue
implements PipelineTaskQueue {
    private static final Logger logger = Logger.getLogger(AppEngineTaskQueue.class.getName());
    private static final int MAX_TASKS_PER_ENQUEUE = 100;
    private final Queue taskQueue = QueueFactory.getDefaultQueue();

    @Override
    public void enqueue(Task task) {
        logger.finest("Enqueueing: " + task);
        this.taskQueue.add(this.toTaskOptions(task));
    }

    @Override
    public void enqueue(Collection<Task> tasks) {
        LinkedList<TaskOptions> taskOptionsList = new LinkedList<TaskOptions>();
        for (Task task : tasks) {
            logger.finest("Enqueueing: " + task);
            taskOptionsList.add(this.toTaskOptions(task));
            if (taskOptionsList.size() < 100) continue;
            this.taskQueue.add(taskOptionsList);
            taskOptionsList = new LinkedList();
        }
        if (taskOptionsList.size() > 0) {
            this.taskQueue.add(taskOptionsList);
        }
    }

    private TaskOptions toTaskOptions(Task task) {
        Long delaySeconds;
        TaskOptions taskOptions = TaskOptions.Builder.withUrl((String)"/_ah/pipeline/handleTask");
        if (task.getOnBackend() != null) {
            taskOptions.header("Host", BackendServiceFactory.getBackendService().getBackendAddress(task.getOnBackend()));
        }
        AppEngineTaskQueue.addProperties(taskOptions, task.toProperties());
        String taskName = task.getName();
        if (null != taskName) {
            taskOptions.taskName(taskName);
        }
        if (null != (delaySeconds = task.getDelaySeconds())) {
            taskOptions.countdownMillis(delaySeconds * 1000L);
        }
        return taskOptions;
    }

    private static void addProperties(TaskOptions taskOptions, Properties properties) {
        Enumeration<?> paramNames = properties.propertyNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = properties.getProperty(paramName);
            taskOptions.param(paramName, paramValue);
        }
    }
}

