/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.backend;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.tasks.Task;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UpdateSpec {
    private Group nonTransactionalGroup = new Group();
    private Map<String, Transaction> transactions = new HashMap<String, Transaction>(10);
    private TransactionWithTasks finalTransaction = new TransactionWithTasks();
    private Key rootJobKey;

    public UpdateSpec(Key rootJobKey) {
        this.rootJobKey = rootJobKey;
    }

    public void setRootJobKey(Key rootJobKey) {
        this.rootJobKey = rootJobKey;
    }

    public Key getRootJobKey() {
        return this.rootJobKey;
    }

    public Transaction getTransaction(String transactionName) {
        Transaction transaction = this.transactions.get(transactionName);
        if (null == transaction) {
            transaction = new Transaction();
            this.transactions.put(transactionName, transaction);
        }
        return transaction;
    }

    public Collection<Transaction> getTransactions() {
        return this.transactions.values();
    }

    public TransactionWithTasks getFinalTransaction() {
        return this.finalTransaction;
    }

    public Group getNonTransactionalGroup() {
        return this.nonTransactionalGroup;
    }

    public class TransactionWithTasks
    extends Transaction {
        private static final int INITIAL_SIZE = 20;
        private Set<Task> taskSet;

        public TransactionWithTasks() {
            this.taskSet = new HashSet<Task>(20);
        }

        public void registerTask(Task task) {
            this.taskSet.add(task);
        }

        public Collection<Task> getTasks() {
            return this.taskSet;
        }
    }

    public class Transaction
    extends Group {
    }

    public class Group {
        private static final int INITIAL_SIZE = 20;
        private Map<Key, JobRecord> jobMap = new HashMap<Key, JobRecord>(20);
        private Map<Key, Barrier> barrierMap = new HashMap<Key, Barrier>(20);
        private Map<Key, Slot> slotMap = new HashMap<Key, Slot>(20);
        private Map<Key, JobInstanceRecord> jobInstanceMap = new HashMap<Key, JobInstanceRecord>(20);

        private <E extends PipelineModelObject> void put(Map<Key, E> map, E object) {
            Key key = object.getKey();
            map.put(object.getKey(), object);
        }

        public void includeBarrier(Barrier barrier) {
            this.put(this.barrierMap, barrier);
        }

        public Collection<Barrier> getBarriers() {
            return this.barrierMap.values();
        }

        public void includeJob(JobRecord job) {
            this.put(this.jobMap, job);
        }

        public Collection<JobRecord> getJobs() {
            return this.jobMap.values();
        }

        public void includeSlot(Slot slot) {
            this.put(this.slotMap, slot);
        }

        public Collection<Slot> getSlots() {
            return this.slotMap.values();
        }

        public void includeJobInstanceRecord(JobInstanceRecord record) {
            this.put(this.jobInstanceMap, record);
        }

        public Collection<JobInstanceRecord> getJobInstanceRecords() {
            return this.jobInstanceMap.values();
        }
    }
}

