/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.Job;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.util.SerializationUtils;
import java.io.IOException;

public class JobInstanceRecord
extends PipelineModelObject {
    public static final String DATA_STORE_KIND = "pipeline-jobInstanceRecord";
    public static final String JOB_KEY_PROPERTY = "jobKey";
    public static final String JOB_CLASS_NAME_PROPERTY = "jobClassName";
    public static final String INSTANCE_BYTES_PROPERTY = "bytes";
    private Key jobKey;
    private String jobClass;
    private byte[] instanceBytes;
    private Job<?> jobInstance;

    public JobInstanceRecord(JobRecord job, Job<?> jobInstance) {
        super(job.rootJobKey, job.generatorJobKey, job.graphGUID);
        this.jobKey = job.key;
        this.jobInstance = jobInstance;
        this.jobClass = jobInstance.getClass().getName();
        try {
            this.instanceBytes = SerializationUtils.serialize(jobInstance);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while attempting to serialize the jobInstance " + jobInstance, e);
        }
    }

    public JobInstanceRecord(Entity entity) {
        super(entity);
        this.jobKey = (Key)entity.getProperty(JOB_KEY_PROPERTY);
        this.jobClass = (String)entity.getProperty(JOB_CLASS_NAME_PROPERTY);
        this.instanceBytes = ((Blob)entity.getProperty(INSTANCE_BYTES_PROPERTY)).getBytes();
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setProperty(INSTANCE_BYTES_PROPERTY, (Object)new Blob(this.instanceBytes));
        entity.setProperty(JOB_KEY_PROPERTY, (Object)this.jobKey);
        entity.setProperty(JOB_CLASS_NAME_PROPERTY, (Object)this.jobClass);
        return entity;
    }

    @Override
    public String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    public Key getJobKey() {
        return this.jobKey;
    }

    public String getJobClass() {
        return this.jobClass;
    }

    public synchronized Job<?> getJobInstanceDeserialized() {
        if (null == this.jobInstance) {
            try {
                this.jobInstance = (Job)SerializationUtils.deserialize(this.instanceBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jobInstance;
    }
}

