/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.tools.pipeline.Job;
import com.google.appengine.tools.pipeline.JobInfo;
import com.google.appengine.tools.pipeline.JobSetting;
import com.google.appengine.tools.pipeline.impl.FutureValueImpl;
import com.google.appengine.tools.pipeline.impl.model.Barrier;
import com.google.appengine.tools.pipeline.impl.model.JobInstanceRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineModelObject;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class JobRecord
extends PipelineModelObject
implements JobInfo {
    public static final String DATA_STORE_KIND = "pipeline-job";
    private static final String JOB_INSTANCE_PROPERTY = "jobInstance";
    private static final String RUN_BARRIER_PROPERTY = "runBarrier";
    private static final String FINALIZE_BARRIER_PROPERTY = "finalizeBarrier";
    private static final String STATE_PROPERTY = "state";
    private static final String OUTPUT_SLOT_PROPERTY = "outputSlot";
    private static final String ERROR_MESSAGE_PROPERTY = "errorMessage";
    private static final String START_TIME_PROPERTY = "startTime";
    private static final String END_TIME_PROPERTY = "endTime";
    private static final String CHILD_KEYS_PROPERTY = "childKeys";
    private static final String ATTEMPT_NUM_PROPERTY = "attemptNum";
    private static final String MAX_ATTEMPTS_PROPERTY = "maxAttempts";
    private static final String BACKOFF_SECONDS_PROPERTY = "backoffSeconds";
    private static final String BACKOFF_FACTOR_PROPERTY = "backoffFactor";
    private static final String ON_BACKEND_PROPERTY = "onBackend";
    private static final String CHILD_GRAPH_GUID_PROPERTY = "childGraphGuid";
    private static final String STATUS_CONSOLE_URL = "statusConsoleUrl";
    private Key jobInstanceKey;
    private Key runBarrierKey;
    private Key finalizeBarrierKey;
    private Key outputSlotKey;
    private State state;
    private String errorMessage;
    private Date startTime;
    private Date endTime;
    private String childGraphGuid;
    private List<Key> childKeys;
    private long attemptNumber = 0L;
    private long maxAttempts = 3L;
    private long backoffSeconds = 15L;
    private long backoffFactor = 2L;
    private String onBackend = null;
    private String statusConsoleUrl = null;
    private Barrier runBarrierInflated;
    private Barrier finalizeBarrierInflated;
    private Slot outputSlotInflated;
    private JobInstanceRecord jobInstanceRecordInflated;

    public JobRecord(Entity entity) {
        super(entity);
        Text errorMessageText;
        this.jobInstanceKey = (Key)entity.getProperty(JOB_INSTANCE_PROPERTY);
        this.finalizeBarrierKey = (Key)entity.getProperty(FINALIZE_BARRIER_PROPERTY);
        this.runBarrierKey = (Key)entity.getProperty(RUN_BARRIER_PROPERTY);
        this.outputSlotKey = (Key)entity.getProperty(OUTPUT_SLOT_PROPERTY);
        this.state = State.valueOf((String)entity.getProperty(STATE_PROPERTY));
        Text childGraphGuidText = (Text)entity.getProperty(CHILD_GRAPH_GUID_PROPERTY);
        if (null != childGraphGuidText) {
            this.childGraphGuid = childGraphGuidText.getValue();
        }
        if (null != (errorMessageText = (Text)entity.getProperty(ERROR_MESSAGE_PROPERTY))) {
            this.errorMessage = errorMessageText.getValue();
        }
        this.startTime = (Date)entity.getProperty(START_TIME_PROPERTY);
        this.endTime = (Date)entity.getProperty(END_TIME_PROPERTY);
        this.childKeys = (List)entity.getProperty(CHILD_KEYS_PROPERTY);
        if (null == this.childKeys) {
            this.childKeys = new LinkedList<Key>();
        }
        this.attemptNumber = (Long)entity.getProperty(ATTEMPT_NUM_PROPERTY);
        this.maxAttempts = (Long)entity.getProperty(MAX_ATTEMPTS_PROPERTY);
        this.backoffSeconds = (Long)entity.getProperty(BACKOFF_SECONDS_PROPERTY);
        this.backoffFactor = (Long)entity.getProperty(BACKOFF_FACTOR_PROPERTY);
        this.onBackend = (String)entity.getProperty(ON_BACKEND_PROPERTY);
        this.statusConsoleUrl = (String)entity.getProperty(STATUS_CONSOLE_URL);
    }

    @Override
    public Entity toEntity() {
        Entity entity = this.toProtoEntity();
        entity.setProperty(JOB_INSTANCE_PROPERTY, (Object)this.jobInstanceKey);
        entity.setProperty(FINALIZE_BARRIER_PROPERTY, (Object)this.finalizeBarrierKey);
        entity.setProperty(RUN_BARRIER_PROPERTY, (Object)this.runBarrierKey);
        entity.setProperty(OUTPUT_SLOT_PROPERTY, (Object)this.outputSlotKey);
        entity.setProperty(STATE_PROPERTY, (Object)this.state.toString());
        if (null != this.errorMessage) {
            entity.setUnindexedProperty(ERROR_MESSAGE_PROPERTY, (Object)new Text(this.errorMessage));
        }
        if (null != this.childGraphGuid) {
            entity.setUnindexedProperty(CHILD_GRAPH_GUID_PROPERTY, (Object)new Text(this.childGraphGuid));
        }
        if (null != this.startTime) {
            entity.setProperty(START_TIME_PROPERTY, (Object)this.startTime);
        }
        if (null != this.endTime) {
            entity.setProperty(END_TIME_PROPERTY, (Object)this.endTime);
        }
        if (null != this.childKeys) {
            entity.setProperty(CHILD_KEYS_PROPERTY, this.childKeys);
        }
        entity.setProperty(ATTEMPT_NUM_PROPERTY, (Object)this.attemptNumber);
        entity.setProperty(MAX_ATTEMPTS_PROPERTY, (Object)this.maxAttempts);
        entity.setProperty(BACKOFF_SECONDS_PROPERTY, (Object)this.backoffSeconds);
        entity.setProperty(BACKOFF_FACTOR_PROPERTY, (Object)this.backoffFactor);
        if (null != this.onBackend) {
            entity.setProperty(ON_BACKEND_PROPERTY, (Object)this.onBackend);
        }
        if (null != this.statusConsoleUrl) {
            entity.setProperty(STATUS_CONSOLE_URL, (Object)this.statusConsoleUrl);
        }
        return entity;
    }

    public JobRecord(Key rootJobKeyParam, Key generatorJobKeyParam, String graphGUIDParam, Job<?> jobInstance, JobSetting[] settings) {
        super(rootJobKeyParam, generatorJobKeyParam, graphGUIDParam);
        this.jobInstanceRecordInflated = new JobInstanceRecord(this, jobInstance);
        this.jobInstanceKey = this.jobInstanceRecordInflated.key;
        this.runBarrierInflated = new Barrier(Barrier.Type.RUN, this);
        this.runBarrierKey = this.runBarrierInflated.key;
        this.finalizeBarrierInflated = new Barrier(Barrier.Type.FINALIZE, this);
        this.finalizeBarrierKey = this.finalizeBarrierInflated.key;
        this.outputSlotInflated = new Slot(this.rootJobKey, this.generatorJobKey, this.graphGUID);
        this.outputSlotInflated.setSourceJobKey(this.key);
        this.outputSlotKey = this.outputSlotInflated.key;
        this.childKeys = new LinkedList<Key>();
        this.state = State.WAITING_TO_RUN;
        for (JobSetting setting : settings) {
            this.applySetting(setting);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applySetting(JobSetting setting) {
        if (setting instanceof JobSetting.WaitForSetting) {
            JobSetting.WaitForSetting wf = (JobSetting.WaitForSetting)setting;
            FutureValueImpl fv = (FutureValueImpl)wf.getFutureValue();
            Slot slot = fv.getSlot();
            this.runBarrierInflated.addPhantomArgumentSlot(slot);
            return;
        } else if (setting instanceof JobSetting.IntValuedSetting) {
            int value = ((JobSetting.IntValuedSetting)setting).getValue();
            if (setting instanceof JobSetting.BackoffSeconds) {
                this.backoffSeconds = value;
                return;
            } else if (setting instanceof JobSetting.BackoffFactor) {
                this.backoffFactor = value;
                return;
            } else {
                if (!(setting instanceof JobSetting.MaxAttempts)) throw new RuntimeException("Unrecognized JobOption class " + setting.getClass().getName());
                this.maxAttempts = value;
            }
            return;
        } else {
            if (!(setting instanceof JobSetting.OnBackend)) throw new RuntimeException("Unrecognized JobOption class " + setting.getClass().getName());
            this.onBackend = ((JobSetting.OnBackend)setting).getValue();
        }
    }

    @Override
    public String getDatastoreKind() {
        return DATA_STORE_KIND;
    }

    private static boolean checkForInflate(PipelineModelObject object, Key expectedGuid, String name) {
        if (null == object) {
            return false;
        }
        if (!expectedGuid.equals((Object)object.getKey())) {
            throw new IllegalArgumentException("Wrong guid for " + name + ". Expected " + expectedGuid + " but was " + object.getKey());
        }
        return true;
    }

    public void inflate(Barrier runBarrier, Barrier finalizeBarrier, Slot outputSlot, JobInstanceRecord jobInstanceRecord) {
        if (JobRecord.checkForInflate(runBarrier, this.runBarrierKey, RUN_BARRIER_PROPERTY)) {
            this.runBarrierInflated = runBarrier;
        }
        if (JobRecord.checkForInflate(finalizeBarrier, this.finalizeBarrierKey, FINALIZE_BARRIER_PROPERTY)) {
            this.finalizeBarrierInflated = finalizeBarrier;
        }
        if (JobRecord.checkForInflate(outputSlot, this.outputSlotKey, OUTPUT_SLOT_PROPERTY)) {
            this.outputSlotInflated = outputSlot;
        }
        if (JobRecord.checkForInflate(jobInstanceRecord, this.jobInstanceKey, "jobInstanceRecord")) {
            this.jobInstanceRecordInflated = jobInstanceRecord;
        }
    }

    public Key getRunBarrierKey() {
        return this.runBarrierKey;
    }

    public Barrier getRunBarrierInflated() {
        return this.runBarrierInflated;
    }

    public Key getFinalizeBarrierKey() {
        return this.finalizeBarrierKey;
    }

    public Barrier getFinalizeBarrierInflated() {
        return this.finalizeBarrierInflated;
    }

    public Key getOutputSlotKey() {
        return this.outputSlotKey;
    }

    public Slot getOutputSlotInflated() {
        return this.outputSlotInflated;
    }

    public Key getJobInstanceKey() {
        return this.jobInstanceKey;
    }

    public JobInstanceRecord getJobInstanceInflated() {
        return this.jobInstanceRecordInflated;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setChildGraphGuid(String guid) {
        this.childGraphGuid = guid;
    }

    public State getState() {
        return this.state;
    }

    public int getAttemptNumber() {
        return (int)this.attemptNumber;
    }

    public void incrementAttemptNumber() {
        ++this.attemptNumber;
    }

    public int getBackoffSeconds() {
        return (int)this.backoffSeconds;
    }

    public int getBackoffFactor() {
        return (int)this.backoffFactor;
    }

    public int getMaxAttempts() {
        return (int)this.maxAttempts;
    }

    public String getOnBackend() {
        return this.onBackend;
    }

    public String getStatusConsoleUrl() {
        return this.statusConsoleUrl;
    }

    public void setStatusConsoleUrl(String statusConsoleUrl) {
        this.statusConsoleUrl = statusConsoleUrl;
    }

    public void appendChildKey(Key key) {
        this.childKeys.add(key);
    }

    public List<Key> getChildKeys() {
        return this.childKeys;
    }

    public String getChildGraphGuid() {
        return this.childGraphGuid;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    @Override
    public JobInfo.State getJobState() {
        switch (this.state) {
            case WAITING_TO_RUN: 
            case WAITING_TO_FINALIZE: {
                return JobInfo.State.RUNNING;
            }
            case FINALIZED: {
                return JobInfo.State.COMPLETED_SUCCESSFULLY;
            }
            case STOPPED: {
                if (null == this.errorMessage) {
                    return JobInfo.State.STOPPED_BY_REQUEST;
                }
                return JobInfo.State.STOPPED_BY_ERROR;
            }
            case RETRY: {
                return JobInfo.State.WAITING_TO_RETRY;
            }
        }
        throw new RuntimeException("Unrecognized state: " + (Object)((Object)this.state));
    }

    @Override
    public Object getOutput() {
        if (null == this.outputSlotInflated) {
            return null;
        }
        return this.outputSlotInflated.getValue();
    }

    @Override
    public String getError() {
        return this.errorMessage;
    }

    private String getJobInstanceString() {
        if (null == this.jobInstanceRecordInflated) {
            return "jobInstanceKey=" + this.jobInstanceKey;
        }
        return this.jobInstanceRecordInflated.getJobInstanceDeserialized().getClass().getName();
    }

    public String toString() {
        return "JobRecord [" + this.key.getName() + ", " + (Object)((Object)this.state) + ", " + this.getJobInstanceString() + ", runBarrier=" + this.runBarrierKey.getName() + ", finalizeBarrier=" + this.finalizeBarrierKey.getName() + ", outputSlot=" + this.outputSlotKey.getName() + "]";
    }

    public static enum InflationType {
        NONE,
        FOR_RUN,
        FOR_FINALIZE,
        FOR_OUTPUT;

    }

    public static enum State {
        WAITING_TO_RUN,
        WAITING_TO_FINALIZE,
        FINALIZED,
        STOPPED,
        RETRY;

    }
}

