/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.model;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.util.GUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class PipelineModelObject {
    public static final String ROOT_JOB_KEY_PROPERTY = "rootJobKey";
    private static final String GENERATOR_JOB_PROPERTY = "generatorJobKey";
    private static final String GRAPH_GUID_PROPERTY = "graphGUID";
    protected Key key;
    protected Key rootJobKey;
    protected Key generatorJobKey;
    protected String graphGUID;

    protected PipelineModelObject(Key rootJobKey, Key egParentKey, Key thisKey, Key generatorJobKey, String graphGUID) {
        this.key = thisKey;
        this.rootJobKey = rootJobKey;
        this.generatorJobKey = generatorJobKey;
        this.graphGUID = graphGUID;
        if (null == rootJobKey) {
            if (this instanceof JobRecord) {
                if (null != thisKey) {
                    throw new IllegalArgumentException("rootJobKey is null and thisKey is not null");
                }
                if (null != egParentKey) {
                    throw new IllegalArgumentException("rootJobKey is null and parentKey is not null");
                }
            } else {
                throw new IllegalArgumentException("rootJobKey is null");
            }
        }
        if (null == this.key) {
            this.key = PipelineModelObject.generateKey(egParentKey, this.getDatastoreKind());
        } else if (egParentKey != null) {
            throw new IllegalArgumentException("You may not specify both thisKey and parentKey");
        }
        if (null == rootJobKey) {
            this.rootJobKey = this.key;
        }
        if (!(generatorJobKey == null && graphGUID == null || generatorJobKey != null && graphGUID != null)) {
            throw new IllegalArgumentException("Either neither or both of generatorParentJobKey and graphGUID must be set.");
        }
    }

    protected PipelineModelObject(Key rootJobKey, Key generatorJobKey, String graphGUID) {
        this(rootJobKey, null, null, generatorJobKey, graphGUID);
    }

    protected PipelineModelObject(Entity entity) {
        this(PipelineModelObject.extractRootJobKey(entity), null, PipelineModelObject.extractKey(entity), PipelineModelObject.extractGeneratorJobKey(entity), PipelineModelObject.extractGraphGUID(entity));
        String expectedEntityType = this.getDatastoreKind();
        if (!this.getDatastoreKind().equals(PipelineModelObject.extractType(entity))) {
            throw new IllegalArgumentException("The entity is not of kind " + this.getDatastoreKind());
        }
    }

    private static Key generateKey(Key parentKey, String kind) {
        String name = GUIDGenerator.nextGUID();
        Key key = null == parentKey ? KeyFactory.createKey((String)kind, (String)name) : parentKey.getChild(kind, name);
        return key;
    }

    private static Key extractRootJobKey(Entity entity) {
        return (Key)entity.getProperty(ROOT_JOB_KEY_PROPERTY);
    }

    private static Key extractGeneratorJobKey(Entity entity) {
        return (Key)entity.getProperty(GENERATOR_JOB_PROPERTY);
    }

    private static String extractGraphGUID(Entity entity) {
        return (String)entity.getProperty(GRAPH_GUID_PROPERTY);
    }

    private static String extractType(Entity entity) {
        return entity.getKind();
    }

    private static Key extractKey(Entity entity) {
        return entity.getKey();
    }

    public abstract Entity toEntity();

    protected Entity toProtoEntity() {
        Entity entity = new Entity(this.key);
        entity.setProperty(ROOT_JOB_KEY_PROPERTY, (Object)this.rootJobKey);
        if (this.generatorJobKey != null) {
            entity.setUnindexedProperty(GENERATOR_JOB_PROPERTY, (Object)this.generatorJobKey);
        }
        if (this.graphGUID != null) {
            entity.setUnindexedProperty(GRAPH_GUID_PROPERTY, (Object)this.graphGUID);
        }
        return entity;
    }

    public Key getKey() {
        return this.key;
    }

    public Key getRootJobKey() {
        return this.rootJobKey;
    }

    public Key getGeneratorJobKey() {
        return this.generatorJobKey;
    }

    public String getGraphGuid() {
        return this.graphGUID;
    }

    public abstract String getDatastoreKind();

    protected static <E> List<E> buildInflated(Collection<Key> listOfIds, Map<Key, E> pool) {
        ArrayList<E> list = new ArrayList<E>(listOfIds.size());
        for (Key id : listOfIds) {
            E x = pool.get(id);
            if (null == x) {
                throw new RuntimeException("No object found in pool with id=" + id);
            }
            list.add(x);
        }
        return list;
    }

    protected static <E> List<E> getListProperty(String propertyName, Entity entity) {
        LinkedList list = (LinkedList)entity.getProperty(propertyName);
        if (null == list) {
            list = new LinkedList();
        }
        return list;
    }
}

