/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.pipeline.impl.model.JobRecord;
import com.google.appengine.tools.pipeline.impl.model.PipelineObjects;
import com.google.appengine.tools.pipeline.impl.model.Slot;
import com.google.appengine.tools.pipeline.impl.model.SlotDescriptor;
import com.google.appengine.tools.pipeline.impl.util.JsonUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonGenerator {
    private PipelineObjects pipelineObjects;
    private String jsonRepresentation;
    private static final String ROOT_PIPELINE_ID = "rootPipelineId";
    private static final String SLOTS = "slots";
    private static final String PIPELINES = "pipelines";
    private static final String SLOT_STATUS = "status";
    private static final String FILLED_STATUS = "filled";
    private static final String WAITING_STATUS = "waiting";
    private static final String SLOT_VALUE = "value";
    private static final String SLOT_FILL_TIME = "fillTimeMs";
    private static final String SLOT_SOURCE_JOB = "fillerPipelineId";
    private static final String JOB_CLASS = "classPath";
    private static final String JOB_STATUS = "status";
    private static final String RUN_STATUS = "run";
    private static final String DONE_STATUS = "done";
    private static final String ABORTED_STATUS = "aborted";
    private static final String RETRY_STATUS = "retry";
    private static final String JOB_START_TIME = "startTimeMs";
    private static final String JOB_END_TIME = "endTimeMs";
    private static final String JOB_CHILDREN = "children";
    private static final String JOB_ARGS = "args";
    private static final String JOB_OUTPUTS = "outputs";
    private static final String JOB_QUEUE_NAME = "queueName";
    private static final String JOB_AFTER_SLOT_KEYS = "afterSlotKeys";
    private static final String JOB_CURRENT_ATTEMPT = "currentAttempt";
    private static final String JOB_MAX_ATTEMPTS = "maxAttempts";
    private static final String JOB_BACKOFF_SECONDS = "backoffSeconds";
    private static final String JOB_BACKOFF_FACTOR = "backoffFactor";
    private static final String JOB_KWARGS = "kwargs";
    private static final String JOB_LAST_RETRY_MESSAGE = "lastRetryMessage";
    private static final String JOB_ABORT_MESSAGE = "abortMessage";
    private static final String DEFAULT_OUTPUT_NAME = "default";
    private static final String JOB_STATUS_CONSOLE_URL = "statusConsoleUrl";

    public JsonGenerator(PipelineObjects pipelineObjects) {
        this.pipelineObjects = pipelineObjects;
    }

    public synchronized String getJson() {
        if (null == this.jsonRepresentation) {
            this.buildJsonRepresentation();
        }
        return this.jsonRepresentation;
    }

    private static String toString(Key key) {
        return KeyFactory.keyToString((Key)key);
    }

    private void buildJsonRepresentation() {
        Map<String, Object> mapRepresentation = this.toMapRepresentation();
        this.jsonRepresentation = JsonUtils.mapToJson(mapRepresentation);
    }

    private Map<String, Object> toMapRepresentation() {
        HashMap<String, Map<String, Object>> slotMap = new HashMap<String, Map<String, Object>>(this.pipelineObjects.slots.size());
        HashMap<String, Map<String, Object>> jobMap = new HashMap<String, Map<String, Object>>(this.pipelineObjects.jobs.size());
        HashMap<String, Object> topLevel = new HashMap<String, Object>(3);
        topLevel.put(ROOT_PIPELINE_ID, this.pipelineObjects.rootJob.getKey().getName());
        topLevel.put(SLOTS, slotMap);
        topLevel.put(PIPELINES, jobMap);
        for (Slot slot : this.pipelineObjects.slots.values()) {
            slotMap.put(JsonGenerator.toString(slot.getKey()), this.buildMapRepresentation(slot));
        }
        for (JobRecord jobRecord : this.pipelineObjects.jobs.values()) {
            jobMap.put(jobRecord.getKey().getName(), this.buildMapRepresentation(jobRecord));
        }
        return topLevel;
    }

    private Map<String, Object> buildMapRepresentation(Slot slot) {
        Key sourceJobKey;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        String statusString = slot.isFilled() ? FILLED_STATUS : WAITING_STATUS;
        map.put("status", statusString);
        map.put(SLOT_VALUE, slot.getValue());
        Date fillTime = slot.getFillTime();
        if (null != fillTime) {
            map.put(SLOT_FILL_TIME, fillTime.getTime());
        }
        if (null != (sourceJobKey = slot.getSourceJobKey())) {
            map.put(SLOT_SOURCE_JOB, sourceJobKey.getName());
        }
        return map;
    }

    private Map<String, Object> buildMapRepresentation(JobRecord jobRecord) {
        Date endTime;
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put(JOB_CLASS, jobRecord.getJobInstanceInflated().getJobClass());
        String statusString = null;
        switch (jobRecord.getState()) {
            case WAITING_TO_RUN: {
                statusString = WAITING_STATUS;
                break;
            }
            case WAITING_TO_FINALIZE: {
                statusString = RUN_STATUS;
                break;
            }
            case FINALIZED: {
                statusString = DONE_STATUS;
                break;
            }
            case STOPPED: {
                statusString = ABORTED_STATUS;
                break;
            }
            case RETRY: {
                statusString = RETRY_STATUS;
            }
        }
        map.put("status", statusString);
        Date startTime = jobRecord.getStartTime();
        if (null != startTime) {
            map.put(JOB_START_TIME, startTime.getTime());
        }
        if (null != (endTime = jobRecord.getEndTime())) {
            map.put(JOB_END_TIME, endTime.getTime());
        }
        map.put(JOB_CHILDREN, this.buildArrayRepresentation(jobRecord.getChildKeys()));
        LinkedList<Map<String, Object>> argumentListRepresentation = new LinkedList<Map<String, Object>>();
        LinkedList<String> waitingOnRepresentation = new LinkedList<String>();
        this.populateJobArgumentRepresentation(argumentListRepresentation, waitingOnRepresentation, jobRecord.getRunBarrierInflated().getWaitingOnInflated());
        map.put(JOB_ARGS, argumentListRepresentation);
        map.put(JOB_AFTER_SLOT_KEYS, waitingOnRepresentation);
        HashMap<String, String> allOutputs = new HashMap<String, String>();
        String outputSlotId = JsonGenerator.toString(jobRecord.getOutputSlotKey());
        allOutputs.put(DEFAULT_OUTPUT_NAME, outputSlotId);
        map.put(JOB_OUTPUTS, allOutputs);
        map.put(JOB_QUEUE_NAME, "");
        map.put(JOB_CURRENT_ATTEMPT, jobRecord.getAttemptNumber());
        map.put(JOB_MAX_ATTEMPTS, jobRecord.getMaxAttempts());
        map.put(JOB_BACKOFF_SECONDS, jobRecord.getBackoffSeconds());
        map.put(JOB_BACKOFF_FACTOR, jobRecord.getBackoffFactor());
        map.put(JOB_KWARGS, new HashMap());
        map.put(JOB_LAST_RETRY_MESSAGE, "");
        map.put(JOB_ABORT_MESSAGE, "");
        if (jobRecord.getStatusConsoleUrl() != null) {
            map.put(JOB_STATUS_CONSOLE_URL, jobRecord.getStatusConsoleUrl());
        }
        return map;
    }

    private void populateJobArgumentRepresentation(List<Map<String, Object>> argumentListRepresentation, List<String> waitingOnRepresentation, List<SlotDescriptor> slotDescriptors) {
        for (SlotDescriptor slotDescriptor : slotDescriptors) {
            Slot slot = slotDescriptor.slot;
            String slotId = JsonGenerator.toString(slot.getKey());
            if (slotDescriptor.isPhantom()) {
                waitingOnRepresentation.add(slotId);
                continue;
            }
            argumentListRepresentation.add(this.buildArgumentRepresentation(slotDescriptor.slot));
        }
    }

    private Map<String, Object> buildArgumentRepresentation(Slot slot) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (slot.isFilled()) {
            map.put("type", SLOT_VALUE);
            map.put(SLOT_VALUE, slot.getValue());
        } else {
            map.put("type", "slot");
            map.put("slot_key", JsonGenerator.toString(slot.getKey()));
        }
        return map;
    }

    private String[] buildArrayRepresentation(List<Key> listOfKeys) {
        String[] arrayOfIds = new String[listOfKeys.size()];
        int i = 0;
        for (Key key : listOfKeys) {
            arrayOfIds[i++] = key.getName();
        }
        return arrayOfIds;
    }
}

