/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.servlets;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.tools.pipeline.impl.servlets.JsonHandler;
import com.google.appengine.tools.pipeline.impl.servlets.StaticContentHandler;
import com.google.appengine.tools.pipeline.impl.servlets.TaskHandler;
import com.google.appengine.tools.pipeline.util.Pair;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PipelineServlet
extends HttpServlet {
    private final Logger logger = Logger.getLogger(PipelineServlet.class.getName());
    public static final String BASE_URL = "/_ah/pipeline/";

    public static String makeViewerUrl(Key rootJobKey, Key jobKey) {
        return "/_ah/pipeline/status.html?root=" + rootJobKey.getName() + "#pipeline-" + jobKey.getName();
    }

    private Pair<String, RequestType> parseRequestType(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String path = requestURI.substring(BASE_URL.length());
        RequestType requestType = null;
        for (RequestType rt : RequestType.values()) {
            if (!rt.matches(path)) continue;
            requestType = rt;
            break;
        }
        if (null == requestType) {
            requestType = RequestType.HANDLE_STATIC;
        }
        return new Pair<String, RequestType>(path, requestType);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        Pair<String, RequestType> pair = this.parseRequestType(req);
        RequestType requestType = (RequestType)((Object)pair.second);
        String path = (String)pair.first;
        switch (requestType) {
            case HANDLE_TASK: {
                TaskHandler.doPost(req, resp);
                break;
            }
            case GET_JSON: {
                JsonHandler.doGet(req, resp);
                break;
            }
            case HANDLE_STATIC: {
                StaticContentHandler.doGet(req, resp, path);
                break;
            }
            default: {
                throw new ServletException("Unknown request type: " + (Object)((Object)requestType));
            }
        }
    }

    private static enum RequestType {
        HANDLE_TASK("handleTask"),
        GET_JSON("rpc/tree"),
        HANDLE_STATIC("");

        private String pathComponent;

        private RequestType(String pathComponent) {
            this.pathComponent = pathComponent;
        }

        public boolean matches(String path) {
            return this.pathComponent.equals(path);
        }
    }
}

