/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.pipeline.impl.tasks;

import com.google.appengine.tools.pipeline.impl.tasks.DeletePipelineTask;
import com.google.appengine.tools.pipeline.impl.tasks.FanoutTask;
import com.google.appengine.tools.pipeline.impl.tasks.FinalizeJobTask;
import com.google.appengine.tools.pipeline.impl.tasks.HandleSlotFilledTask;
import com.google.appengine.tools.pipeline.impl.tasks.RunJobTask;
import java.util.Properties;

public abstract class Task {
    protected static final String TASK_TYPE_PARAMETER = "taskType";
    protected String taskName;
    protected Type type;
    protected Long delaySeconds;
    protected String onBackend;

    protected Task(Type t, String name) {
        this.type = t;
        this.taskName = name;
    }

    public static Task fromProperties(Properties properties) {
        String taskTypeString = properties.getProperty(TASK_TYPE_PARAMETER);
        if (null == taskTypeString) {
            throw new IllegalArgumentException("taskType property is missing: " + properties.toString());
        }
        Type type = Type.valueOf(taskTypeString);
        switch (type) {
            case HANDLE_SLOT_FILLED: {
                return new HandleSlotFilledTask(properties);
            }
            case RUN_JOB: {
                return new RunJobTask(properties);
            }
            case FINALIZE_JOB: {
                return new FinalizeJobTask(properties);
            }
            case FAN_OUT: {
                return new FanoutTask(properties);
            }
            case DELETE_PIPELINE: {
                return new DeletePipelineTask(properties);
            }
        }
        throw new RuntimeException("Unrecognized task type: " + (Object)((Object)type));
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.taskName;
    }

    public void setName(String name) {
        this.taskName = name;
    }

    public void setDelaySeconds(long seconds) {
        this.delaySeconds = seconds;
    }

    public Long getDelaySeconds() {
        return this.delaySeconds;
    }

    public void setOnBackend(String backend) {
        this.onBackend = backend;
    }

    public String getOnBackend() {
        return this.onBackend;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty(TASK_TYPE_PARAMETER, this.type.toString());
        this.addProperties(properties);
        return properties;
    }

    protected abstract void addProperties(Properties var1);

    public static enum Type {
        HANDLE_SLOT_FILLED,
        RUN_JOB,
        FINALIZE_JOB,
        FAN_OUT,
        DELETE_PIPELINE;

    }
}

