/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.CreationCostAnalysis;
import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.LinkedHashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class LocalDatastoreCostAnalysis {
    private static final BigDecimal ONE_MILLION = new BigDecimal(1000000);
    private static final BigDecimal DOLLARS_PER_WRITE = new BigDecimal(1).divide(ONE_MILLION);
    private static final BigDecimal PENNIES_PER_WRITE = DOLLARS_PER_WRITE.divide(new BigDecimal(100));
    private static final Comparator<OnestoreEntity.Property> PROPERTY_COMPARATOR = new Comparator<OnestoreEntity.Property>(){

        @Override
        public int compare(OnestoreEntity.Property p1, OnestoreEntity.Property p2) {
            int result = p1.getName().compareTo(p2.getName());
            if (result != 0) {
                return result;
            }
            result = Integer.valueOf(p1.getMeaning()).compareTo(p2.getMeaning());
            if (result != 0) {
                return result;
            }
            return p1.getValue().toByteBuffer().compareTo(p2.getValue().toByteBuffer());
        }
    };
    private static final Comparator<IndexRow> INDEX_ROW_COMPARATOR = new Comparator<IndexRow>(){

        @Override
        public int compare(IndexRow row1, IndexRow row2) {
            for (int i = 0; i < row1.propList.size(); ++i) {
                PropertyWithDirection prop2;
                if (row2.propList.size() <= i) {
                    return 1;
                }
                PropertyWithDirection prop1 = row1.propList.get(i);
                int result = prop1.compareTo(prop2 = row2.propList.get(i));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    };
    private final LocalCompositeIndexManager indexManager;

    public LocalDatastoreCostAnalysis(LocalCompositeIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public CreationCostAnalysis getCreationCostAnalysis(OnestoreEntity.EntityProto e) {
        DatastorePb.Cost cost = this.getWriteCost(e);
        int writeOps = cost.getEntityWrites() + cost.getIndexWrites();
        return new CreationCostAnalysis(writeOps, LocalDatastoreCostAnalysis.writesToPennies(writeOps));
    }

    static BigDecimal writesToPennies(int writes) {
        return PENNIES_PER_WRITE.multiply(new BigDecimal(writes));
    }

    public DatastorePb.Cost getWriteCost(OnestoreEntity.EntityProto newEntity) {
        return this.getWriteOps(null, newEntity);
    }

    public DatastorePb.Cost getWriteOps(OnestoreEntity.EntityProto oldEntity, OnestoreEntity.EntityProto newEntity) {
        DatastorePb.Cost cost = new DatastorePb.Cost().setEntityWrites(0).setIndexWrites(0);
        if (oldEntity != null && ((Object)oldEntity.propertys()).equals(newEntity.propertys()) && ((Object)oldEntity.rawPropertys()).equals(newEntity.rawPropertys())) {
            return cost;
        }
        cost.setEntityWrites(1);
        int indexWrites = this.changedIndexRows(oldEntity, newEntity);
        if (oldEntity == null) {
            ++indexWrites;
        }
        return cost.setIndexWrites(indexWrites);
    }

    int changedIndexRows(OnestoreEntity.EntityProto oldEntity, OnestoreEntity.EntityProto newEntity) {
        List<IndexRow> sortedOldIndexRows = this.buildIndexRows(oldEntity);
        Collections.sort(sortedOldIndexRows, INDEX_ROW_COMPARATOR);
        List<IndexRow> sortedNewIndexRows = this.buildIndexRows(newEntity);
        Collections.sort(sortedNewIndexRows, INDEX_ROW_COMPARATOR);
        int changedRows = 0;
        int oldIndex = 0;
        int newIndex = 0;
        int ancestorCount = newEntity.getKey().getPath().elementSize() - 1;
        while (oldIndex < sortedOldIndexRows.size() || newIndex < sortedNewIndexRows.size()) {
            if (oldIndex == sortedOldIndexRows.size()) {
                changedRows += this.getChangedRowsDelta(sortedNewIndexRows.get(newIndex++), ancestorCount);
                continue;
            }
            if (newIndex == sortedNewIndexRows.size()) {
                changedRows += this.getChangedRowsDelta(sortedOldIndexRows.get(oldIndex++), ancestorCount);
                continue;
            }
            int comparison = INDEX_ROW_COMPARATOR.compare(sortedOldIndexRows.get(oldIndex), sortedNewIndexRows.get(newIndex));
            if (comparison == 0) {
                ++oldIndex;
                ++newIndex;
                continue;
            }
            if (comparison < 0) {
                changedRows += this.getChangedRowsDelta(sortedOldIndexRows.get(oldIndex++), ancestorCount);
                continue;
            }
            changedRows += this.getChangedRowsDelta(sortedNewIndexRows.get(newIndex++), ancestorCount);
        }
        return changedRows;
    }

    private int getChangedRowsDelta(IndexRow indexRow, int ancestorCount) {
        int delta = 1;
        if (indexRow.isAncestor) {
            delta += ancestorCount;
        }
        return delta;
    }

    private static List<OnestoreEntity.Index> getEntityByPropertyIndexes(Set<String> propertyNames) {
        ArrayList sortedPropertyNames = Lists.newArrayList(propertyNames);
        Collections.sort(sortedPropertyNames);
        ArrayList indexes = Lists.newArrayList();
        for (String propName : sortedPropertyNames) {
            OnestoreEntity.Index index = new OnestoreEntity.Index();
            index.addProperty(new OnestoreEntity.Index.Property().setName(propName).setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING));
            indexes.add(index);
            index = new OnestoreEntity.Index();
            index.addProperty(new OnestoreEntity.Index.Property().setName(propName).setDirection(OnestoreEntity.Index.Property.Direction.DESCENDING));
            indexes.add(index);
        }
        return indexes;
    }

    List<IndexRow> buildIndexRows(OnestoreEntity.EntityProto entity) {
        ArrayList indexRows = Lists.newArrayList();
        if (entity == null) {
            return indexRows;
        }
        LinkedHashMultimap propertyMap = LinkedHashMultimap.create();
        for (OnestoreEntity.Property prop : entity.propertys()) {
            propertyMap.put((Object)prop.getName(), (Object)prop);
        }
        Iterable allIndexes = Iterables.concat(this.indexManager.getIndicesForKind(Utils.getKind(entity.getKey())), LocalDatastoreCostAnalysis.getEntityByPropertyIndexes(propertyMap.keySet()));
        block1: for (OnestoreEntity.Index index : allIndexes) {
            ArrayList propertySets = Lists.newArrayList();
            for (OnestoreEntity.Index.Property indexProp : index.propertys()) {
                Set props = propertyMap.get((Object)indexProp.getName());
                if (props.isEmpty()) continue block1;
                propertySets.add(Pair.of((Object)props, (Object)indexProp.getDirectionEnum()));
            }
            LocalDatastoreCostAnalysis.generateIndexPermutations(indexRows, new IndexRow(index.isAncestor()), propertySets, 0);
        }
        return indexRows;
    }

    private static void generateIndexPermutations(List<IndexRow> allRows, IndexRow currentRow, List<Pair<Set<OnestoreEntity.Property>, OnestoreEntity.Index.Property.Direction>> propertySets, int currentPropertyIndex) {
        if (currentPropertyIndex == propertySets.size()) {
            allRows.add(currentRow);
            return;
        }
        Pair<Set<OnestoreEntity.Property>, OnestoreEntity.Index.Property.Direction> currentPropertySet = propertySets.get(currentPropertyIndex);
        for (OnestoreEntity.Property prop : (Set)currentPropertySet.getFirst()) {
            IndexRow currentRowCopy = new IndexRow(currentRow.isAncestor);
            currentRowCopy.propList.addAll(currentRow.propList);
            currentRowCopy.propList.add(new PropertyWithDirection(prop, (OnestoreEntity.Index.Property.Direction)currentPropertySet.getSecond()));
            LocalDatastoreCostAnalysis.generateIndexPermutations(allRows, currentRowCopy, propertySets, currentPropertyIndex + 1);
        }
    }

    static class PropertyWithDirection
    implements Comparable<PropertyWithDirection> {
        final OnestoreEntity.Property prop;
        final OnestoreEntity.Index.Property.Direction direction;

        PropertyWithDirection(OnestoreEntity.Property prop, OnestoreEntity.Index.Property.Direction direction) {
            this.prop = prop;
            this.direction = direction;
        }

        public String toString() {
            return String.format("%s %s", this.prop, this.direction);
        }

        @Override
        public int compareTo(PropertyWithDirection propertyWithDirection) {
            int result = PROPERTY_COMPARATOR.compare(this.prop, propertyWithDirection.prop);
            if (result != 0) {
                return result;
            }
            return this.direction.compareTo((Enum)propertyWithDirection.direction);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyWithDirection that = (PropertyWithDirection)o;
            if (this.direction != that.direction) {
                return false;
            }
            return this.prop.equals(that.prop);
        }

        public int hashCode() {
            int result = this.prop.hashCode();
            result = 31 * result + this.direction.hashCode();
            return result;
        }
    }

    static class IndexRow {
        final List<PropertyWithDirection> propList = Lists.newArrayList();
        final boolean isAncestor;

        IndexRow(boolean ancestor) {
            this.isAncestor = ancestor;
        }
    }
}

