/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log.dev;

import com.google.appengine.api.log.dev.DevLogHandler;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.logservice.LogServicePb;
import java.util.LinkedList;
import java.util.logging.Handler;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalLogService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "logservice";
    private final LinkedList<LogServicePb.RequestLog> logs = new LinkedList();
    private static final int MAX_NUM_LOGS = 1000;

    public String getPackage() {
        return PACKAGE;
    }

    public synchronized LogServicePb.LogReadResponse read(LocalRpcService.Status status, LogServicePb.LogReadRequest request) {
        int i;
        LogServicePb.LogReadResponse response = new LogServicePb.LogReadResponse();
        Integer index = 0;
        if (request.hasOffset()) {
            index = null;
            int requestToFind = Integer.parseInt(request.getOffset().getRequestId());
            for (i = 0; i < this.logs.size(); ++i) {
                int thisRequestId = Integer.parseInt(this.logs.get(i).getRequestId());
                if (requestToFind <= thisRequestId) continue;
                index = i;
                break;
            }
            if (index == null) {
                return response;
            }
        }
        int numResultsFetched = 0;
        for (i = index.intValue(); i < this.logs.size(); ++i) {
            LogServicePb.RequestLog thisLog = null;
            int j = 0;
            for (LogServicePb.RequestLog log : this.logs) {
                if (i == j) {
                    thisLog = log;
                    break;
                }
                ++j;
            }
            if (request.hasStartTime() && request.getStartTime() > thisLog.getEndTime() || request.hasEndTime() && request.getEndTime() <= thisLog.getEndTime() || !request.isIncludeIncomplete() && !thisLog.isFinished() || thisLog.hasVersionId() && !request.versionIds().contains(thisLog.getVersionId())) continue;
            if (request.hasMinimumLogLevel()) {
                boolean logLevelMatched = false;
                for (LogServicePb.LogLine line : thisLog.lines()) {
                    if (line.getLevel() < request.getMinimumLogLevel()) continue;
                    logLevelMatched = true;
                    break;
                }
                if (!logLevelMatched) continue;
            }
            if (request.isIncludeAppLogs()) {
                response.addLog(thisLog);
            } else {
                LogServicePb.RequestLog logCopy = (LogServicePb.RequestLog)thisLog.clone();
                logCopy.clearLine();
                response.addLog(logCopy);
            }
            if ((long)(++numResultsFetched) < request.getCount()) continue;
            if (i + 1 >= this.logs.size()) break;
            String nextOffset = this.logs.get(i).getRequestId();
            LogServicePb.LogOffset offset = new LogServicePb.LogOffset();
            offset.setRequestId(nextOffset);
            response.setOffset(offset);
            break;
        }
        return response;
    }

    public synchronized void addRequestInfo(String appId, String versionId, String requestId, String ip, String nickname, long startTimeUsec, long endTimeUsec, String method, String resource, String httpVersion, int responseSize, String userAgent, boolean complete) {
        LogServicePb.RequestLog log = this.findLogInLogMapOrAddNewLog(requestId);
        log.setAppId(appId);
        String majorVersionId = versionId.split("\\.")[0];
        log.setVersionId(majorVersionId);
        log.setStartTime(startTimeUsec);
        log.setEndTime(endTimeUsec);
        if (ip != null) {
            log.setIp(ip);
        }
        if (nickname != null) {
            log.setNickname(nickname);
        }
        log.setLatency(endTimeUsec - startTimeUsec);
        log.setMcycles(0L);
        log.setMethod(method);
        log.setResource(resource);
        log.setHttpVersion(httpVersion);
        log.setResponseSize((long)responseSize);
        if (userAgent != null) {
            log.setUserAgent(userAgent);
        }
        log.setFinished(complete);
    }

    public synchronized void addAppLogLine(String requestId, long time, int level, String message) {
        if (message == null) {
            return;
        }
        LogServicePb.LogLine line = new LogServicePb.LogLine();
        line.setTime(time);
        line.setLevel(level);
        line.setLogMessage(message);
        LogServicePb.RequestLog log = this.findLogInLogMapOrAddNewLog(requestId);
        log.addLine(line);
    }

    private synchronized LogServicePb.RequestLog findLogInLogMapOrAddNewLog(String requestId) {
        if (requestId == null) {
            requestId = "null";
        }
        for (int i = 0; i < this.logs.size(); ++i) {
            LogServicePb.RequestLog possibleLog = this.logs.get(i);
            if (!possibleLog.getRequestId().equals(requestId)) continue;
            return possibleLog;
        }
        LogServicePb.RequestLog log = new LogServicePb.RequestLog();
        log.setRequestId(requestId);
        LogServicePb.LogOffset offset = new LogServicePb.LogOffset();
        offset.setRequestId(requestId);
        log.setOffset(offset);
        this.logs.addFirst(log);
        if (this.logs.size() > 1000) {
            this.logs.removeLast();
        }
        return log;
    }

    public Handler getLogHandler() {
        return new DevLogHandler(this);
    }

    public synchronized void clear() {
        this.logs.clear();
    }
}

