/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;

public final class BlobInfoStorage {
    private final BlobInfoFactory blobInfoFactory = new BlobInfoFactory();
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();

    public BlobInfo loadBlobInfo(BlobKey blobKey) {
        return this.blobInfoFactory.loadBlobInfo(blobKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobInfo loadGsFileInfo(BlobKey blobKey) {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            Key key = KeyFactory.createKey(null, (String)"__GsFileInfo__", (String)blobKey.getKeyString());
            try {
                Entity entity = this.datastoreService.get(key);
                BlobInfo blobInfo = new BlobInfoFactory().createBlobInfo(entity);
                return blobInfo;
            }
            catch (EntityNotFoundException ex) {
                BlobInfo blobInfo = null;
                NamespaceManager.set((String)namespace);
                return blobInfo;
            }
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBlobInfo(BlobInfo blobInfo) {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            Entity entity = new Entity("__BlobInfo__", blobInfo.getBlobKey().getKeyString());
            entity.setProperty("content_type", (Object)blobInfo.getContentType());
            entity.setProperty("creation", (Object)blobInfo.getCreation());
            entity.setProperty("filename", (Object)blobInfo.getFilename());
            entity.setProperty("size", (Object)blobInfo.getSize());
            entity.setProperty("md5_hash", (Object)blobInfo.getMd5Hash());
            this.datastoreService.put(entity);
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }

    public void deleteBlobInfo(BlobKey blobKey) {
        this.datastoreService.delete(new Key[]{this.getMetadataKeyForBlobKey(blobKey)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Key getMetadataKeyForBlobKey(BlobKey blobKey) {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            if (blobKey.getKeyString().startsWith("encoded_gs_key:")) {
                Key key = KeyFactory.createKey((String)"__GsFileInfo__", (String)blobKey.getKeyString());
                return key;
            }
            Key key = KeyFactory.createKey((String)"__BlobInfo__", (String)blobKey.getKeyString());
            return key;
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteAllBlobInfos() {
        Query q;
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            q = new Query("__BlobInfo__");
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
        for (Entity e : this.datastoreService.prepare(q).asIterable()) {
            this.datastoreService.delete(new Key[]{e.getKey()});
        }
    }
}

