/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQuery;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReferenceOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.appengine.repackaged.com.google.type.LatLngOrBuilder;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.EntityProtoConverter;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.QueryHelper;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DatastoreV4Validator {
    private static final String ANY_PROJECT_ID = "";
    private final EntityV4Validator entityValidatorV4;
    private final CloudDatastoreV1Validator validatorV1;
    private final DatastoreProtoConverter datastoreConverter;

    public DatastoreV4Validator(EntityV4Validator entityValidatorV4, CloudDatastoreV1Validator validatorV1) {
        this.entityValidatorV4 = entityValidatorV4;
        this.validatorV1 = validatorV1;
        this.datastoreConverter = new DatastoreProtoConverter(new EntityProtoConverter(false));
    }

    EntityProtoConverter getEntityConverter() {
        return this.datastoreConverter.getEntityConverter();
    }

    public EntityV4Validator getEntityValidator() {
        return this.entityValidatorV4;
    }

    public void validateRequestInitialized(MessageOrBuilder pb) throws ValidationException {
        List error = pb.findInitializationErrors();
        String string = String.valueOf(error);
        ValidationException.validateAssertion(error.isEmpty(), new StringBuilder(17 + String.valueOf(string).length()).append("not initialized: ").append(string).toString(), new Object[0]);
    }

    public void validateMutations(boolean isTrusted, List<? extends DatastoreV4.MutationOrBuilder> mutations) throws ValidationException {
        try {
            for (DatastoreV4.MutationOrBuilder mutationOrBuilder : mutations) {
                this.validatorV1.validateMutation(ANY_PROJECT_ID, isTrusted, this.toV1Mutation(mutationOrBuilder).build());
            }
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateDeprecatedMutation(boolean isTrusted, DatastoreV4.DeprecatedMutationOrBuilder deprecatedMutation) throws ValidationException {
        try {
            Mutation.Builder mutationV1;
            ValidationConstraint writeConstraint = ValidationConstraint.UPDATE.withTrustedUserContext(isTrusted);
            ValidationConstraint insertAutoIdConstraint = ValidationConstraint.ALLOCATE_ID.withTrustedUserContext(isTrusted);
            this.validateMutations(isTrusted, this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.UPDATE, deprecatedMutation.getUpdateList()));
            for (DatastoreV4.Mutation.Builder mutationV4 : this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.UPSERT, deprecatedMutation.getUpsertList())) {
                mutationV1 = this.toV1Mutation((DatastoreV4.MutationOrBuilder)mutationV4);
                if (mutationV1.getEntityOrBuilder().hasKey()) {
                    this.validatorV1.getEntityValidator().validateKey(writeConstraint, mutationV1.getEntityOrBuilder().getKeyOrBuilder());
                }
                this.validatorV1.validateMutation(ANY_PROJECT_ID, isTrusted, mutationV1.build());
            }
            for (DatastoreV4.Mutation.Builder mutationV4 : this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertList())) {
                mutationV1 = this.toV1Mutation((DatastoreV4.MutationOrBuilder)mutationV4);
                if (mutationV1.getEntityOrBuilder().hasKey()) {
                    this.validatorV1.getEntityValidator().validateKey(writeConstraint, mutationV1.getEntityOrBuilder().getKeyOrBuilder());
                }
                this.validatorV1.validateMutation(ANY_PROJECT_ID, isTrusted, mutationV1.build());
            }
            for (DatastoreV4.Mutation.Builder mutationV4 : this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertAutoIdList())) {
                mutationV1 = this.toV1Mutation((DatastoreV4.MutationOrBuilder)mutationV4);
                if (mutationV1.getEntityOrBuilder().hasKey()) {
                    this.validatorV1.getEntityValidator().validateKey(insertAutoIdConstraint, mutationV1.getEntityOrBuilder().getKeyOrBuilder());
                }
                this.validatorV1.validateMutation(ANY_PROJECT_ID, isTrusted, mutationV1.build());
            }
            this.validateMutations(isTrusted, this.datastoreConverter.toV4DeleteMutationList(deprecatedMutation.getDeleteList()));
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateCommitMode(DatastoreV4.CommitRequest.Mode mode, boolean hasTransaction) throws ValidationException {
        switch (mode) {
            case TRANSACTIONAL: {
                this.validatorV1.validateCommitMode(CommitRequest.Mode.TRANSACTIONAL, hasTransaction);
                break;
            }
            case NON_TRANSACTIONAL: {
                this.validatorV1.validateCommitMode(CommitRequest.Mode.NON_TRANSACTIONAL, hasTransaction);
                break;
            }
            default: {
                String string = String.valueOf(mode);
                throw new ValidationException(new StringBuilder(21 + String.valueOf(string).length()).append("unknown commit mode: ").append(string).toString());
            }
        }
    }

    public void validateQuery(boolean isStrongReadConsistency, DatastoreV4.QueryOrBuilder query) throws ValidationException {
        boolean isSearchQuery = QueryHelper.isSearchQuery(query);
        this.validateQueryNative(isSearchQuery, query);
        Query.Builder queryV1 = this.toV1Query(query);
        if (isSearchQuery) {
            queryV1.clearFilter();
        }
        try {
            this.validatorV1.validateQuery(isStrongReadConsistency, (QueryOrBuilder)queryV1);
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateQueryNative(boolean isSearchQuery, DatastoreV4.QueryOrBuilder query) throws ValidationException {
        HashSet<String> groupByProperties = new HashSet<String>();
        for (DatastoreV4.PropertyReferenceOrBuilder propRef : query.getGroupByOrBuilderList()) {
            groupByProperties.add(propRef.getName());
        }
        for (DatastoreV4.PropertyExpressionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validatePropertyExpressionNative(propExp, groupByProperties);
        }
        if (isSearchQuery) {
            ValidationException.validateAssertion(!QueryHelper.hasAncestorFilter(query), "ancestor search query is not supported", new Object[0]);
            ValidationException.validateAssertion(query.getProjectionCount() == 0 || QueryHelper.isKeysOnlyQuery(query), "projection is not supported", new Object[0]);
            ValidationException.validateAssertion(query.getOrderCount() == 0, "order-by is not supported", new Object[0]);
            ValidationException.validateAssertion(query.getGroupByCount() == 0, "group-by is not supported", new Object[0]);
            ValidationException.validateAssertion(!query.hasStartCursor(), "start cursor is not supported", new Object[0]);
            ValidationException.validateAssertion(!query.hasEndCursor(), "end cursor is not supported", new Object[0]);
            this.validateSearchQueryFilter((DatastoreV4.FilterOrBuilder)query.getFilter());
        }
    }

    private void validateSearchQueryFilter(DatastoreV4.FilterOrBuilder filter) throws ValidationException {
        if (filter.hasCompositeFilter()) {
            DatastoreV4.CompositeFilterOrBuilder cmpFilter = filter.getCompositeFilterOrBuilder();
            for (DatastoreV4.FilterOrBuilder subFilter : cmpFilter.getFilterOrBuilderList()) {
                this.validateSearchQueryFilter(subFilter);
            }
        } else if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            ValidationException.validateAssertion(propFilter.getOperator() == DatastoreV4.PropertyFilter.Operator.EQUAL, "only equality property filters are supported for search queries", new Object[0]);
        } else if (filter.hasBoundingCircleFilter()) {
            DatastoreV4.BoundingCircleFilterOrBuilder bcFilter = filter.getBoundingCircleFilterOrBuilder();
            this.validatorV1.validatePropertyReference((PropertyReferenceOrBuilder)this.toV1PropertyReference(bcFilter.getProperty()));
            double d = bcFilter.getRadiusMeters();
            ValidationException.validateAssertion(bcFilter.getRadiusMeters() >= 0.0, new StringBuilder(40).append("invalid radius: ").append(d).toString(), new Object[0]);
            this.validatorV1.getEntityValidator().validateLatLng((LatLngOrBuilder)this.toV1LatLng((EntityV4.GeoPointOrBuilder)bcFilter.getCenter()));
        } else if (filter.hasBoundingBoxFilter()) {
            DatastoreV4.BoundingBoxFilterOrBuilder bbFilter = filter.getBoundingBoxFilterOrBuilder();
            this.validatorV1.validatePropertyReference((PropertyReferenceOrBuilder)this.toV1PropertyReference(bbFilter.getProperty()));
            this.validatorV1.getEntityValidator().validateLatLng((LatLngOrBuilder)this.toV1LatLng((EntityV4.GeoPointOrBuilder)bbFilter.getSouthwest()));
            this.validatorV1.getEntityValidator().validateLatLng((LatLngOrBuilder)this.toV1LatLng((EntityV4.GeoPointOrBuilder)bbFilter.getNortheast()));
            ValidationException.validateAssertion(bbFilter.getSouthwest().getLatitude() <= bbFilter.getNortheast().getLatitude(), "the south-west coordinate is on top of the north-east coordinate", new Object[0]);
        }
    }

    private void validatePropertyExpressionNative(DatastoreV4.PropertyExpressionOrBuilder propExp, Set<String> groupByProperties) throws ValidationException {
        if (groupByProperties.isEmpty()) {
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), "aggregation function is not allowed without group by", new Object[0]);
        } else if (groupByProperties.contains(propExp.getPropertyOrBuilder().getName())) {
            String string = String.valueOf(propExp.getPropertyOrBuilder().getName());
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), string.length() != 0 ? "aggregation function is not allowed for properties in group by: ".concat(string) : new String("aggregation function is not allowed for properties in group by: "), new Object[0]);
        } else {
            String string = String.valueOf(propExp.getPropertyOrBuilder().getName());
            ValidationException.validateAssertion(propExp.hasAggregationFunction(), string.length() != 0 ? "aggregation function is required for properties not in group by: ".concat(string) : new String("aggregation function is required for properties not in group by: "), new Object[0]);
        }
    }

    public void validateGqlQuery(DatastoreV4.GqlQueryOrBuilder gqlQuery) throws ValidationException {
        try {
            this.validatorV1.validateGqlQuery((GqlQueryOrBuilder)this.toV1GqlQuery(gqlQuery));
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateReadOptions(boolean hasReadConsistency, boolean hasTransaction) throws ValidationException {
        try {
            this.validatorV1.validateReadOptions(hasReadConsistency, hasTransaction);
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    private PropertyReference.Builder toV1PropertyReference(DatastoreV4.PropertyReference propRefV4) {
        return this.datastoreConverter.toV1PropertyReference(propRefV4);
    }

    private LatLng.Builder toV1LatLng(EntityV4.GeoPointOrBuilder geoPointV4) {
        return this.datastoreConverter.getEntityConverter().toV1LatLng(geoPointV4);
    }

    private Query.Builder toV1Query(DatastoreV4.QueryOrBuilder queryV4) throws ValidationException {
        try {
            return this.datastoreConverter.toV1Query((EntityProtoConverter.ProjectIdResolver)EntityProtoConverter.IDENTITY_RESOLVER, queryV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private GqlQuery.Builder toV1GqlQuery(DatastoreV4.GqlQueryOrBuilder queryV4) throws ValidationException {
        try {
            return this.datastoreConverter.toV1GqlQuery(EntityProtoConverter.IDENTITY_RESOLVER, queryV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private Mutation.Builder toV1Mutation(DatastoreV4.MutationOrBuilder mutationV4) throws ValidationException {
        try {
            return this.datastoreConverter.toV1Mutation(EntityProtoConverter.IDENTITY_RESOLVER, mutationV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }
}

