/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Interner;
import com.google.appengine.repackaged.com.google.common.collect.Interners;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public final class ValidationConstraint {
    private final Operation operation;
    private final EnumSet<Context> contexts;
    private static final Interner<ValidationConstraint> CONSTRAINT_INTERNER = Interners.newStrongInterner();
    public static final ValidationConstraint LOOKUP = ValidationConstraint.forOperation(Operation.LOOKUP);
    public static final ValidationConstraint INSERT = ValidationConstraint.forOperation(Operation.INSERT);
    public static final ValidationConstraint UPSERT = ValidationConstraint.forOperation(Operation.UPSERT);
    public static final ValidationConstraint UPDATE = ValidationConstraint.forOperation(Operation.UPDATE);
    public static final ValidationConstraint DELETE = ValidationConstraint.forOperation(Operation.DELETE);
    public static final ValidationConstraint QUERY = ValidationConstraint.forOperation(Operation.QUERY);
    public static final ValidationConstraint ALLOCATE_ID = ValidationConstraint.forOperation(Operation.ALLOCATE_ID);
    public static final ValidationConstraint ALLOCATE_ID_RANGE = ValidationConstraint.forOperation(Operation.ALLOCATE_ID_RANGE);
    public static final ValidationConstraint RESERVE_ID = ValidationConstraint.forOperation(Operation.RESERVE_ID);
    private static final Predicate<Operation> OPERATION_ALLOWS_COMPLETE_KEY = new Predicate<Operation>(){

        public boolean apply(Operation op) {
            switch (op) {
                case LOOKUP: 
                case INSERT: 
                case UPDATE: 
                case UPSERT: 
                case RESERVE_ID: 
                case ALLOCATE_ID_RANGE: 
                case DELETE: 
                case QUERY: {
                    return true;
                }
            }
            return false;
        }
    };
    private static final Predicate<Operation> OPERATION_ALLOWS_INCOMPLETE_KEY = new Predicate<Operation>(){

        public boolean apply(Operation op) {
            switch (op) {
                case INSERT: 
                case UPSERT: 
                case ALLOCATE_ID_RANGE: 
                case QUERY: 
                case ALLOCATE_ID: {
                    return true;
                }
            }
            return false;
        }
    };
    private static final Predicate<Operation> READ_ONLY_OPERATIONS = new Predicate<Operation>(){

        public boolean apply(Operation op) {
            switch (op) {
                case LOOKUP: 
                case QUERY: {
                    return true;
                }
            }
            return false;
        }
    };

    @VisibleForTesting
    static ImmutableSet<ValidationConstraint> getAllForTesting() {
        ImmutableSet.Builder all = ImmutableSet.builder();
        Set contexts = Sets.powerSet(EnumSet.allOf(Context.class));
        for (Operation op : Operation.values()) {
            for (Set context : contexts) {
                if (context.isEmpty()) {
                    all.add((Object)ValidationConstraint.create(op, EnumSet.noneOf(Context.class)));
                    continue;
                }
                all.add((Object)ValidationConstraint.create(op, EnumSet.copyOf(context)));
            }
        }
        return all.build();
    }

    private ValidationConstraint(Operation operation, EnumSet<Context> contexts) {
        this.operation = operation;
        this.contexts = contexts;
    }

    private static ValidationConstraint create(Operation operation, EnumSet<Context> contexts) {
        return (ValidationConstraint)CONSTRAINT_INTERNER.intern((Object)new ValidationConstraint(operation, contexts));
    }

    private static ValidationConstraint forOperation(Operation operation) {
        return ValidationConstraint.create(operation, EnumSet.noneOf(Context.class));
    }

    public ValidationConstraint withContext(Context context) {
        if (this.contexts.contains((Object)context)) {
            return this;
        }
        EnumSet<Context> newContexts = EnumSet.copyOf(this.contexts);
        newContexts.add(context);
        return ValidationConstraint.create(this.operation, newContexts);
    }

    public ValidationConstraint withTrustedUserContext(boolean setUserTrustedContext) {
        if (setUserTrustedContext) {
            return this.withContext(Context.TRUSTED_USER);
        }
        return this;
    }

    @VisibleForTesting
    public boolean hasContext(Context context) {
        return this.contexts.contains((Object)context);
    }

    public boolean allowPathDelimiterInPropertyName() {
        return this.contexts.contains((Object)Context.IN_ENTITY_WITH_PATH_SEPARATOR);
    }

    public boolean allowMissingKey() {
        return this.contexts.contains((Object)Context.IN_ENTITY_VALUE);
    }

    public boolean allowCompleteKey() {
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return true;
        }
        return OPERATION_ALLOWS_COMPLETE_KEY.apply((Object)this.operation);
    }

    public boolean allowIncompleteKey() {
        if (this.operation == Operation.QUERY) {
            return true;
        }
        if (this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return false;
        }
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE)) {
            return true;
        }
        return OPERATION_ALLOWS_INCOMPLETE_KEY.apply((Object)this.operation);
    }

    public boolean allowReservedKey() {
        return this.contexts.contains((Object)Context.IN_KEY_VALUE) || this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.allowReservedName();
    }

    public boolean allowReservedName() {
        return this.contexts.contains((Object)Context.TRUSTED_USER) || READ_ONLY_OPERATIONS.apply((Object)this.operation);
    }

    public boolean allowIndexOnlyMeaning() {
        return READ_ONLY_OPERATIONS.apply((Object)this.operation);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValidationConstraint)) {
            return false;
        }
        ValidationConstraint otherConstraint = (ValidationConstraint)other;
        return this.operation == otherConstraint.operation && this.contexts.equals(otherConstraint.contexts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.contexts});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("contexts", this.contexts).toString();
    }

    private static enum Operation {
        LOOKUP,
        INSERT,
        UPSERT,
        UPDATE,
        DELETE,
        QUERY,
        ALLOCATE_ID,
        ALLOCATE_ID_RANGE,
        RESERVE_ID;

    }

    public static enum Context {
        IN_KEY_VALUE,
        IN_ENTITY_VALUE,
        IN_ENTITY_WITH_PATH_SEPARATOR,
        TRUSTED_USER;

    }
}

