/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import mediautil.gen.FileFormatException;
import mediautil.gen.MediaInfo;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AdvancedImage;
import mediautil.image.jpeg.BasicJpegIo;
import mediautil.image.jpeg.LLJTran;

public abstract class AbstractImageInfo<F extends LLJTran>
extends BasicJpegIo
implements MediaInfo {
    public static final Dimension DEFAULT_THUMB_SIZE = new Dimension(120, 96);
    public static final DateFormat dateformat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    public static final DecimalFormat fnumberformat = new DecimalFormat("F1:#0.0#");
    public static final String NA = "n/a";
    public static final byte[] BMP_SIG = new byte[]{66, 77};
    public static final int BMP24_HDR_SIZE = 54;
    protected static final Class[] EMPTY_PARAMS = new Class[0];
    protected AdvancedImage advancedImage;
    protected F format;
    public static final double[] AV_TO_FSTOP = new double[]{1.0, 1.4, 2.0, 2.8, 4.0, 5.6, 8.0, 11.0, 16.0, 22.0, 32.0};
    public static final Rational[] TV_TO_SEC = new Rational[]{new Rational(1, 1), new Rational(1, 2), new Rational(1, 4), new Rational(1, 8), new Rational(1, 15), new Rational(1, 30), new Rational(1, 60), new Rational(1, 125), new Rational(1, 250), new Rational(1, 500), new Rational(1, 1000), new Rational(1, 2000), new Rational(1, 4000), new Rational(1, 8000), new Rational(1, 16000)};
    protected transient InputStream is;
    protected int offset;
    protected String name;
    protected String comments;
    protected Object[] fiveObjects = new Object[5];

    public AbstractImageInfo() {
    }

    public AbstractImageInfo(InputStream is, byte[] data, int offset, String name, String comments, F format) throws FileFormatException {
        this.is = is;
        this.data = data;
        this.offset = offset;
        this.name = name;
        this.comments = comments;
        this.format = format;
        this.readInfo();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAdvancedImage(AdvancedImage advancedImage) {
        this.advancedImage = advancedImage;
    }

    public AdvancedImage getAdvancedImage() {
        return this.advancedImage;
    }

    public void writeInfo(byte[] markerData, OutputStream out, int op, int options, boolean modifyImageInfo) throws IOException {
        this.writeInfo(markerData, out, op, options, modifyImageInfo, -1, -1);
    }

    public void writeInfo(byte[] markerData, OutputStream out, int op, int options, boolean modifyImageInfo, int imageWidth, int imageHeight) throws IOException {
        this.writeInfo(markerData, out, op, options, modifyImageInfo, imageWidth, imageHeight, "ISO8859_1");
    }

    public void writeInfo(byte[] markerData, OutputStream out, int op, int options, boolean modifyImageInfo, int imageWidth, int imageHeight, String encoding) throws IOException {
    }

    public abstract void readInfo() throws FileFormatException;

    public abstract String getFormat();

    public abstract int getResolutionX();

    public abstract int getResolutionY();

    public abstract String getMake();

    public abstract String getModel();

    public abstract String getDataTimeOriginalString();

    public abstract float getFNumber();

    public abstract Rational getShutter();

    public abstract boolean isFlash();

    public abstract String getQuality();

    public abstract float getFocalLength();

    public abstract int getMetering();

    public abstract int getExpoProgram();

    public abstract String getReport();

    public int getThumbnailOffset() {
        return -1;
    }

    public int getThumbnailLength() {
        return -1;
    }

    public boolean setThumbnail(byte[] newThumbnailData, int startIndex, int len, String thumbnailExt, OutputStream newAppHdrOp) throws IOException {
        return false;
    }

    public boolean removeThumbnailTags() {
        return false;
    }

    public abstract Icon getThumbnailIcon(Dimension var1);

    public String toString() {
        String result = this.getReport();
        if (result != null && result.length() > 0) {
            return result;
        }
        return super.toString();
    }

    @Override
    public Object[] getFiveMajorAttributes() {
        return this.fiveObjects;
    }

    public Icon getThumbnailIcon() {
        return this.getThumbnailIcon(null);
    }

    public String getThumbnailExtension() {
        return "jpeg";
    }

    public String getComments() {
        return this.comments;
    }

    public File getImageFile() {
        return ((LLJTran)this.format).getFile();
    }

    public boolean saveThumbnailImage(OutputStream os) throws IOException {
        if (os == null) {
            return false;
        }
        if (this.getAdvancedImage() != null) {
            try {
                this.getAdvancedImage().saveThumbnailImage(this.getImageFile().getPath(), os, null);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public Date getDateTimeOriginal() {
        try {
            return dateformat.parse(this.getDataTimeOriginalString());
        }
        catch (NullPointerException e) {
        }
        catch (ParseException e) {
            String string = String.valueOf(e);
            System.err.println(new StringBuilder(0 + String.valueOf(string).length()).append(string).toString());
        }
        return new Date();
    }

    public float apertureToFnumber(float aperture) {
        try {
            int si = (int)aperture;
            float result = (float)AV_TO_FSTOP[si];
            if ((aperture -= (float)si) != 0.0f) {
                result = (float)((double)result + (AV_TO_FSTOP[si + 1] - AV_TO_FSTOP[si]) * (double)aperture);
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1.0f;
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (!"Comments".equals(name)) {
            throw new RuntimeException("Calling this method not allowed by AbstractImageInfo implementation.");
        }
        this.comments = value.toString();
    }

    @Override
    public Object getAttribute(String name) {
        if ("charachter".equals(name)) {
            return this.getShutter();
        }
        if ("timestamp".equals(name)) {
            return this.getDateTimeOriginal();
        }
        if ("quality".equals(name)) {
            return this.getQuality();
        }
        if ("make".equals(name)) {
            return this.getMake();
        }
        return this.getGenericAttribute(name);
    }

    @Override
    public int getIntAttribute(String name) {
        if ("charachter".equals(name)) {
            return (int)this.getFocalLength();
        }
        Object result = this.getGenericAttribute(name);
        if (result != null) {
            if (result instanceof Integer) {
                return (Integer)result;
            }
        } else {
            return 0;
        }
        String string = String.valueOf(name);
        throw new IllegalArgumentException(string.length() != 0 ? "Not supported attribute name for int ".concat(string) : new String("Not supported attribute name for int "));
    }

    @Override
    public float getFloatAttribute(String name) {
        if ("charachter".equals(name)) {
            return this.getFNumber();
        }
        Object result = this.getGenericAttribute(name);
        if (result != null) {
            if (result instanceof Float) {
                return ((Float)result).floatValue();
            }
        } else {
            return 0.0f;
        }
        String string = String.valueOf(name);
        throw new IllegalArgumentException(string.length() != 0 ? "Not supported attribute name for float ".concat(string) : new String("Not supported attribute name for float "));
    }

    @Override
    public long getLongAttribute(String name) {
        String string = String.valueOf(name);
        throw new IllegalArgumentException(string.length() != 0 ? "Not supported attribute name for long ".concat(string) : new String("Not supported attribute name for long "));
    }

    @Override
    public double getDoubleAttribute(String name) {
        String string = String.valueOf(name);
        throw new IllegalArgumentException(string.length() != 0 ? "Not supported attribute name for double ".concat(string) : new String("Not supported attribute name for double "));
    }

    @Override
    public boolean getBoolAttribute(String name) {
        if ("charachter".equals(name)) {
            return this.isFlash();
        }
        return this.getGenericBoolAttribute(name);
    }

    protected Object getGenericAttribute(String name) {
        try {
            String string = String.valueOf(name);
            return this.getClass().getMethod(string.length() != 0 ? "get".concat(string) : new String("get"), EMPTY_PARAMS).invoke((Object)this, (Object[])EMPTY_PARAMS);
        }
        catch (Throwable t) {
            String string = String.valueOf(t);
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(name).length() + String.valueOf(string).length()).append("Not supported attribute ").append(name).append(" <<").append(string).toString());
        }
    }

    protected Boolean getGenericBoolAttribute(String name) {
        try {
            String string = String.valueOf(name);
            return (Boolean)this.getClass().getMethod(string.length() != 0 ? "is".concat(string) : new String("is"), EMPTY_PARAMS).invoke((Object)this, (Object[])EMPTY_PARAMS);
        }
        catch (Throwable t) {
            try {
                return (Boolean)this.getGenericAttribute(name);
            }
            catch (Throwable t2) {
                String string = String.valueOf(t2);
                String string2 = String.valueOf(t);
                throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(name).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("Not supported boolean attribute ").append(name).append(" <<").append(string).append(" <<").append(string2).toString());
            }
        }
    }
}

