/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.Collection;

public class CloudDatastoreV1ServiceValidator {
    private final CloudDatastoreV1Validator validatorV1;
    private static final ValidationConstraint LOOKUP_CONSTRAINT = ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint ALLOCATE_ID_CONSTRAINT = ValidationConstraint.ALLOCATE_ID.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint QUERY_CONSTRAINT = ValidationConstraint.QUERY.withContext(ValidationConstraint.Context.PRENORMALIZATION);

    public CloudDatastoreV1ServiceValidator(CloudDatastoreV1Validator validatorV1) {
        this.validatorV1 = validatorV1;
    }

    public CloudDatastoreV1Validator getDatastoreV1Validator() {
        return this.validatorV1;
    }

    public void validateCommitRequest(boolean isTrusted, CommitRequestOrBuilder req) throws ValidationException {
        this.validatorV1.validateCommitMode(req.getMode(), !req.getTransaction().isEmpty());
        this.validateProjectId(req.getProjectIdBytes());
        for (Mutation mutation : req.getMutationsList()) {
            ValidationConstraint constraint = CloudDatastoreV1Validator.constraintForMutationOperation(mutation.getOp()).withContext(isTrusted, ValidationConstraint.Context.PRENORMALIZATION);
            this.validatorV1.validateMutation(constraint, req.getProjectId(), mutation);
        }
    }

    public void validateLookupRequest(LookupRequestOrBuilder req) throws ValidationException {
        this.validatorV1.getEntityValidator().validateKeys(LOOKUP_CONSTRAINT, req.getKeysList());
        this.validateProjectId(req.getProjectIdBytes());
        this.validateProjectIdMatches(req.getProjectId(), req.getKeysOrBuilderList());
    }

    public void validateAllocateIdsRequest(AllocateIdsRequestOrBuilder req) throws ValidationException {
        this.validatorV1.getEntityValidator().validateKeys(ALLOCATE_ID_CONSTRAINT, req.getKeysList());
        this.validateProjectId(req.getProjectIdBytes());
        this.validateProjectIdMatches(req.getProjectId(), req.getKeysOrBuilderList());
    }

    public void validateRunQueryRequest(RunQueryRequest req) throws ValidationException {
        Preconditions.checkArgument((req.getQueryTypeCase() != RunQueryRequest.QueryTypeCase.GQL_QUERY ? 1 : 0) != 0, (Object)"RunQueryRequest not normalized");
        this.validatorV1.getEntityValidator().validatePartitionId(QUERY_CONSTRAINT, req.getPartitionIdOrBuilder());
        ValidationException.validateAssertion(req.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.QUERY, "one of fields Query.query and Query.gql_query must be set", new Object[0]);
        this.validatorV1.validateQuery(QUERY_CONSTRAINT, req.getReadOptionsOrBuilder().getReadConsistency() == ReadOptions.ReadConsistency.STRONG, (QueryOrBuilder)req.getQuery());
        this.validateProjectId(req.getProjectIdBytes());
        this.validatorV1.validateProjectIdMatches(req.getProjectId(), req.getPartitionIdOrBuilder());
    }

    public void validateRollbackRequest(RollbackRequestOrBuilder req) throws ValidationException {
        ValidationException.validateAssertion(!req.getTransaction().isEmpty(), "transaction required", new Object[0]);
        this.validateProjectId(req.getProjectIdBytes());
    }

    public void validateBeginTransactionRequest(BeginTransactionRequestOrBuilder req) throws ValidationException {
        this.validateProjectId(req.getProjectIdBytes());
    }

    private void validateProjectId(ByteString projectIdBytes) throws ValidationException {
        ValidationException.validateAssertion(!projectIdBytes.isEmpty(), "missing project id in header", new Object[0]);
        this.validatorV1.getEntityValidator().validateStringUtf8(projectIdBytes, "project id");
    }

    private void validateProjectIdMatches(String projectId, Collection<? extends KeyOrBuilder> keys) throws ValidationException {
        for (KeyOrBuilder keyOrBuilder : keys) {
            this.validatorV1.validateProjectIdMatches(projectId, keyOrBuilder.getPartitionIdOrBuilder());
        }
    }
}

