/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.datastore.v1.ArrayValue;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.TimestampOrBuilder;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.appengine.repackaged.com.google.type.LatLngOrBuilder;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityHelper;
import com.google.apphosting.datastore.shared.EntityV3V1Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.UserValueObfuscator;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EntityV4Converter {
    private final boolean preservePropertyOrderInV4;
    private final UserValueObfuscator obfuscator;

    public EntityV4Converter(boolean preserveV4PropertyOrder, UserValueObfuscator obfuscator) {
        this.preservePropertyOrderInV4 = preserveV4PropertyOrder;
        this.obfuscator = obfuscator;
    }

    public UserValueObfuscator getObfuscator() {
        return this.obfuscator;
    }

    boolean getPreservePropertyOrderInV4() {
        return this.preservePropertyOrderInV4;
    }

    public List<OnestoreEntity.Reference> toV3ReferenceList(List<? extends EntityV4.KeyOrBuilder> keysV4) throws InvalidConversionException {
        ImmutableList.Builder keysV3 = ImmutableList.builder();
        for (EntityV4.KeyOrBuilder keyOrBuilder : keysV4) {
            keysV3.add((Object)this.toV3Reference(keyOrBuilder));
        }
        return keysV3.build();
    }

    public List<EntityV4.Key> toV4KeyList(List<OnestoreEntity.Reference> keysV3) throws InvalidConversionException {
        ImmutableList.Builder keysV4 = ImmutableList.builder();
        for (OnestoreEntity.Reference keyV3 : keysV3) {
            keysV4.add((Object)this.toV4Key(keyV3).build());
        }
        return keysV4.build();
    }

    public EntityV4.Key.Builder toV4Key(OnestoreEntity.Reference referenceV3) throws InvalidConversionException {
        return this.toV4Key(ProjectIdAppIdResolver.IDENTITY, (KeyOrBuilder)EntityV3V1Converter.INSTANCE.toV1Key(ProjectIdAppIdResolver.IDENTITY, referenceV3));
    }

    public EntityV4.Value.Builder toV4Value(OnestoreEntity.Property propertyV3, boolean indexed) throws InvalidConversionException {
        boolean isEntityInV4 = propertyV3.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO || propertyV3.getValue().hasUserValue() || propertyV3.getValue().hasPointValue();
        InvalidConversionException.checkConversion(!propertyV3.hasStashed(), "Property \"%s\" has field stashed", propertyV3.getName());
        InvalidConversionException.checkConversion(!propertyV3.hasComputed(), "Property \"%s\" has field computed", propertyV3.getName());
        if (!this.preservePropertyOrderInV4 || !isEntityInV4) {
            return this.toV4Value(ProjectIdAppIdResolver.IDENTITY, EntityV3V1Converter.INSTANCE.toV1Value(ProjectIdAppIdResolver.IDENTITY, propertyV3, indexed).build());
        }
        EntityV4.Value.Builder valueV4 = EntityV4.Value.newBuilder();
        OnestoreEntity.PropertyValue propertyValueV3 = propertyV3.getValue();
        OnestoreEntity.Property.Meaning meaningV3 = propertyV3.getMeaningEnum();
        if (!EntityV3V1Converter.INSTANCE.doubleCheckIsInternValueUnionValid(propertyV3.getValue())) {
            meaningV3 = null;
        } else if (meaningV3 == OnestoreEntity.Property.Meaning.NO_MEANING) {
            meaningV3 = null;
        } else if (!EntityV3V1Converter.INSTANCE.doubleCheckIsInternValueMeaningValid(meaningV3, propertyValueV3)) {
            meaningV3 = null;
        }
        if (propertyValueV3.hasStringValue()) {
            OnestoreEntity.EntityProto entityV3;
            byte[] serializedEntityV3 = propertyValueV3.getStringValueAsBytes();
            try {
                entityV3 = (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.PARSER.parsePartialFrom(serializedEntityV3);
            }
            catch (InvalidProtocolBufferException exception) {
                entityV3 = null;
            }
            if (entityV3 == null) {
                valueV4.setBlobValue(ByteString.copyFrom((byte[])serializedEntityV3));
            } else {
                valueV4.setEntityValue(this.toV4Entity(entityV3));
            }
            meaningV3 = null;
        } else if (propertyValueV3.hasPointValue()) {
            valueV4.setEntityValue(this.toV4Entity(propertyValueV3.getPointValue()));
            if (meaningV3 != OnestoreEntity.Property.Meaning.GEORSS_POINT) {
                valueV4.setMeaning(21);
                meaningV3 = null;
            }
        } else if (propertyValueV3.hasUserValue()) {
            valueV4.setEntityValue(this.toV4Entity(propertyValueV3.getUserValue()));
            valueV4.setMeaning(20);
            meaningV3 = null;
        }
        if (meaningV3 != null) {
            int meaningV4 = meaningV3.getValue();
            valueV4.setMeaning(meaningV4);
        }
        if (indexed != valueV4.getIndexed()) {
            valueV4.setIndexed(indexed);
        }
        return valueV4;
    }

    private EntityV4.Entity.Builder toV4Entity(OnestoreEntity.PropertyValue.PointValue pointValueV3) {
        String xPropertyName = "x";
        String yPropertyName = "y";
        return EntityV4.Entity.newBuilder().addProperty(this.toV4UnindexedProperty(xPropertyName, pointValueV3.getX())).addProperty(this.toV4UnindexedProperty(yPropertyName, pointValueV3.getY()));
    }

    private void maybeAddV4Property(String name, EntityOrBuilder entityV1, EntityV4.Entity.Builder entityV4) throws InvalidConversionException {
        Value valueV1 = (Value)entityV1.getProperties().get(name);
        if (valueV1 != null) {
            entityV4.addProperty(this.toV4Property(ProjectIdAppIdResolver.IDENTITY, name, valueV1));
        }
    }

    private EntityV4.Entity.Builder toV4Entity(OnestoreEntity.PropertyValue.UserValue userValueV3) throws InvalidConversionException {
        EntityV4.Entity.Builder entityV4 = EntityV4.Entity.newBuilder();
        Entity.Builder entityV1 = EntityV3V1Converter.INSTANCE.toV1Entity(userValueV3);
        this.maybeAddV4Property("email", (EntityOrBuilder)entityV1, entityV4);
        this.maybeAddV4Property("auth_domain", (EntityOrBuilder)entityV1, entityV4);
        this.maybeAddV4Property("user_id", (EntityOrBuilder)entityV1, entityV4);
        this.maybeAddV4Property("internal_id", (EntityOrBuilder)entityV1, entityV4);
        this.maybeAddV4Property("federated_identity", (EntityOrBuilder)entityV1, entityV4);
        this.maybeAddV4Property("federated_provider", (EntityOrBuilder)entityV1, entityV4);
        return entityV4;
    }

    public OnestoreEntity.Reference toV3Reference(EntityV4.KeyOrBuilder keyV4) throws InvalidConversionException {
        return EntityV3V1Converter.INSTANCE.toV3Reference(ProjectIdAppIdResolver.IDENTITY, (KeyOrBuilder)this.toV1Key(ProjectIdAppIdResolver.IDENTITY, keyV4));
    }

    public OnestoreEntity.PropertyValue toV3PropertyValue(EntityV4.ValueOrBuilder valueV4) throws InvalidConversionException {
        if (!this.preservePropertyOrderInV4 || !valueV4.hasEntityValue()) {
            return EntityV3V1Converter.INSTANCE.toV3PropertyValue(ProjectIdAppIdResolver.IDENTITY, this.toV1Value(ProjectIdAppIdResolver.IDENTITY, valueV4).build());
        }
        OnestoreEntity.PropertyValue propertyValueV3 = new OnestoreEntity.PropertyValue();
        EntityV4.Entity entityValueV4 = valueV4.getEntityValue();
        if (valueV4.getMeaning() == 9 || valueV4.getMeaning() == 21) {
            OnestoreEntity.PropertyValue.PointValue pointValueV3 = EntityV3V1Converter.INSTANCE.toV3PointValue((LatLngOrBuilder)this.toV1LatLng((EntityV4.EntityOrBuilder)entityValueV4));
            propertyValueV3.setPointValue(pointValueV3);
        } else if (valueV4.getMeaning() == 20) {
            OnestoreEntity.PropertyValue.UserValue userValueV3 = EntityV3V1Converter.INSTANCE.toV3UserValue((EntityOrBuilder)this.toV1Entity(ProjectIdAppIdResolver.IDENTITY, (EntityV4.EntityOrBuilder)entityValueV4));
            propertyValueV3.setUserValue(userValueV3);
        } else {
            OnestoreEntity.EntityProto entityValueV3 = this.toV3Entity((EntityV4.EntityOrBuilder)entityValueV4);
            propertyValueV3.setStringValueAsBytes(entityValueV3.toByteArray());
        }
        return propertyValueV3;
    }

    private OnestoreEntity.EntityProto toV3EntityNoObfuscation(EntityV4.EntityOrBuilder entityV4) throws InvalidConversionException {
        if (!this.preservePropertyOrderInV4) {
            return EntityV3V1Converter.INSTANCE.toV3Entity(ProjectIdAppIdResolver.IDENTITY, (EntityOrBuilder)this.toV1Entity(ProjectIdAppIdResolver.IDENTITY, entityV4));
        }
        OnestoreEntity.EntityProto entityV3 = new OnestoreEntity.EntityProto();
        for (EntityV4.Property propertyV4 : entityV4.getPropertyList()) {
            this.checkDeprecatedFieldsNotSet((EntityV4.PropertyOrBuilder)propertyV4);
            String propertyName = propertyV4.getName();
            EntityV4.Value valueV4 = propertyV4.getValue();
            if (valueV4.getListValueCount() > 0) {
                for (EntityV4.ValueOrBuilder subValueV4 : valueV4.getListValueOrBuilderList()) {
                    this.addV3Property(propertyName, true, subValueV4, entityV3);
                }
                continue;
            }
            this.addV3Property(propertyName, false, (EntityV4.ValueOrBuilder)valueV4, entityV3);
        }
        if (entityV4.hasKey()) {
            EntityV4.Key keyV4 = entityV4.getKey();
            OnestoreEntity.Reference referenceV3 = this.toV3Reference((EntityV4.KeyOrBuilder)keyV4);
            entityV3.setKey(referenceV3);
            if (Paths.hasIdOrName(referenceV3) || referenceV3.getPath().elementSize() > 1) {
                entityV3.setEntityGroup(Paths.getGroup(referenceV3));
            }
        }
        return entityV3;
    }

    public OnestoreEntity.EntityProto toV3Entity(EntityV4.EntityOrBuilder entityV4) throws InvalidConversionException {
        OnestoreEntity.EntityProto entityV3 = this.toV3EntityNoObfuscation(entityV4);
        this.obfuscator.obfuscate(entityV3);
        return entityV3;
    }

    private void addV3Property(String propertyName, boolean isMulti, EntityV4.ValueOrBuilder valueV4, OnestoreEntity.EntityProto entityV3) throws InvalidConversionException {
        OnestoreEntity.Property propertyV3 = this.toV3Property(propertyName, isMulti, valueV4);
        if (valueV4.getIndexed()) {
            entityV3.addProperty(propertyV3);
        } else {
            entityV3.addRawProperty(propertyV3);
        }
    }

    public EntityV4.Entity.Builder toV4Entity(OnestoreEntity.EntityProto entityV3) throws InvalidConversionException {
        if (!this.preservePropertyOrderInV4) {
            return this.toV4Entity(ProjectIdAppIdResolver.IDENTITY, (EntityOrBuilder)EntityV3V1Converter.INSTANCE.toV1Entity(ProjectIdAppIdResolver.IDENTITY, entityV3));
        }
        EntityV4.Entity.Builder entityV4 = EntityV4.Entity.newBuilder();
        if (entityV3.hasKey() && !entityV3.getKey().getApp().isEmpty()) {
            entityV4.setKey(this.toV4Key(entityV3.getKey()));
        }
        LinkedHashMap nameToPropertyBuilderMap = Maps.newLinkedHashMap();
        for (OnestoreEntity.Property indexedPropertyV3 : entityV3.propertys()) {
            this.addV3PropertyToV4Map(true, indexedPropertyV3, nameToPropertyBuilderMap);
        }
        for (OnestoreEntity.Property unindexedPropertyV3 : entityV3.rawPropertys()) {
            this.addV3PropertyToV4Map(false, unindexedPropertyV3, nameToPropertyBuilderMap);
        }
        for (EntityV4.Property.Builder propertyV4 : nameToPropertyBuilderMap.values()) {
            entityV4.addProperty(propertyV4);
        }
        return entityV4;
    }

    private void addV3PropertyToV4Map(boolean isIndexed, OnestoreEntity.Property propertyV3, Map<String, EntityV4.Property.Builder> nameToV4PropertyBuilderMap) throws InvalidConversionException {
        String propertyName = propertyV3.getName();
        EntityV4.Value propertyValue = this.toV4Value(propertyV3, isIndexed).build();
        EntityV4.Property.Builder propertyV4 = nameToV4PropertyBuilderMap.get(propertyName);
        if (propertyV4 == null) {
            propertyV4 = EntityV4.Property.newBuilder();
            propertyV4.setName(propertyName);
            nameToV4PropertyBuilderMap.put(propertyName, propertyV4);
            if (!propertyV3.isMultiple()) {
                propertyV4.setValue(propertyValue);
                return;
            }
        } else {
            if (propertyV4.getValue().getListValueCount() == 0) {
                propertyV4.setValue(EntityV4.Value.newBuilder().addListValue(propertyV4.getValue()));
            }
            if (!propertyV3.isMultiple()) {
                // empty if block
            }
        }
        propertyV4.getValueBuilder().addListValue(propertyValue);
    }

    public OnestoreEntity.Property toV3Property(String name, boolean isMultiple, EntityV4.ValueOrBuilder valueV4) throws InvalidConversionException {
        int meaningV4;
        if (!this.preservePropertyOrderInV4 || !valueV4.hasEntityValue()) {
            return EntityV3V1Converter.INSTANCE.toV3Property(ProjectIdAppIdResolver.IDENTITY, name, isMultiple, this.toV1Value(ProjectIdAppIdResolver.IDENTITY, valueV4, name).build());
        }
        OnestoreEntity.Property propertyV3 = new OnestoreEntity.Property();
        propertyV3.setName(name);
        propertyV3.setMultiple(isMultiple);
        propertyV3.setValue(this.toV3PropertyValue(valueV4));
        int n = meaningV4 = valueV4.hasMeaning() ? valueV4.getMeaning() : 0;
        if (meaningV4 != 9) {
            if (meaningV4 != 21 && meaningV4 != 20) {
                propertyV3.setMeaning(OnestoreEntity.Property.Meaning.ENTITY_PROTO);
            }
            meaningV4 = 0;
        }
        if (meaningV4 != 0) {
            OnestoreEntity.Property.Meaning meaningV3 = OnestoreEntity.Property.Meaning.valueOf((int)meaningV4);
            propertyV3.setMeaning(meaningV3);
        }
        return propertyV3;
    }

    public EntityV4.Key.Builder toV4Key(ProjectIdAppIdResolver resolver, KeyOrBuilder keyV1) throws InvalidConversionException {
        EntityV4.Key.Builder keyV4 = EntityV4.Key.newBuilder();
        if (keyV1.hasPartitionId()) {
            keyV4.setPartitionId(this.toV4PartitionId(resolver, (PartitionIdOrBuilder)keyV1.getPartitionId()));
        }
        for (Key.PathElement pathElementV1 : keyV1.getPathList()) {
            keyV4.addPathElement(this.toV4KeyPathElement(pathElementV1));
        }
        return keyV4;
    }

    public Key.Builder toV1Key(ProjectIdAppIdResolver resolver, EntityV4.KeyOrBuilder keyV4) throws InvalidConversionException {
        Key.Builder keyV1 = Key.newBuilder();
        if (keyV4.hasPartitionId()) {
            keyV1.setPartitionId(this.toV1PartitionId(resolver, (EntityV4.PartitionIdOrBuilder)keyV4.getPartitionId()));
        }
        for (EntityV4.Key.PathElement keyPathElementV4 : keyV4.getPathElementList()) {
            keyV1.addPath(this.toV1PathElement((EntityV4.Key.PathElementOrBuilder)keyPathElementV4));
        }
        return keyV1;
    }

    public EntityV4.Entity.Builder toV4Entity(ProjectIdAppIdResolver resolver, EntityOrBuilder entityV1) throws InvalidConversionException {
        EntityV4.Entity.Builder entityV4 = EntityV4.Entity.newBuilder();
        for (Map.Entry propertyV1 : entityV1.getProperties().entrySet()) {
            entityV4.addProperty(this.toV4Property(resolver, (String)propertyV1.getKey(), (Value)propertyV1.getValue()));
        }
        if (entityV1.hasKey()) {
            entityV4.setKey(this.toV4Key(resolver, (KeyOrBuilder)entityV1.getKey()));
        }
        return entityV4;
    }

    public Entity.Builder toV1Entity(ProjectIdAppIdResolver resolver, EntityV4.EntityOrBuilder entityV4) throws InvalidConversionException {
        Entity.Builder entityV1 = Entity.newBuilder();
        HashSet<String> propertyNameSet = new HashSet<String>();
        for (EntityV4.Property propertyV4 : entityV4.getPropertyList()) {
            this.checkDeprecatedFieldsNotSet((EntityV4.PropertyOrBuilder)propertyV4);
            String propertyName = propertyV4.getName();
            InvalidConversionException.checkConversion(propertyV4.hasValue(), "Property \"%s\" has no value.", propertyName);
            InvalidConversionException.checkConversion(propertyNameSet.add(propertyName), "Entity has duplicate property name \"%s\".", propertyName);
            entityV1.getMutableProperties().put(propertyV4.getName(), this.toV1Value(resolver, (EntityV4.PropertyOrBuilder)propertyV4).build());
        }
        if (entityV4.hasKey()) {
            entityV1.setKey(this.toV1Key(resolver, (EntityV4.KeyOrBuilder)entityV4.getKey()));
        }
        return entityV1;
    }

    private void checkDeprecatedFieldsNotSet(EntityV4.PropertyOrBuilder property) {
        String propertyName = property.getName();
        if (property.getDeprecatedValueCount() > 0) {
            throw new IllegalArgumentException(String.format("Property \"%s\" populates deprecated_value.", propertyName));
        }
        if (property.hasDeprecatedMulti()) {
            throw new IllegalArgumentException(String.format("Property \"%s\" populates deprecated_multi.", propertyName));
        }
    }

    private EntityV4.Property.Builder toV4Property(ProjectIdAppIdResolver resolver, String name, Value valueV1) throws InvalidConversionException {
        return EntityV4.Property.newBuilder().setName(name).setValue(this.toV4Value(resolver, valueV1));
    }

    public EntityV4.PartitionId.Builder toV4PartitionId(ProjectIdAppIdResolver resolver, PartitionIdOrBuilder partitionIdV1) throws InvalidConversionException {
        EntityV4.PartitionId.Builder partitionIdV4 = EntityV4.PartitionId.newBuilder().setDatasetId(resolver.toAppId(partitionIdV1.getProjectId()));
        if (!partitionIdV1.getDatabaseId().isEmpty()) {
            throw new InvalidConversionException("Databases are not supported in v4");
        }
        if (!partitionIdV1.getNamespaceId().isEmpty()) {
            partitionIdV4.setNamespace(partitionIdV1.getNamespaceId());
        }
        return partitionIdV4;
    }

    public PartitionId.Builder toV1PartitionId(ProjectIdAppIdResolver resolver, EntityV4.PartitionIdOrBuilder partitionIdV4) throws InvalidConversionException {
        PartitionId.Builder partitionIdV1 = PartitionId.newBuilder();
        if (partitionIdV4.hasDatasetId()) {
            InvalidConversionException.checkConversion(!partitionIdV4.getDatasetId().isEmpty(), "The dataset id is the empty string.", new Object[0]);
            EntityV3V1Converter.INSTANCE.checkValidUtf8(partitionIdV4.getDatasetIdBytes(), "dataset id");
        }
        partitionIdV1.setProjectId(resolver.toProjectId(partitionIdV4.getDatasetId()));
        if (partitionIdV4.hasNamespace()) {
            InvalidConversionException.checkConversion(!partitionIdV4.getNamespace().isEmpty(), "The namespace is the empty string.", new Object[0]);
        }
        partitionIdV1.setNamespaceIdBytes(partitionIdV4.getNamespaceBytes());
        return partitionIdV1;
    }

    private EntityV4.Key.PathElement.Builder toV4KeyPathElement(Key.PathElement pathElementV1) throws InvalidConversionException {
        EntityV4.Key.PathElement.Builder keyPathElementV4 = EntityV4.Key.PathElement.newBuilder();
        keyPathElementV4.setKind(pathElementV1.getKind());
        switch (pathElementV1.getIdTypeCase()) {
            case ID: {
                keyPathElementV4.setId(pathElementV1.getId());
                break;
            }
            case NAME: {
                keyPathElementV4.setName(pathElementV1.getName());
                break;
            }
            case IDTYPE_NOT_SET: {
                break;
            }
            default: {
                String string = String.valueOf(pathElementV1.getIdTypeCase());
                throw new InvalidConversionException(new StringBuilder(22 + String.valueOf(string).length()).append("Unrecognized id type: ").append(string).toString());
            }
        }
        return keyPathElementV4;
    }

    private void checkValidValueUnion(EntityV4.ValueOrBuilder valueV4, String propertyName) throws InvalidConversionException {
        int numSubValues = 0;
        if (valueV4.hasBooleanValue()) {
            ++numSubValues;
        }
        if (valueV4.hasIntegerValue()) {
            ++numSubValues;
        }
        if (valueV4.hasDoubleValue()) {
            ++numSubValues;
        }
        if (valueV4.hasTimestampMicrosecondsValue()) {
            ++numSubValues;
        }
        if (valueV4.hasKeyValue()) {
            ++numSubValues;
        }
        if (valueV4.hasBlobKeyValue()) {
            ++numSubValues;
        }
        if (valueV4.hasStringValue()) {
            ++numSubValues;
        }
        if (valueV4.hasBlobValue()) {
            ++numSubValues;
        }
        if (valueV4.hasEntityValue()) {
            ++numSubValues;
        }
        if (valueV4.getListValueCount() > 0) {
            ++numSubValues;
        }
        InvalidConversionException.checkConversion(numSubValues <= 1, "The value \"%s\" has multiple types set.", propertyName);
    }

    Value.Builder toV1Value(ProjectIdAppIdResolver resolver, EntityV4.PropertyOrBuilder propertyV4) throws InvalidConversionException {
        this.checkDeprecatedFieldsNotSet(propertyV4);
        InvalidConversionException.checkConversion(propertyV4.hasValue(), "Property \"%s\" has no value.", propertyV4.getName());
        EntityV3V1Converter.INSTANCE.checkValidUtf8(propertyV4.getNameBytes(), "property.name");
        return this.toV1Value(resolver, (EntityV4.ValueOrBuilder)propertyV4.getValue(), propertyV4.getName());
    }

    Value.Builder toV1Value(ProjectIdAppIdResolver resolver, EntityV4.ValueOrBuilder valueV4, String propertyName) throws InvalidConversionException {
        this.checkValidValueUnion(valueV4, propertyName);
        if (valueV4.hasMeaning()) {
            String message = "Value \"%s\" has a meaning %d which does not match %s field.";
            int meaning = valueV4.getMeaning();
            switch (meaning) {
                case 9: 
                case 21: {
                    InvalidConversionException.checkConversion(valueV4.hasEntityValue(), message, propertyName, meaning, "entity_value");
                    break;
                }
                case 18: {
                    InvalidConversionException.checkConversion(!valueV4.hasBlobKeyValue(), message, propertyName, meaning, "blob_key_value");
                }
            }
        }
        return this.toV1Value(resolver, valueV4);
    }

    Value.Builder toV1Value(ProjectIdAppIdResolver resolver, EntityV4.ValueOrBuilder valueV4) throws InvalidConversionException {
        Value.Builder valueV1 = Value.newBuilder();
        if (valueV4.getMeaning() == 24) {
            EntityV4.Value.Builder emptyArrayValue = EntityV4.Value.newBuilder().setMeaning(24);
            if (valueV4.hasIndexed()) {
                emptyArrayValue.setIndexed(valueV4.getIndexed());
            }
            InvalidConversionException.checkConversion(valueV4.equals(emptyArrayValue.build()), "An empty list cannot have a value set", new Object[0]);
            valueV1.setArrayValue(ArrayValue.getDefaultInstance());
            valueV1.setExcludeFromIndexes(!valueV4.getIndexed());
            return valueV1;
        }
        if (valueV4.hasMeaning()) {
            valueV1.setMeaning(valueV4.getMeaning());
        }
        valueV1.setExcludeFromIndexes(!valueV4.getIndexed());
        if (valueV4.hasBooleanValue()) {
            valueV1.setBooleanValue(valueV4.getBooleanValue());
        } else if (valueV4.hasIntegerValue()) {
            valueV1.setIntegerValue(valueV4.getIntegerValue());
        } else if (valueV4.hasDoubleValue()) {
            valueV1.setDoubleValue(valueV4.getDoubleValue());
        } else if (valueV4.hasTimestampMicrosecondsValue()) {
            valueV1.setTimestampValue(EntityV3V1Converter.microsecondsToTimestamp(valueV4.getTimestampMicrosecondsValue()));
        } else if (valueV4.hasKeyValue()) {
            valueV1.setKeyValue(this.toV1Key(resolver, (EntityV4.KeyOrBuilder)valueV4.getKeyValue()));
        } else if (valueV4.hasBlobKeyValue()) {
            valueV1.setStringValueBytes(valueV4.getBlobKeyValueBytes());
            valueV1.setMeaning(17);
        } else if (valueV4.hasStringValue()) {
            valueV1.setStringValueBytes(valueV4.getStringValueBytes());
        } else if (valueV4.hasBlobValue()) {
            valueV1.setBlobValue(valueV4.getBlobValue());
        } else if (valueV4.hasEntityValue()) {
            if (valueV4.getMeaning() == 9) {
                valueV1.setGeoPointValue(this.toV1LatLng((EntityV4.EntityOrBuilder)valueV4.getEntityValue()));
                valueV1.clearMeaning();
            } else if (valueV4.getMeaning() == 21) {
                valueV1.setGeoPointValue(this.toV1LatLng((EntityV4.EntityOrBuilder)valueV4.getEntityValue()));
                valueV1.setMeaning(23);
            } else {
                valueV1.setEntityValue(this.toV1Entity(resolver, (EntityV4.EntityOrBuilder)valueV4.getEntityValue()));
            }
        } else if (valueV4.getListValueCount() > 0) {
            InvalidConversionException.checkConversion(!valueV4.hasIndexed(), "A Value containing a list_value cannot specify indexed.", new Object[0]);
            ArrayValue.Builder arrayValueV1 = ArrayValue.newBuilder();
            for (EntityV4.Value subValueV4 : valueV4.getListValueList()) {
                arrayValueV1.addValues(this.toV1Value(resolver, (EntityV4.ValueOrBuilder)subValueV4));
            }
            valueV1.setArrayValue(arrayValueV1);
        } else {
            valueV1.setNullValue(Value.NullValue.NULL_VALUE);
        }
        return valueV1;
    }

    EntityV4.Value.Builder toV4Value(ProjectIdAppIdResolver resolver, Value valueV1) throws InvalidConversionException {
        EntityV4.Value.Builder valueV4 = EntityV4.Value.newBuilder();
        if (valueV1.getMeaning() != 0) {
            valueV4.setMeaning(valueV1.getMeaning());
        }
        if (valueV1.getExcludeFromIndexes()) {
            valueV4.setIndexed(false);
        }
        switch (valueV1.getValueTypeCase()) {
            case NULL_VALUE: {
                break;
            }
            case BOOLEAN_VALUE: {
                valueV4.setBooleanValue(valueV1.getBooleanValue());
                break;
            }
            case INTEGER_VALUE: {
                valueV4.setIntegerValue(valueV1.getIntegerValue());
                break;
            }
            case DOUBLE_VALUE: {
                valueV4.setDoubleValue(valueV1.getDoubleValue());
                break;
            }
            case TIMESTAMP_VALUE: {
                valueV4.setTimestampMicrosecondsValue(EntityV3V1Converter.toMicroseconds((TimestampOrBuilder)valueV1.getTimestampValue()));
                break;
            }
            case KEY_VALUE: {
                valueV4.setKeyValue(this.toV4Key(resolver, (KeyOrBuilder)valueV1.getKeyValue()));
                break;
            }
            case STRING_VALUE: {
                if (valueV1.getMeaning() == 17) {
                    valueV4.setBlobKeyValue(valueV1.getStringValue());
                    valueV4.clearMeaning();
                    break;
                }
                valueV4.setStringValue(valueV1.getStringValue());
                break;
            }
            case BLOB_VALUE: {
                valueV4.setBlobValue(valueV1.getBlobValue());
                break;
            }
            case GEO_POINT_VALUE: {
                valueV4.setEntityValue(this.toV4PointEntity((LatLngOrBuilder)valueV1.getGeoPointValue()));
                if (valueV1.getMeaning() == 23) {
                    valueV4.setMeaning(21);
                    break;
                }
                valueV4.setMeaning(9);
                break;
            }
            case ENTITY_VALUE: {
                valueV4.setEntityValue(this.toV4Entity(resolver, (EntityOrBuilder)valueV1.getEntityValue()));
                break;
            }
            case ARRAY_VALUE: {
                if (valueV1.getArrayValue().equals((Object)ArrayValue.getDefaultInstance())) {
                    valueV4.setMeaning(24);
                    break;
                }
                for (Value subValueV1 : valueV1.getArrayValue().getValuesList()) {
                    valueV4.addListValue(this.toV4Value(resolver, subValueV1));
                }
                break;
            }
            default: {
                String string = String.valueOf(valueV1.getValueTypeCase());
                throw new InvalidConversionException(new StringBuilder(21 + String.valueOf(string).length()).append("Unknown value type: ").append(string).append(".").toString());
            }
        }
        return valueV4;
    }

    private LatLng.Builder toV1LatLng(EntityV4.EntityOrBuilder pointEntityV4) throws InvalidConversionException {
        Map<String, EntityV4.PropertyOrBuilder> nameToV4Property = this.buildNameToV4PropertyMap(pointEntityV4);
        InvalidConversionException.checkConversion(!pointEntityV4.hasKey(), "The point entity has a key.", new Object[0]);
        HashSet<String> propertyNames = new HashSet<String>();
        for (EntityV4.PropertyOrBuilder propertyV4 : nameToV4Property.values()) {
            String propertyName = propertyV4.getName();
            EntityV4.Value valueV4 = propertyV4.getValue();
            InvalidConversionException.checkConversion(EntityHelper.PredefinedEntityPointConstants.PROPERTY_MAP.containsKey((Object)propertyName), "The point entity property \"%s\" is not allowed.", propertyName);
            InvalidConversionException.checkConversion(valueV4.getListValueCount() == 0, "The point entity property \"%s\" is multi-valued.", propertyName);
            boolean isValueRequiredType = valueV4.hasField(EntityV4.Value.getDescriptor().findFieldByNumber(((Integer)EntityHelper.PredefinedEntityPointConstants.PROPERTY_MAP.get((Object)propertyName)).intValue()));
            InvalidConversionException.checkConversion(isValueRequiredType, "The point entity property \"%s\" is the wrong type.", propertyName);
            InvalidConversionException.checkConversion(valueV4.getMeaning() == 0, "The point entity property \"%s\" has a meaning.", propertyName);
            InvalidConversionException.checkConversion(!valueV4.getIndexed(), "The point entity property \"%s\" is indexed.", propertyName);
            propertyNames.add(propertyName);
        }
        for (String requiredPropertyName : EntityHelper.PredefinedEntityPointConstants.REQUIRED_PROPERTY_NAME_SET) {
            InvalidConversionException.checkConversion(propertyNames.contains(requiredPropertyName), "The point entity is missing required property \"%s\".", requiredPropertyName);
        }
        double x = nameToV4Property.get("x").getValue().getDoubleValue();
        double y = nameToV4Property.get("y").getValue().getDoubleValue();
        return LatLng.newBuilder().setLatitude(x).setLongitude(y);
    }

    private Map<String, EntityV4.PropertyOrBuilder> buildNameToV4PropertyMap(EntityV4.EntityOrBuilder entityV4) {
        HashMap nameToV4Property = Maps.newHashMap();
        for (EntityV4.PropertyOrBuilder propertyV4 : entityV4.getPropertyOrBuilderList()) {
            nameToV4Property.put(propertyV4.getName(), propertyV4);
        }
        return nameToV4Property;
    }

    private EntityV4.Entity.Builder toV4PointEntity(LatLngOrBuilder geoPointV1) {
        return EntityV4.Entity.newBuilder().addProperty(this.toV4UnindexedProperty("x", geoPointV1.getLatitude())).addProperty(this.toV4UnindexedProperty("y", geoPointV1.getLongitude()));
    }

    private Key.PathElement.Builder toV1PathElement(EntityV4.Key.PathElementOrBuilder keyPathElementV4) throws InvalidConversionException {
        Key.PathElement.Builder pathElementV1 = Key.PathElement.newBuilder();
        pathElementV1.setKindBytes(keyPathElementV4.getKindBytes());
        InvalidConversionException.checkConversion(!keyPathElementV4.hasId() || !keyPathElementV4.hasName(), "Key path element has both id (%d) and name (\"%s\").", keyPathElementV4.getId(), keyPathElementV4.getName());
        if (keyPathElementV4.hasId()) {
            pathElementV1.setId(keyPathElementV4.getId());
        }
        if (keyPathElementV4.hasName()) {
            pathElementV1.setNameBytes(keyPathElementV4.getNameBytes());
        }
        return pathElementV1;
    }

    private EntityV4.Property.Builder toV4UnindexedProperty(String propertyName, double doubleValue) {
        return EntityV4.Property.newBuilder().setName(propertyName).setValue(EntityV4.Value.newBuilder().setDoubleValue(doubleValue).setIndexed(false));
    }
}

