/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.UserIdObfuscator;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public class UserValueObfuscator {
    private static final UserTransform IDENTITY_TRANSFORM = new UserTransform(){

        @Override
        public void apply(OnestoreEntity.PropertyValue.UserValue userValue) {
        }

        @Override
        public void apply(OnestoreEntity.User user) {
        }
    };
    public static final UserValueObfuscator IDENTITY = new UserValueObfuscator(IDENTITY_TRANSFORM, IDENTITY_TRANSFORM, new Function<String, Boolean>(){

        public Boolean apply(String input) {
            return false;
        }
    });
    private final UserTransform obfuscate;
    private final UserTransform unobfuscate;
    private final Function<String, Boolean> isInvalidObfuscatedId;

    public static UserValueObfuscator create(final UserIdObfuscator obfuscator) {
        Preconditions.checkNotNull((Object)obfuscator);
        return new UserValueObfuscator(new UserTransform(){

            @Override
            public void apply(OnestoreEntity.PropertyValue.UserValue user) {
                if (user.getGaiaid() != 0L) {
                    user.setObfuscatedGaiaid(obfuscator.obfuscate(user.getGaiaid()));
                    user.setGaiaid(0L);
                }
            }

            @Override
            public void apply(OnestoreEntity.User user) {
                if (user.getGaiaid() != 0L) {
                    user.setObfuscatedGaiaid(obfuscator.obfuscate(user.getGaiaid()));
                    user.setGaiaid(0L);
                }
            }
        }, new UserTransform(){

            @Override
            public void apply(OnestoreEntity.PropertyValue.UserValue user) throws InvalidConversionException {
                if (user.hasObfuscatedGaiaid()) {
                    user.setGaiaid(obfuscator.unobfuscate(user.getObfuscatedGaiaid()));
                    user.clearObfuscatedGaiaid();
                }
            }

            @Override
            public void apply(OnestoreEntity.User user) throws InvalidConversionException {
                if (user.hasObfuscatedGaiaid()) {
                    user.setGaiaid(obfuscator.unobfuscate(user.getObfuscatedGaiaid()));
                    user.clearObfuscatedGaiaid();
                }
            }
        }, new Function<String, Boolean>(){

            public Boolean apply(String obfuscatedUserId) {
                try {
                    obfuscator.unobfuscate(obfuscatedUserId);
                    return false;
                }
                catch (InvalidConversionException e) {
                    return true;
                }
            }
        });
    }

    private UserValueObfuscator(UserTransform obfuscate, UserTransform unobfuscate, Function<String, Boolean> isInvalidObfuscatedId) {
        this.obfuscate = obfuscate;
        this.unobfuscate = unobfuscate;
        this.isInvalidObfuscatedId = isInvalidObfuscatedId;
    }

    public void obfuscate(OnestoreEntity.EntityProto entity) {
        try {
            UserValueObfuscator.transform(entity, this.obfuscate);
        }
        catch (InvalidConversionException e) {
            throw new IllegalStateException("obfuscation failed", e);
        }
    }

    public void unobfuscate(OnestoreEntity.EntityProto entity) throws InvalidConversionException {
        UserValueObfuscator.transform(entity, this.unobfuscate);
    }

    public void obfuscate(DatastorePb.PutRequest req) {
        for (OnestoreEntity.EntityProto proto : req.entitys()) {
            this.obfuscate(proto);
        }
    }

    public void obfuscate(DatastorePb.Query req) {
        for (DatastorePb.Query.Filter filter : req.filters()) {
            for (OnestoreEntity.Property prop : filter.propertys()) {
                this.obfuscate(prop);
            }
        }
    }

    public void unobfuscateIndexPropertyValue(OnestoreEntity.PropertyValue value) throws InvalidConversionException {
        UserValueObfuscator.transform(value, null, this.unobfuscate);
    }

    public boolean containsInvalidObfuscatedUserId(OnestoreEntity.PropertyValue.UserValue userValue) {
        if (!userValue.hasObfuscatedGaiaid()) {
            return false;
        }
        return (Boolean)this.isInvalidObfuscatedId.apply((Object)userValue.getObfuscatedGaiaid());
    }

    public boolean containsInvalidObfuscatedUserId(OnestoreEntity.User user) {
        if (!user.hasObfuscatedGaiaid()) {
            return false;
        }
        return (Boolean)this.isInvalidObfuscatedId.apply((Object)user.getObfuscatedGaiaid());
    }

    private void obfuscate(OnestoreEntity.Property prop) {
        try {
            UserValueObfuscator.transform(prop, this.obfuscate);
        }
        catch (InvalidConversionException e) {
            throw new IllegalStateException("obfuscation failed", e);
        }
    }

    public static void transform(OnestoreEntity.EntityProto entity, UserTransform userTransform) throws InvalidConversionException {
        if (entity.hasOwner()) {
            userTransform.apply(entity.getOwner());
        }
        for (OnestoreEntity.Property prop : entity.propertys()) {
            UserValueObfuscator.transform(prop, userTransform);
        }
        for (OnestoreEntity.Property prop : entity.rawPropertys()) {
            UserValueObfuscator.transform(prop, userTransform);
        }
    }

    public static void transform(OnestoreEntity.Property prop, UserTransform userTransform) throws InvalidConversionException {
        if (prop.hasValue()) {
            UserValueObfuscator.transform(prop.getValue(), prop.getMeaningEnum(), userTransform);
        }
    }

    public static void transform(OnestoreEntity.PropertyValue propertyValue, @Nullable OnestoreEntity.Property.Meaning meaning, UserTransform userTransform) throws InvalidConversionException {
        if (propertyValue.hasUserValue()) {
            userTransform.apply(propertyValue.getUserValue());
        } else if (propertyValue.hasStringValue() && meaning == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
            OnestoreEntity.EntityProto subEntity;
            try {
                subEntity = (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.PARSER.parsePartialFrom(propertyValue.getStringValueAsBytes());
            }
            catch (InvalidProtocolBufferException e) {
                return;
            }
            UserValueObfuscator.transform(subEntity, userTransform);
            propertyValue.setStringValueAsBytes(subEntity.toByteArray());
        }
    }

    public static interface UserTransform {
        public void apply(OnestoreEntity.PropertyValue.UserValue var1) throws InvalidConversionException;

        public void apply(OnestoreEntity.User var1) throws InvalidConversionException;
    }
}

