/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.methods;

import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpConnection;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpState;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.ExpectContinueMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.multipart.FilePart;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.multipart.Part;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.multipart.StringPart;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultipartPostMethod
extends ExpectContinueMethod {
    public static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static final Log LOG = LogFactory.getLog(MultipartPostMethod.class);
    private final List parameters = new ArrayList();

    public MultipartPostMethod() {
    }

    public MultipartPostMethod(String string) {
        super(string);
    }

    protected boolean hasRequestContent() {
        return true;
    }

    public String getName() {
        return "POST";
    }

    public void addParameter(String string, String string2) {
        LOG.trace("enter addParameter(String parameterName, String parameterValue)");
        StringPart stringPart = new StringPart(string, string2);
        this.parameters.add(stringPart);
    }

    public void addParameter(String string, File file) throws FileNotFoundException {
        LOG.trace("enter MultipartPostMethod.addParameter(String parameterName, File parameterFile)");
        FilePart filePart = new FilePart(string, file);
        this.parameters.add(filePart);
    }

    public void addParameter(String string, String string2, File file) throws FileNotFoundException {
        LOG.trace("enter MultipartPostMethod.addParameter(String parameterName, String fileName, File parameterFile)");
        FilePart filePart = new FilePart(string, string2, file);
        this.parameters.add(filePart);
    }

    public void addPart(Part part) {
        LOG.trace("enter addPart(Part part)");
        this.parameters.add(part);
    }

    public Part[] getParts() {
        return this.parameters.toArray(new Part[this.parameters.size()]);
    }

    protected void addContentLengthRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter EntityEnclosingMethod.addContentLengthRequestHeader(HttpState, HttpConnection)");
        if (this.getRequestHeader("Content-Length") == null) {
            long l = this.getRequestContentLength();
            this.addRequestHeader("Content-Length", String.valueOf(l));
        }
        this.removeRequestHeader("Transfer-Encoding");
    }

    protected void addContentTypeRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter EntityEnclosingMethod.addContentTypeRequestHeader(HttpState, HttpConnection)");
        if (!this.parameters.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
            if (Part.getBoundary() != null) {
                stringBuffer.append("; boundary=");
                stringBuffer.append(Part.getBoundary());
            }
            this.setRequestHeader("Content-Type", stringBuffer.toString());
        }
    }

    protected void addRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter MultipartPostMethod.addRequestHeaders(HttpState state, HttpConnection conn)");
        super.addRequestHeaders(httpState, httpConnection);
        this.addContentLengthRequestHeader(httpState, httpConnection);
        this.addContentTypeRequestHeader(httpState, httpConnection);
    }

    protected boolean writeRequestBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter MultipartPostMethod.writeRequestBody(HttpState state, HttpConnection conn)");
        OutputStream outputStream = httpConnection.getRequestOutputStream();
        Part.sendParts(outputStream, this.getParts());
        return true;
    }

    protected long getRequestContentLength() throws IOException {
        LOG.trace("enter MultipartPostMethod.getRequestContentLength()");
        return Part.getLengthOfParts(this.getParts());
    }

    public void recycle() {
        LOG.trace("enter MultipartPostMethod.recycle()");
        super.recycle();
        this.parameters.clear();
    }
}

