/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameter;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpressionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ProjectionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrderOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReferenceOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.QueryHelper;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.Map;
import java.util.regex.Pattern;

public class CloudDatastoreV1Validator {
    private static final Pattern GQL_ARG_NAME_CHARACTER_SET_PATTERN = Pattern.compile("[A-Za-z0-9_$\u0080-\uffff]*");
    protected final EntityV1Validator entityValidator;

    public CloudDatastoreV1Validator(EntityV1Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    public EntityV1Validator getEntityValidator() {
        return this.entityValidator;
    }

    static ValidationConstraint constraintForMutation(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return ValidationConstraint.INSERT;
            }
            case UPDATE: {
                return ValidationConstraint.UPDATE;
            }
            case UPSERT: {
                return ValidationConstraint.UPSERT;
            }
            case DELETE: {
                return ValidationConstraint.DELETE;
            }
        }
        throw new ValidationException("Mutation is missing operation.");
    }

    public void validateMutation(ValidationConstraint constraint, String projectId, Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                this.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutation.getInsert());
                this.validateProjectIdMatches(projectId, (PartitionIdOrBuilder)mutation.getInsert().getKey().getPartitionId());
                break;
            }
            case UPDATE: {
                this.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutation.getUpdate());
                this.validateProjectIdMatches(projectId, (PartitionIdOrBuilder)mutation.getUpdate().getKey().getPartitionId());
                break;
            }
            case UPSERT: {
                this.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutation.getUpsert());
                this.validateProjectIdMatches(projectId, (PartitionIdOrBuilder)mutation.getUpsert().getKey().getPartitionId());
                break;
            }
            case DELETE: {
                this.entityValidator.validateKey(constraint, (KeyOrBuilder)mutation.getDelete());
                this.validateProjectIdMatches(projectId, (PartitionIdOrBuilder)mutation.getDelete().getPartitionId());
                break;
            }
            default: {
                throw new ValidationException("mutation lacks required op");
            }
        }
    }

    public void validateProjectIdMatches(String projectId, PartitionIdOrBuilder partitionId) throws ValidationException {
        if (projectId.isEmpty() || partitionId.getProjectId().isEmpty()) {
            return;
        }
        ValidationException.validateAssertion(projectId.equals(partitionId.getProjectId()), "expected project id %s, found %s", projectId, partitionId.getProjectId());
    }

    public void validateCommitMode(CommitRequest.Mode mode, boolean hasTransaction) throws ValidationException {
        switch (mode) {
            case MODE_UNSPECIFIED: 
            case TRANSACTIONAL: {
                ValidationException.validateAssertion(hasTransaction, "transactional commit requires a transaction", new Object[0]);
                break;
            }
            case NON_TRANSACTIONAL: {
                ValidationException.validateAssertion(!hasTransaction, "non-transaction commit cannot specify a transaction", new Object[0]);
                break;
            }
            default: {
                String string = String.valueOf(mode);
                throw new ValidationException(new StringBuilder(21 + String.valueOf(string).length()).append("unknown commit mode: ").append(string).toString());
            }
        }
    }

    public void validateQuery(ValidationConstraint constraint, boolean isStrongReadConsistency, QueryOrBuilder query) throws ValidationException {
        ValidationException.validateAssertion(!isStrongReadConsistency || QueryHelper.hasAncestorFilter(query), "global queries do not support strong consistency", new Object[0]);
        if (query.hasFilter()) {
            this.validateFilter(constraint, query.getFilter());
        }
        for (KindExpressionOrBuilder kindExp : query.getKindOrBuilderList()) {
            this.validateKindExpression(constraint, kindExp);
        }
        for (PropertyReferenceOrBuilder propRef : query.getDistinctOnOrBuilderList()) {
            this.validatePropertyReference(constraint, propRef);
        }
        for (ProjectionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validateProjection(constraint, propExp);
        }
        for (PropertyOrderOrBuilder order : query.getOrderOrBuilderList()) {
            this.validatePropertyOrder(constraint, order);
        }
        ValidationException.validateAssertion(query.getLimit().getValue() >= 0, "Limit must be non-negative.", new Object[0]);
        ValidationException.validateAssertion(query.getOffset() >= 0, "Offset must be non-negative.", new Object[0]);
    }

    public void validateGqlQuery(GqlQueryOrBuilder gqlQuery) throws ValidationException {
        this.entityValidator.validateStringUtf8(gqlQuery.getQueryStringBytes(), "GQL query string");
        for (Map.Entry namedGqlQueryParam : gqlQuery.getNamedBindings().entrySet()) {
            String name = (String)namedGqlQueryParam.getKey();
            ByteString nameBytes = ByteString.copyFromUtf8((String)name);
            this.entityValidator.validateStringNotEmpty(nameBytes, "GQL query parameter name is empty.");
            ValidationException.validateAssertion(GQL_ARG_NAME_CHARACTER_SET_PATTERN.matcher(name).matches(), "GQL query parameter name \"%s\" contains an invalid character.", name);
            ValidationException.validateAssertion(!Character.isDigit(name.charAt(0)), "GQL query parameter name \"%s\" starts with a digit.", name);
            this.entityValidator.validateStringNotReserved(nameBytes, "GQL query parameter name");
            this.validateGqlQueryParam((GqlQueryParameter)namedGqlQueryParam.getValue());
        }
        for (GqlQueryParameter numberedGqlQueryParam : gqlQuery.getPositionalBindingsList()) {
            this.validateGqlQueryParam(numberedGqlQueryParam);
        }
    }

    private void validateGqlQueryParam(GqlQueryParameter gqlQueryParam) throws ValidationException {
        switch (gqlQueryParam.getParameterTypeCase()) {
            case VALUE: 
            case CURSOR: {
                break;
            }
            case PARAMETERTYPE_NOT_SET: {
                throw new ValidationException("A GQL query parameter has neither value nor cursor.");
            }
            default: {
                String string = String.valueOf(gqlQueryParam.getParameterTypeCase());
                throw new ValidationException(new StringBuilder(39 + String.valueOf(string).length()).append("Unrecognized GQL query parameter_type: ").append(string).toString());
            }
        }
    }

    private void validatePropertyOrder(ValidationConstraint constraint, PropertyOrderOrBuilder order) throws ValidationException {
        this.validatePropertyReference(constraint, (PropertyReferenceOrBuilder)order.getProperty());
    }

    private void validateProjection(ValidationConstraint constraint, ProjectionOrBuilder propExp) throws ValidationException {
        this.validatePropertyReference(constraint, propExp.getPropertyOrBuilder());
    }

    private void validateKindExpression(ValidationConstraint constraint, KindExpressionOrBuilder kindExp) throws ValidationException {
        this.entityValidator.validateStringUtf8(kindExp.getNameBytes(), "kind");
        this.entityValidator.validateKind(constraint, kindExp.getNameBytes());
    }

    void validatePropertyReference(ValidationConstraint constraint, PropertyReferenceOrBuilder propertyRef) throws ValidationException {
        this.entityValidator.validateStringUtf8(propertyRef.getNameBytes(), "property name");
        this.entityValidator.validatePropertyName(constraint, propertyRef.getNameBytes());
    }

    private void validateFilter(ValidationConstraint constraint, Filter filter) throws ValidationException {
        switch (filter.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                CompositeFilterOrBuilder cmpFilter = filter.getCompositeFilterOrBuilder();
                ValidationException.validateAssertion(cmpFilter.getOp() != CompositeFilter.Operator.OPERATOR_UNSPECIFIED, "a composite filter must specify an operator", new Object[0]);
                ValidationException.validateAssertion(cmpFilter.getFiltersCount() > 0, "a composite filter must have at least one sub-filter", new Object[0]);
                for (Filter subFilter : cmpFilter.getFiltersList()) {
                    this.validateFilter(constraint, subFilter);
                }
                break;
            }
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
                ValidationException.validateAssertion(propFilter.getOp() != PropertyFilter.Operator.OPERATOR_UNSPECIFIED, "a property filter must specify an operator", new Object[0]);
                this.validatePropertyReference(constraint, propFilter.getPropertyOrBuilder());
                ValidationException.validateAssertion(!propFilter.getValueOrBuilder().getExcludeFromIndexes(), "a filter value must be indexed", new Object[0]);
                if (propFilter.getProperty().getName().endsWith(".__key__")) {
                    constraint = constraint.withContext(ValidationConstraint.Context.IN_FILTER_ON_ENTITY_VALUE_KEY);
                }
                this.entityValidator.validateValue(constraint, propFilter.getValue(), 0, 0, propFilter.getPropertyOrBuilder().getName());
                break;
            }
            case FILTERTYPE_NOT_SET: {
                throw new ValidationException("a filter must have exactly one of its fields set");
            }
            default: {
                String string = String.valueOf(filter.getFilterTypeCase());
                throw new ValidationException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized filter_type: ").append(string).toString());
            }
        }
    }
}

