/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.CompositeIndexManager;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.xml.XmlParser;
import org.xml.sax.SAXException;

class LocalCompositeIndexManager
extends CompositeIndexManager {
    private static final String DATASTORE_INDEXES_ELEMENT_FORMAT = "<datastore-indexes%s>\n\n";
    private static final String DATASTORE_INDEXES_ELEMENT_EMPTY = String.format("<datastore-indexes%s>\n\n", "/");
    private static final String DATASTORE_INDEXES_ELEMENT_NOT_EMPTY = String.format("<datastore-indexes%s>\n\n", "");
    private static final String DATASTORE_INDEXES_ELEMENT_CLOSE = "</datastore-indexes>\n";
    private static final String FREQUENCY_XML_COMMENT_FORMAT = "    <!-- Used %d time%s in query history -->\n";
    private static final String TIMESTAMP_XML_COMMENT_FORMAT = "<!-- Indices written at %s -->\n\n";
    private static final Predicate<XmlParser.Node> MANUAL_INDEX_ONLY = new Predicate<XmlParser.Node>(){

        public boolean apply(XmlParser.Node datastoreIndexNode) {
            String sourceStr = datastoreIndexNode.getAttribute("source");
            return sourceStr == null || CompositeIndexManager.IndexSource.valueOf((String)LocalCompositeIndexManager.trim(sourceStr)) == CompositeIndexManager.IndexSource.manual;
        }
    };
    private static final Logger logger = Logger.getLogger(LocalCompositeIndexManager.class.getName());
    private static final LocalCompositeIndexManager INSTANCE = new LocalCompositeIndexManager();
    private final Map<IndexComponentsOnlyQuery, AtomicInteger> queryHistory = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private final IndexCache indexCache = new IndexCache();
    private File appDir;
    private Clock clock = Clock.DEFAULT;
    private boolean autoGenerateIndexes = true;

    LocalCompositeIndexManager() {
    }

    public static LocalCompositeIndexManager getInstance() {
        return INSTANCE;
    }

    public void processQuery(DatastorePb.Query query) {
        IndexComponentsOnlyQuery indexOnlyQuery = new IndexComponentsOnlyQuery(query);
        boolean isNewQuery = this.updateQueryHistory(indexOnlyQuery);
        if (isNewQuery) {
            this.manageIndexFile(indexOnlyQuery);
        }
    }

    private boolean updateQueryHistory(IndexComponentsOnlyQuery query) {
        boolean newQuery = false;
        AtomicInteger count = this.queryHistory.get((Object)query);
        if (count == null) {
            count = this.newAtomicInteger(0);
            AtomicInteger overwrittenCount = this.queryHistory.put(query, count);
            if (overwrittenCount != null) {
                count.addAndGet(overwrittenCount.intValue());
            } else {
                newQuery = true;
            }
        }
        count.incrementAndGet();
        return newQuery;
    }

    void clearQueryHistory() {
        this.queryHistory.clear();
    }

    AtomicInteger newAtomicInteger(int i) {
        return new AtomicInteger(i);
    }

    Map<IndexComponentsOnlyQuery, AtomicInteger> getQueryHistory() {
        return this.queryHistory;
    }

    private void manageIndexFile(IndexComponentsOnlyQuery query) {
        XmlParser.Node datastoreIndexesNode = this.getDatastoreIndexesNode();
        try {
            if (datastoreIndexesNode != null && !this.autoGenerateIndexes(datastoreIndexesNode)) {
                this.indexCache.verifyIndexExistsForQuery(query, datastoreIndexesNode);
                logger.fine("Skipping index file update because auto gen is disabled.");
                return;
            }
        }
        catch (SAXException e) {
            String msg = "Received SAXException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, (Throwable)e);
        }
        if (this.autoGenerateIndexes) {
            this.updateIndexFile(datastoreIndexesNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<OnestoreEntity.Index> getIndices() {
        List<OnestoreEntity.Index> manuallyAddedIndices = null;
        Set<Object> autoGeneratedIndices = null;
        Map<IndexComponentsOnlyQuery, AtomicInteger> map = this.queryHistory;
        synchronized (map) {
            XmlParser.Node datastoreIndexesNode = this.getDatastoreIndexesNode();
            try {
                if (datastoreIndexesNode != null && !this.autoGenerateIndexes(datastoreIndexesNode)) {
                    manuallyAddedIndices = this.extractAllIndices(datastoreIndexesNode);
                    autoGeneratedIndices = Collections.emptySet();
                } else {
                    manuallyAddedIndices = this.extractIndices(datastoreIndexesNode, MANUAL_INDEX_ONLY);
                    autoGeneratedIndices = this.buildIndexMapFromQueryHistory().keySet();
                }
            }
            catch (SAXException e) {
                logger.log(Level.SEVERE, null, e);
                throw new AppEngineConfigException((Throwable)e);
            }
        }
        LinkedHashSet combined = Sets.newLinkedHashSet(autoGeneratedIndices);
        combined.addAll(manuallyAddedIndices);
        return combined;
    }

    Collection<OnestoreEntity.Index> getIndicesForKind(String kind) {
        LinkedHashSet indices = Sets.newLinkedHashSet();
        for (OnestoreEntity.Index index : this.getIndices()) {
            if (!index.getEntityType().equals(kind)) continue;
            indices.add(index);
        }
        return indices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexFile(XmlParser.Node datastoreIndexesNode) {
        Map<IndexComponentsOnlyQuery, AtomicInteger> map = this.queryHistory;
        synchronized (map) {
            List<OnestoreEntity.Index> manuallyAddedIndices = this.extractIndices(datastoreIndexesNode, MANUAL_INDEX_ONLY);
            Map<OnestoreEntity.Index, Integer> indexMap = this.buildIndexMapFromQueryHistory();
            for (OnestoreEntity.Index manuallyAddedIndex : manuallyAddedIndices) {
                indexMap.remove(manuallyAddedIndex);
            }
            try {
                this.writeIndexFile(indexMap);
            }
            catch (IOException e) {
                String string = String.valueOf(this.getGeneratedIndexFile());
                logger.log(Level.SEVERE, new StringBuilder(16 + String.valueOf(string).length()).append("Unable to write ").append(string).toString(), e);
            }
        }
    }

    private List<OnestoreEntity.Index> extractAllIndices(XmlParser.Node datastoreIndexesNode) {
        return this.extractIndices(datastoreIndexesNode, (Predicate<XmlParser.Node>)Predicates.alwaysTrue());
    }

    List<OnestoreEntity.Index> extractIndices(XmlParser.Node datastoreIndexesNode, Predicate<XmlParser.Node> indexPred) {
        if (datastoreIndexesNode == null) {
            return Collections.emptyList();
        }
        ArrayList indices = Lists.newArrayList();
        Iterator datastoreIndexIter = datastoreIndexesNode.iterator("datastore-index");
        while (datastoreIndexIter.hasNext()) {
            XmlParser.Node datastoreIndexNode = (XmlParser.Node)datastoreIndexIter.next();
            if (!indexPred.apply((Object)datastoreIndexNode)) continue;
            OnestoreEntity.Index index = new OnestoreEntity.Index();
            indices.add(index);
            index.setEntityType(LocalCompositeIndexManager.trim(datastoreIndexNode.getAttribute("kind")));
            String ancestorValue = datastoreIndexNode.getAttribute("ancestor");
            boolean ancestor = ancestorValue == null ? false : Boolean.valueOf(LocalCompositeIndexManager.trim(ancestorValue));
            index.setAncestor(ancestor);
            Iterator propertyIter = datastoreIndexNode.iterator("property");
            while (propertyIter.hasNext()) {
                String modeValue;
                XmlParser.Node propertyNode = (XmlParser.Node)propertyIter.next();
                OnestoreEntity.Index.Property prop = index.addProperty();
                prop.setName(LocalCompositeIndexManager.trim(propertyNode.getAttribute("name")));
                String directionValue = propertyNode.getAttribute("direction");
                if (directionValue != null) {
                    XmlDirection dir = XmlDirection.valueOf(LocalCompositeIndexManager.trim(directionValue));
                    prop.setDirection(dir.getDirection());
                }
                if ((modeValue = propertyNode.getAttribute("mode")) == null) continue;
                XmlMode mode = XmlMode.valueOf(LocalCompositeIndexManager.trim(modeValue));
                prop.setMode(mode.getMode());
            }
        }
        return indices;
    }

    private boolean autoGenerateIndexes(XmlParser.Node datastoreIndexesNode) throws SAXException {
        String autoGenerate = datastoreIndexesNode.getAttribute("autoGenerate");
        if (autoGenerate == null || !"true".equals(autoGenerate) && !"false".equals(autoGenerate)) {
            throw new SAXException("autoGenerate=true|false is required in datastore-indexes.xml");
        }
        return Boolean.valueOf(autoGenerate);
    }

    private static String trim(String attribute) {
        return attribute == null ? null : attribute.trim();
    }

    InputStream getIndexFileInputStream() {
        try {
            return new FileInputStream(this.getIndexFile());
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    InputStream newGeneratedIndexFileInputStream() {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                try {
                    return new FileInputStream(LocalCompositeIndexManager.this.getGeneratedIndexFile());
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        });
    }

    synchronized XmlParser.Node getDatastoreIndexesNode() {
        XmlParser.Node datastoreIndexesNode;
        InputStream indexFileInputStream = this.getIndexFileInputStream();
        if (indexFileInputStream == null) {
            return null;
        }
        XmlParser xmlParser = new XmlParser();
        try {
            datastoreIndexesNode = xmlParser.parse(indexFileInputStream);
        }
        catch (IOException e) {
            String message = "Received IOException parsing the input stream.";
            logger.log(Level.SEVERE, message, e);
            throw new AppEngineConfigException(message, (Throwable)e);
        }
        catch (SAXException e) {
            String message = "Received SAXException parsing the input stream.";
            logger.log(Level.SEVERE, message, e);
            throw new AppEngineConfigException(message, (Throwable)e);
        }
        InputStream generatedIndexFileInputStream = this.newGeneratedIndexFileInputStream();
        if (generatedIndexFileInputStream != null) {
            try {
                datastoreIndexesNode.addAll((Collection)xmlParser.parse(generatedIndexFileInputStream));
            }
            catch (IOException e) {
                String message = "Received IOException parsing the generated input stream.";
                throw new AppEngineConfigException(message, (Throwable)e);
            }
            catch (SAXException e) {
                String message = "Received SAXException parsing the generated input stream.";
                throw new AppEngineConfigException(message, (Throwable)e);
            }
        }
        return datastoreIndexesNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeIndexFile(Map<OnestoreEntity.Index, Integer> autoUpdateIndexMap) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        Writer fw = this.newGeneratedIndexFileWriter();
        try (BufferedWriter out = null;){
            out = new BufferedWriter(fw);
            out.append(String.format(TIMESTAMP_XML_COMMENT_FORMAT, format.format(new Date(this.clock.getCurrentTime()))));
            if (autoUpdateIndexMap.isEmpty()) {
                out.append(DATASTORE_INDEXES_ELEMENT_EMPTY);
            } else {
                out.append(DATASTORE_INDEXES_ELEMENT_NOT_EMPTY);
                for (Map.Entry<OnestoreEntity.Index, Integer> entry : autoUpdateIndexMap.entrySet()) {
                    int count = entry.getValue();
                    out.append(String.format(FREQUENCY_XML_COMMENT_FORMAT, count, count == 1 ? "" : "s"));
                    String xml = this.generateXmlForIndex(entry.getKey(), CompositeIndexManager.IndexSource.auto);
                    out.append(xml);
                }
                out.append(DATASTORE_INDEXES_ELEMENT_CLOSE);
            }
        }
    }

    Map<OnestoreEntity.Index, Integer> buildIndexMapFromQueryHistory() {
        LinkedHashMap indexMap = Maps.newLinkedHashMap();
        Preconditions.checkState((boolean)Thread.holdsLock(this.queryHistory), (Object)"Current thread does not have a lock on queryHistory!");
        for (Map.Entry<IndexComponentsOnlyQuery, AtomicInteger> entry : this.queryHistory.entrySet()) {
            OnestoreEntity.Index index = this.compositeIndexForQuery(entry.getKey());
            if (index == null) continue;
            Integer count = (Integer)indexMap.get(index);
            if (count == null) {
                count = 0;
            }
            count = count + entry.getValue().intValue();
            indexMap.put(index, count);
        }
        return indexMap;
    }

    public List<OnestoreEntity.Index> queryIndexList(DatastorePb.Query query) {
        IndexComponentsOnlyQuery indexOnlyQuery = new IndexComponentsOnlyQuery(query);
        OnestoreEntity.Index index = this.compositeIndexForQuery(indexOnlyQuery);
        List<Object> indexList = index != null ? Collections.singletonList(index) : Collections.emptyList();
        return indexList;
    }

    Writer newGeneratedIndexFileWriter() throws IOException {
        File output = this.getGeneratedIndexFile();
        output.getParentFile().mkdirs();
        return new FileWriter(output);
    }

    File getGeneratedIndexFile() {
        File dir = GenerationDirectory.getGenerationDirectory((File)this.appDir);
        return new File(dir, "datastore-indexes-auto.xml");
    }

    private File getIndexFile() {
        return new File(new File(this.appDir, "WEB-INF"), "datastore-indexes.xml");
    }

    private String getIndexFilename() {
        return this.getIndexFile().getPath();
    }

    public void setAppDir(File appDir) {
        this.appDir = appDir;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setNoIndexAutoGen(boolean noIndexAutoGen) {
        this.autoGenerateIndexes = !noIndexAutoGen;
    }

    protected OnestoreEntity.Index compositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery) {
        return super.compositeIndexForQuery((CompositeIndexManager.IndexComponentsOnlyQuery)indexOnlyQuery);
    }

    protected OnestoreEntity.Index minimumCompositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery, Collection<OnestoreEntity.Index> indexes) {
        return super.minimumCompositeIndexForQuery((CompositeIndexManager.IndexComponentsOnlyQuery)indexOnlyQuery, indexes);
    }

    protected static class IndexComponentsOnlyQuery
    extends CompositeIndexManager.IndexComponentsOnlyQuery {
        protected IndexComponentsOnlyQuery(DatastorePb.Query query) {
            super(query);
        }

        public DatastorePb.Query getV3Query() {
            return super.getQuery();
        }
    }

    protected static class KeyTranslator
    extends CompositeIndexManager.KeyTranslator {
        private KeyTranslator() {
        }
    }

    protected static class ValidatedQuery
    extends CompositeIndexManager.ValidatedQuery {
        protected ValidatedQuery(DatastorePb.Query query) {
            super(query);
        }

        public DatastorePb.Query getV3Query() {
            return super.getQuery();
        }
    }

    private final class IndexCache {
        private Set<OnestoreEntity.Index> indexCache = null;

        private IndexCache() {
        }

        private synchronized void verifyIndexExistsForQuery(IndexComponentsOnlyQuery query, XmlParser.Node datastoreIndexesNode) {
            OnestoreEntity.Index minimumIndex;
            OnestoreEntity.Index index;
            if (this.indexCache == null) {
                this.indexCache = Sets.newHashSet((Iterable)LocalCompositeIndexManager.this.extractAllIndices(datastoreIndexesNode));
            }
            if ((index = LocalCompositeIndexManager.this.compositeIndexForQuery(query)) != null && !this.indexCache.contains(index) && (minimumIndex = LocalCompositeIndexManager.this.minimumCompositeIndexForQuery(query, this.indexCache)) != null) {
                String string = String.valueOf((Object)query);
                String string2 = LocalCompositeIndexManager.this.getIndexFilename();
                String message = new StringBuilder(126 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Query ").append(string).append(" requires a composite index that is not ").append("defined. You must update ").append(string2).append(" or enable autoGenerate to ").append("have it automatically added.").toString();
                if (!minimumIndex.equals(index)) {
                    string = String.valueOf(message);
                    string2 = String.valueOf(LocalCompositeIndexManager.this.generateXmlForIndex(minimumIndex, CompositeIndexManager.IndexSource.manual));
                    message = new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("\n\nThe minimum required index is:\n").append(string2).toString();
                }
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.NEED_INDEX.getValue(), message);
            }
        }
    }

    private static enum XmlMode {
        geospatial{

            @Override
            OnestoreEntity.Index.Property.Mode getMode() {
                return OnestoreEntity.Index.Property.Mode.GEOSPATIAL;
            }
        };


        abstract OnestoreEntity.Index.Property.Mode getMode();
    }

    private static enum XmlDirection {
        asc{

            @Override
            OnestoreEntity.Index.Property.Direction getDirection() {
                return OnestoreEntity.Index.Property.Direction.ASCENDING;
            }
        }
        ,
        desc{

            @Override
            OnestoreEntity.Index.Property.Direction getDirection() {
                return OnestoreEntity.Index.Property.Direction.DESCENDING;
            }
        };


        abstract OnestoreEntity.Index.Property.Direction getDirection();
    }
}

