/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalCloudDatastoreV1Service;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponseOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Datastore;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.DatastoreV4ServiceValidator;
import com.google.apphosting.datastore.shared.DatastoreV4Validator;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ValidationException;

@ServiceProvider(value=LocalRpcService.class)
public class LocalDatastoreV4Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "datastore_v4";
    private static final DatastoreV4ServiceValidator LOCAL_VALIDATOR = new DatastoreV4ServiceValidator(new DatastoreV4Validator(new EntityV4Validator(Config.DatastoreConfig.getDefaultInstance())));

    public String getPackage() {
        return PACKAGE;
    }

    public DatastoreV4.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastoreV4.AllocateIdsRequest req) {
        DatastorePb.AllocateIdsResponse respV3;
        DatastoreV4.AllocateIdsResponse.Builder respBuilder = DatastoreV4.AllocateIdsResponse.newBuilder();
        try {
            LOCAL_VALIDATOR.validateAllocateIdsRequest((DatastoreV4.AllocateIdsRequestOrBuilder)req);
            DatastorePb.AllocateIdsRequest reqV3 = new DatastorePb.AllocateIdsRequest();
            reqV3.setSize((long)req.getAllocateCount());
            respV3 = (DatastorePb.AllocateIdsResponse)LocalDatastoreV4Service.makeV3Call(DatastorePb.DatastoreService_3.Method.AllocateIds, (MessageLite)reqV3, DatastorePb.AllocateIdsResponse.parser());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        if (respV3.getEnd() - respV3.getStart() + 1L < (long)req.getAllocateCount()) {
            throw new ApiProxy.ApplicationException(3, "could not allocate sufficent ids");
        }
        long i = respV3.getStart();
        for (EntityV4.Key reqKey : req.getAllocateList()) {
            EntityV4.Key.Builder respKey = EntityV4.Key.newBuilder().mergeFrom(reqKey);
            respKey.getPathElementBuilder(respKey.getPathElementCount() - 1).setId(LocalDatastoreService.toScatteredId(i++));
            respBuilder.addAllocated(respKey);
        }
        return respBuilder.build();
    }

    public DatastoreV4.BeginTransactionResponse beginTransaction(LocalRpcService.Status status, DatastoreV4.BeginTransactionRequest req) {
        DatastorePb.BeginTransactionRequest reqV3 = LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV3BeginTransactionRequest(LocalCloudDatastoreV1Service.getAppId(), (DatastoreV4.BeginTransactionRequestOrBuilder)req);
        DatastorePb.Transaction internalResp = (DatastorePb.Transaction)LocalDatastoreV4Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)reqV3, DatastorePb.Transaction.parser());
        try {
            return LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV4BeginTransactionResponse(internalResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    public DatastoreV4.CommitResponse commit(LocalRpcService.Status status, DatastoreV4.CommitRequest req) {
        DatastoreV4.CommitResponse.Builder res;
        CommitResponse resV1;
        try {
            LOCAL_VALIDATOR.validateCommitRequest((DatastoreV4.CommitRequestOrBuilder)req);
            CommitRequest reqV1 = LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV1CommitRequest(LocalCloudDatastoreV1Service.RESOLVER, req).build();
            resV1 = (CommitResponse)this.makeV1Call(Datastore.Method.Commit, (MessageLite)reqV1, CommitResponse.parser());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            res = LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV4CommitResponse(LocalCloudDatastoreV1Service.RESOLVER, (CommitResponseOrBuilder)resV1);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
        Preconditions.checkArgument((!res.hasDeprecatedMutationResult() ? 1 : 0) != 0, (Object)"unexpected deprecated mutation result");
        if (req.hasDeprecatedMutation()) {
            DatastoreV4.DeprecatedMutationResult.Builder deprecatedResult = DatastoreV4.DeprecatedMutationResult.newBuilder();
            for (DatastoreV4.MutationResult result : res.getMutationResultList()) {
                if (!result.hasKey()) continue;
                deprecatedResult.addInsertAutoIdKey(result.getKey());
            }
            deprecatedResult.setIndexUpdates(res.getIndexUpdates());
            res.setDeprecatedMutationResult(deprecatedResult);
            res.clearIndexUpdates();
            res.clearMutationResult();
        }
        for (DatastoreV4.MutationResult.Builder result : res.getMutationResultBuilderList()) {
            result.setNewVersion(12345L);
        }
        return res.build();
    }

    public DatastoreV4.RollbackResponse rollback(LocalRpcService.Status status, DatastoreV4.RollbackRequest req) {
        try {
            LocalDatastoreV4Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Rollback, (MessageLite)LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV3Transaction((DatastoreV4.RollbackRequestOrBuilder)req, LocalCloudDatastoreV1Service.getAppId()), ApiBasePb.VoidProto.parser());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        return DatastoreV4.RollbackResponse.getDefaultInstance();
    }

    public DatastoreV4.LookupResponse get(LocalRpcService.Status status, DatastoreV4.LookupRequest request) {
        return this.lookup(status, request);
    }

    public DatastoreV4.LookupResponse lookup(LocalRpcService.Status status, DatastoreV4.LookupRequest request) {
        DatastorePb.GetResponse internResp;
        try {
            LOCAL_VALIDATOR.validateLookupRequest((DatastoreV4.LookupRequestOrBuilder)request);
            internResp = (DatastorePb.GetResponse)LocalDatastoreV4Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV3GetRequest((DatastoreV4.LookupRequestOrBuilder)request, LocalCloudDatastoreV1Service.getAppId()), DatastorePb.GetResponse.parser());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV4LookupResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    private DatastoreV4.RunQueryRequest normalizeRunQueryRequest(DatastoreV4.RunQueryRequest request) throws ValidationException, InvalidConversionException {
        if (request.hasGqlQuery()) {
            ValidationException.validateAssertion(!request.hasQuery(), "1 (and only 1) of fields Query.query and Query.gql_query must be set", new Object[0]);
            LOCAL_VALIDATOR.getDatastoreV4Validator().validateGqlQuery((DatastoreV4.GqlQueryOrBuilder)request.getGqlQuery());
            request = DatastoreV4.RunQueryRequest.newBuilder((DatastoreV4.RunQueryRequest)request).setQuery(LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.getDatastoreProtoConverter().toV4Query((DatastoreV4.GqlQueryOrBuilder)request.getGqlQuery(), request.getPartitionId())).clearGqlQuery().build();
        }
        return request;
    }

    public DatastoreV4.RunQueryResponse runQuery(LocalRpcService.Status status, DatastoreV4.RunQueryRequest request) {
        DatastorePb.QueryResult internResp;
        try {
            request = this.normalizeRunQueryRequest(request);
            LOCAL_VALIDATOR.validateRunQueryRequest((DatastoreV4.RunQueryRequestOrBuilder)request);
            internResp = (DatastorePb.QueryResult)LocalDatastoreV4Service.makeV3Call(DatastorePb.DatastoreService_3.Method.RunQuery, (MessageLite)LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV3Query((DatastoreV4.RunQueryRequestOrBuilder)request, LocalCloudDatastoreV1Service.getAppId()), DatastorePb.QueryResult.parser());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV4RunQueryResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    public DatastoreV4.ContinueQueryResponse continueQuery(LocalRpcService.Status status, DatastoreV4.ContinueQueryRequest request) {
        DatastorePb.QueryResult internResp;
        try {
            internResp = (DatastorePb.QueryResult)LocalDatastoreV4Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Next, (MessageLite)LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV3NextRequest((DatastoreV4.ContinueQueryRequestOrBuilder)request), DatastorePb.QueryResult.parser());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return LocalCloudDatastoreV1Service.LOCAL_SERVICE_CONVERTER.toV4ContinueQueryResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    private <T> T makeV1Call(Datastore.Method method, MessageLite req, Parser<T> respParser) {
        byte[] responseBytes;
        try {
            responseBytes = ApiProxy.makeSyncCall((String)"cloud_datastore_v1", (String)method.name(), (byte[])req.toByteArray());
        }
        catch (ApiProxy.ApplicationException e) {
            if (e instanceof LocalCloudDatastoreV1Service.CanonicalCodeException) {
                throw new ApiProxy.ApplicationException(((LocalCloudDatastoreV1Service.CanonicalCodeException)e).getOriginalApplicationError(), e.getErrorDetail());
            }
            throw e;
        }
        try {
            return (T)respParser.parseFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ApiProxy.ApplicationException(13, e.getMessage());
        }
    }

    private static <T> T makeV3Call(DatastorePb.DatastoreService_3.Method method, MessageLite req, Parser<T> respParser) {
        return LocalCloudDatastoreV1Service.makeV3Call(method, req, respParser, false);
    }
}

