/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.ExpressionBuilder;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import java.util.Map;
import java.util.TreeMap;

abstract class BinaryNumericExpression
extends NumericExpression {
    private NumericExpression left;
    private NumericExpression right;
    private static final Map<Integer, Class<? extends BinaryNumericExpression>> binaryOps = new TreeMap<Integer, Class<? extends BinaryNumericExpression>>();

    BinaryNumericExpression() {
    }

    void init(NumericExpression left, NumericExpression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public double evalDouble(Document doc) throws EvaluationException {
        double leftValue = this.left.evalDouble(doc);
        double rightValue = this.right.evalDouble(doc);
        return this.op(leftValue, rightValue);
    }

    public abstract double op(double var1, double var3);

    private static void setupExpression(int id, Class<? extends BinaryNumericExpression> clazz) {
        binaryOps.put(id, clazz);
    }

    static BinaryNumericExpression make(int type) {
        Exception caughtException;
        try {
            return binaryOps.get(type).newInstance();
        }
        catch (IllegalAccessException e) {
            caughtException = e;
        }
        catch (InstantiationException e) {
            caughtException = e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            caughtException = e;
        }
        String string = String.valueOf(ExpressionBuilder.getTokenName(type));
        throw new RuntimeException(string.length() != 0 ? "Internal error: ".concat(string) : new String("Internal error: "), caughtException);
    }

    static {
        BinaryNumericExpression.setupExpression(19, Multiply.class);
        BinaryNumericExpression.setupExpression(20, Divide.class);
        BinaryNumericExpression.setupExpression(17, Add.class);
        BinaryNumericExpression.setupExpression(18, Subtract.class);
        BinaryNumericExpression.setupExpression(11, Less.class);
        BinaryNumericExpression.setupExpression(13, Greater.class);
        BinaryNumericExpression.setupExpression(12, LessEqual.class);
        BinaryNumericExpression.setupExpression(15, Equal.class);
        BinaryNumericExpression.setupExpression(16, NotEqual.class);
        BinaryNumericExpression.setupExpression(14, GreaterEqual.class);
    }

    public static class GreaterEqual
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a >= b ? 1.0 : 0.0;
        }
    }

    public static class NotEqual
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a != b ? 1.0 : 0.0;
        }
    }

    public static class Equal
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a == b ? 1.0 : 0.0;
        }
    }

    public static class LessEqual
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a <= b ? 1.0 : 0.0;
        }
    }

    public static class Greater
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a > b ? 1.0 : 0.0;
        }
    }

    public static class Less
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a < b ? 1.0 : 0.0;
        }
    }

    public static class Subtract
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a - b;
        }
    }

    public static class Add
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a + b;
        }
    }

    public static class Divide
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a / b;
        }
    }

    public static class Multiply
    extends BinaryNumericExpression {
        @Override
        public double op(double a, double b) {
            return a * b;
        }
    }
}

