/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.datastore.rep.AutoValue_EntityRef;
import com.google.apphosting.datastore.rep.AutoValue_EntityRef_PathElement;
import com.google.apphosting.datastore.rep.AutoValue_EntityRef_ResourceId;
import com.google.apphosting.datastore.rep.PartitionRef;
import com.google.apphosting.datastore.rep.ResourceRef;
import com.google.auto.value.AutoValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityRef
implements ResourceRef {
    private OnestoreEntity.Reference v3Reference = null;

    public abstract PartitionRef partitionRef();

    public abstract ImmutableList<PathElement> path();

    public EntityRef root() {
        Preconditions.checkState((!this.path().isEmpty() ? 1 : 0) != 0);
        if (this.path().size() == 1) {
            return this;
        }
        OnestoreEntity.Reference v3Ref = this.v3Reference();
        if (v3Ref != null) {
            v3Ref = (OnestoreEntity.Reference)v3Ref.clone();
            v3Ref.getPath().mutableElements().remove(this.path().size() - 1);
        }
        return EntityRef.create(this.partitionRef(), (PathElement)this.path().get(0)).withV3Reference(v3Ref);
    }

    public EntityRef parent() {
        Preconditions.checkState((!this.path().isEmpty() ? 1 : 0) != 0);
        int pathSize = this.path().size();
        OnestoreEntity.Reference v3Ref = this.v3Reference();
        if (v3Ref != null) {
            v3Ref = (OnestoreEntity.Reference)v3Ref.clone();
            v3Ref.getPath().mutableElements().remove(pathSize - 1);
        }
        return EntityRef.create(this.partitionRef(), (List<PathElement>)this.path().subList(0, pathSize - 1)).withV3Reference(v3Ref);
    }

    public PathElement lastPathElement() {
        Preconditions.checkState((!this.path().isEmpty() ? 1 : 0) != 0);
        return (PathElement)this.path().get(this.path().size() - 1);
    }

    public String collectionId() {
        return this.lastPathElement().collectionId();
    }

    @Nullable
    public ResourceId resourceId() {
        return this.lastPathElement().resourceId();
    }

    public static EntityRef create(PartitionRef partitionRef, List<PathElement> path) {
        return new AutoValue_EntityRef(partitionRef, (ImmutableList<PathElement>)ImmutableList.copyOf(path));
    }

    public static EntityRef create(PartitionRef partitionRef, PathElement ... pathElements) {
        return EntityRef.create(partitionRef, (List<PathElement>)ImmutableList.copyOf((Object[])pathElements));
    }

    @Deprecated
    @Nullable
    public OnestoreEntity.Reference v3Reference() {
        return this.v3Reference;
    }

    @Deprecated
    public EntityRef withV3Reference(OnestoreEntity.Reference v3Reference) {
        AutoValue_EntityRef result = new AutoValue_EntityRef(this.partitionRef(), this.path());
        result.v3Reference = v3Reference;
        return result;
    }

    @AutoValue
    public static abstract class PathElement {
        public abstract String collectionId();

        @Nullable
        public abstract ResourceId resourceId();

        public static PathElement create(String collectionId, @Nullable ResourceId resourceId) {
            return new AutoValue_EntityRef_PathElement(collectionId, resourceId);
        }
    }

    @AutoValue
    public static abstract class ResourceId {
        @Nullable
        public abstract String asString();

        public abstract long asLong();

        public boolean isLong() {
            return 0L != this.asLong();
        }

        public static ResourceId createString(String stringId) {
            Preconditions.checkArgument((stringId != null ? 1 : 0) != 0);
            return new AutoValue_EntityRef_ResourceId(stringId, 0L);
        }

        public static ResourceId createLong(long longId) {
            Preconditions.checkArgument((longId != 0L ? 1 : 0) != 0);
            return new AutoValue_EntityRef_ResourceId(null, longId);
        }
    }
}

