/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.datastore.exception.DatastoreException;
import com.google.apphosting.datastore.rep.AutoValue_EntityTransformation;
import com.google.apphosting.datastore.rep.AutoValue_EntityTransformation_PropertyTransformation;
import com.google.apphosting.datastore.rep.AutoValue_EntityTransformation_TransformationResult;
import com.google.apphosting.datastore.rep.Entity;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyMaskHelper;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.Value;
import com.google.auto.value.AutoValue;
import java.util.HashMap;
import java.util.Map;

@AutoValue
public abstract class EntityTransformation {
    public abstract ImmutableList<PropertyTransformation> propertyTransformations();

    public static EntityTransformation create(ImmutableList<PropertyTransformation> propertyTransformations) {
        return new AutoValue_EntityTransformation((ImmutableList<PropertyTransformation>)((ImmutableList)Preconditions.checkNotNull(propertyTransformations)));
    }

    public TransformationResult transform(Entity entity) throws DatastoreException {
        Map<PropertyPath, Value> transformValues = this.getOriginalValues(entity);
        ImmutableList.Builder transformResultSequence = ImmutableList.builder();
        for (PropertyTransformation propertyTransformation : this.propertyTransformations()) {
            Value previousValue = transformValues.get(propertyTransformation.propertyPath());
            Value transformedValue = (Value)propertyTransformation.function().apply((Object)previousValue);
            transformResultSequence.add((Object)transformedValue);
            transformValues.put(propertyTransformation.propertyPath(), transformedValue);
        }
        Entity maskEntity = Entity.create(entity.ref(), transformValues);
        PropertyMask mask = PropertyMaskHelper.convertPathsToMask(transformValues.keySet());
        Entity transformedEntity = mask.entityCopyAndMaskReplace(entity, maskEntity);
        return TransformationResult.create(transformedEntity, (ImmutableList<Value>)transformResultSequence.build());
    }

    private Map<PropertyPath, Value> getOriginalValues(Entity entity) throws DatastoreException {
        HashMap<PropertyPath, Value> result = new HashMap<PropertyPath, Value>();
        for (PropertyTransformation propertyTransformation : this.propertyTransformations()) {
            PropertyPath path = propertyTransformation.propertyPath();
            if (result.containsKey(path)) continue;
            result.put(path, path.getFrom(entity.propertyMap()));
        }
        return result;
    }

    @AutoValue
    public static abstract class TransformationResult {
        public abstract Entity transformedEntity();

        public abstract ImmutableList<Value> transformedValues();

        public static TransformationResult create(Entity entity, ImmutableList<Value> values) {
            return new AutoValue_EntityTransformation_TransformationResult(entity, values);
        }
    }

    @AutoValue
    public static abstract class PropertyTransformation {
        public abstract PropertyPath propertyPath();

        public abstract Function<Value, Value> function();

        public static PropertyTransformation create(PropertyPath propertyPath, Function<Value, Value> function) {
            return new AutoValue_EntityTransformation_PropertyTransformation((PropertyPath)Preconditions.checkNotNull((Object)propertyPath), (Function<Value, Value>)((Function)Preconditions.checkNotNull(function)));
        }
    }
}

