/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.cloudv1;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.PropertyPathValidator;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.service.common.PropertyPathToMaskConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CloudDatastoreV1PropertyPathToRepConverter {
    public static final CloudDatastoreV1PropertyPathToRepConverter INSTANCE = new CloudDatastoreV1PropertyPathToRepConverter();
    private static final PropertyPathToMaskConverter PROPERTY_PATH_TO_MASK_CONVERTER = new PropertyPathToMaskConverter(PropertyPathValidator.INSTANCE);

    public PropertyMask convertPropertyMask(com.google.appengine.repackaged.com.google.datastore.v1.PropertyMask apiPropertyMask) throws InvalidConversionException {
        ArrayList<PropertyPath> propertyPaths = new ArrayList<PropertyPath>();
        for (ByteString apiPropertyPathByteString : apiPropertyMask.getPathsList().asByteStringList()) {
            propertyPaths.add(this.convertPropertyPath(apiPropertyPathByteString));
        }
        propertyPaths.add(PropertyPath.KEY);
        return PROPERTY_PATH_TO_MASK_CONVERTER.validateAndConvertPathsToMask(propertyPaths);
    }

    public PropertyPath convertPropertyPath(ByteString apiPathByteString) throws InvalidConversionException {
        PropertyPath propertyPath = PropertyPath.createFromSegments(this.convertPropertyPathToPropertyPathSegments(apiPathByteString));
        return propertyPath;
    }

    private List<PropertyPathSegment> convertPropertyPathToPropertyPathSegments(ByteString apiPathByteString) throws InvalidConversionException {
        int numBytes = apiPathByteString.size();
        InvalidConversionException.checkConversion(numBytes != 0, "a property path must not be empty.", new Object[0]);
        byte[] byteArray = new byte[numBytes];
        ArrayList<PropertyPathSegment> segments = new ArrayList<PropertyPathSegment>();
        int nameIndex = 0;
        for (int pathIndex = 0; pathIndex < numBytes; ++pathIndex) {
            byte b = apiPathByteString.byteAt(pathIndex);
            if (b == 46) {
                this.addPropertyName(segments, byteArray, nameIndex);
                nameIndex = 0;
                continue;
            }
            if (b == 92) {
                InvalidConversionException.checkConversion(++pathIndex < numBytes, "property path ends in %c", (byte)92);
                b = apiPathByteString.byteAt(pathIndex);
                InvalidConversionException.checkConversion(b == 46 || b == 92, "unnown escaped character %c in property path", b);
            }
            byteArray[nameIndex] = b;
            ++nameIndex;
        }
        this.addPropertyName(segments, byteArray, nameIndex);
        return segments;
    }

    private void addPropertyName(List<PropertyPathSegment> segments, byte[] byteArray, int numBytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(numBytes > 0, "property path contains empty name", new Object[0]);
        byte[] propertyNameByteArray = Arrays.copyOf(byteArray, numBytes);
        PropertyName propertyName = PropertyName.from(propertyNameByteArray);
        SpecialPropertyDescriptor special = propertyName.special();
        InvalidConversionException.checkConversion(special == null || special == SpecialPropertyDescriptor.KEY, "property path contains reserved name", new Object[0]);
        segments.add(PropertyPathSegment.Member.create(propertyName));
    }
}

