/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.exception.ValidationException;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyMaskHelper;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathValidator;
import java.util.Collection;

public class PropertyPathToMaskConverter {
    private final PropertyPathValidator propertyPathValidator;

    public PropertyPathToMaskConverter(PropertyPathValidator propertyPathValidator) {
        this.propertyPathValidator = propertyPathValidator;
    }

    public PropertyMask validateAndConvertPathsToMask(Collection<PropertyPath> propertyPaths) throws InvalidConversionException {
        try {
            for (PropertyPath propertyPath : propertyPaths) {
                this.propertyPathValidator.validatePropertyPathForMask(propertyPath);
            }
        }
        catch (ValidationException exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
        return PropertyMaskHelper.convertPathsToMask(propertyPaths);
    }
}

