/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2PaddedCell;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;

@GwtCompatible
public strictfp class S2ShapeIndex {
    @VisibleForTesting
    static final double CELL_PADDING = 2.0 * (S2EdgeUtil.FACE_CLIP_ERROR_UV_COORD + S2EdgeUtil.EDGE_CLIP_ERROR_UV_COORD);
    private final Options options;
    @VisibleForTesting
    final List<IdShape> shapes = Lists.newArrayList();
    private List<Cell> cells = Collections.emptyList();
    private int nextShapeId = 0;
    private int pendingInsertionsBegin = 0;
    private final List<S2Shape> pendingRemovals = Lists.newArrayList();
    private volatile boolean isIndexFresh = true;
    private static final Function<IdShape, S2Shape> TO_SHAPE = new Function<IdShape, S2Shape>(){

        public S2Shape apply(IdShape shape) {
            return shape.shape;
        }
    };

    public S2ShapeIndex() {
        this(new Options());
    }

    public S2ShapeIndex(Options options) {
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    public List<S2Shape> getShapes() {
        return Lists.transform(this.shapes, TO_SHAPE);
    }

    int numShapes() {
        return this.shapes.size();
    }

    IdShape shape(int id) {
        return this.shapes.get(id);
    }

    public void add(S2Shape shape) {
        this.shapes.add(new IdShape(this.nextShapeId++, shape));
        this.isIndexFresh = false;
    }

    public void remove(S2Shape shape) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void reset() {
        this.cells = Collections.emptyList();
        this.pendingRemovals.clear();
        this.shapes.clear();
        this.isIndexFresh = false;
        this.pendingInsertionsBegin = 0;
        this.nextShapeId = 0;
    }

    public CellIterator iterator() {
        this.applyUpdates();
        return new CellIterator(this);
    }

    public boolean isFresh() {
        return this.isIndexFresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void applyUpdates() {
        if (this.isIndexFresh) {
            return;
        }
        S2ShapeIndex s2ShapeIndex = this;
        synchronized (s2ShapeIndex) {
            if (!this.isIndexFresh) {
                Preconditions.checkState((boolean)this.cells.isEmpty(), (Object)"Incremental updates not supported yet");
                int numEdges = 0;
                for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
                    numEdges += this.shapes.get((int)i).shape.numEdges();
                }
                this.cells = S2ShapeIndex.createList(3 * numEdges / this.options.maxEdgesPerCell / 4);
                List<List<FaceEdge>> allEdges = S2ShapeIndex.createList(6);
                for (int face = 0; face < 6; ++face) {
                    List edges = S2ShapeIndex.createList(numEdges);
                    allEdges.add(edges);
                }
                InteriorTracker tracker = new InteriorTracker(this.shapes.size() - this.pendingInsertionsBegin);
                for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
                    this.addShapeEdges(this.shapes.get(i), allEdges, tracker);
                }
                for (int face = 0; face < 6; ++face) {
                    this.updateFaceEdges(face, allEdges.get(face), tracker);
                    allEdges.set(face, null);
                }
                this.pendingInsertionsBegin = this.shapes.size();
                this.isIndexFresh = true;
            }
        }
    }

    private void reserveSpace(int numEdges, List<List<FaceEdge>> allEdges) {
        int maxCheapMemoryBytes = 0xA00000;
        int faceEdgeSize = 140;
        int maxCheapNumEdges = 12483;
        if (numEdges <= 12483) {
            for (int face = 0; face < 6; ++face) {
                SimpleList edges = new SimpleList(numEdges);
                allEdges.add(edges);
            }
            return;
        }
        int desiredSampleSize = 10000;
        int sampleInterval = Math.max(1, numEdges / 10000);
        int edgeId = sampleInterval / 2;
        S2ShapeUtil.Edge edge = new S2ShapeUtil.Edge();
        int actualSampleSize = (numEdges + edgeId) / sampleInterval;
        int[] faceCount = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = this.pendingInsertionsBegin; i < this.shapes.size(); ++i) {
            S2Shape shape = this.shapes.get((int)i).shape;
            edgeId += shape.numEdges();
            while (edgeId >= sampleInterval) {
                shape.getEdge(edgeId -= sampleInterval, edge);
                int n = S2Projections.xyzToFace(edge.a);
                faceCount[n] = faceCount[n] + 1;
            }
        }
        double maxSemiWidth = 0.02;
        double sampleRatio = 1.0 / (double)actualSampleSize;
        for (int face = 0; face < 6; ++face) {
            SimpleList edges;
            if (faceCount[face] > 0) {
                double fraction = sampleRatio * (double)faceCount[face] + 0.02;
                edges = new SimpleList(1 + (int)fraction * numEdges);
            } else {
                edges = new SimpleList(1);
            }
            allEdges.add(edges);
        }
    }

    private void addShapeEdges(IdShape idShape, List<List<FaceEdge>> allEdges, InteriorTracker tracker) {
        int id = idShape.id;
        S2Shape shape = idShape.shape;
        boolean hasInterior = shape.hasInterior();
        if (hasInterior) {
            tracker.addShape(idShape);
        }
        int numEdges = shape.numEdges();
        S2ShapeUtil.Edge edge = new S2ShapeUtil.Edge();
        R2Vector a = new R2Vector();
        R2Vector b = new R2Vector();
        double ratio = this.options.getCellSizeToLongEdgeRatio();
        for (int e = 0; e < numEdges; ++e) {
            int aFace;
            shape.getEdge(e, edge);
            if (hasInterior) {
                tracker.testEdge(id, edge.a, edge.b);
            }
            if ((aFace = S2Projections.xyzToFace(edge.a)) == S2Projections.xyzToFace(edge.b)) {
                S2Projections.validFaceXyzToUv(aFace, edge.a, a);
                S2Projections.validFaceXyzToUv(aFace, edge.b, b);
                double kMaxUV = 1.0 - CELL_PADDING;
                if (Math.abs(a.x) <= kMaxUV && Math.abs(a.y) <= kMaxUV && Math.abs(b.x) <= kMaxUV && Math.abs(b.y) <= kMaxUV) {
                    allEdges.get(aFace).add(new FaceEdge(id, e, edge.a, edge.b, a, b, ratio));
                    continue;
                }
            }
            for (int face = 0; face < 6; ++face) {
                if (!S2EdgeUtil.clipToPaddedFace(edge.a, edge.b, face, CELL_PADDING, a, b)) continue;
                allEdges.get(face).add(new FaceEdge(idShape.id, e, edge.a, edge.b, a, b, ratio));
            }
        }
    }

    private void updateFaceEdges(int face, List<FaceEdge> faceEdges, InteriorTracker tracker) {
        S2CellId cellid;
        int numEdges = faceEdges.size();
        if (numEdges == 0 && tracker.focusCount == 0) {
            return;
        }
        List<ClippedEdge> clippedEdges = S2ShapeIndex.createList(numEdges);
        R2Rect bound = R2Rect.empty();
        for (int i = 0; i < faceEdges.size(); ++i) {
            FaceEdge edge = faceEdges.get(i);
            ClippedEdge clipped = new ClippedEdge();
            clipped.orig = edge;
            clipped.bound.x().initFromPointPair(edge.ax, edge.bx);
            clipped.bound.y().initFromPointPair(edge.ay, edge.by);
            clippedEdges.add(clipped);
            bound.addRect(clipped.bound);
        }
        S2PaddedCell pcell = new S2PaddedCell(S2CellId.fromFace(face), CELL_PADDING);
        if (tracker.focusCount == 0 && (cellid = pcell.shrinkToFit(bound)).id() != pcell.id().id()) {
            pcell = new S2PaddedCell(cellid, CELL_PADDING);
        }
        this.updateEdges(pcell, clippedEdges, tracker, new EdgeAllocator(clippedEdges.size()));
    }

    void updateEdges(S2PaddedCell pcell, List<ClippedEdge> edges, InteriorTracker tracker, EdgeAllocator alloc) {
        int count = 0;
        boolean isLeaf = true;
        for (int i = 0; i < edges.size(); ++i) {
            ClippedEdge edge = edges.get(i);
            if ((count += pcell.level() < edge.orig.maxLevel ? 1 : 0) <= this.options.getMaxEdgesPerCell()) continue;
            isLeaf = false;
            break;
        }
        if (isLeaf) {
            this.makeLeafCell(pcell, edges, tracker);
            return;
        }
        int numEdges = edges.size();
        List<ClippedEdge> edges00 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges01 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges10 = S2ShapeIndex.createList(numEdges);
        List<ClippedEdge> edges11 = S2ShapeIndex.createList(numEdges);
        ImmutableList ijEdges = ImmutableList.of(edges00, edges01, edges10, edges11);
        int allocSize = alloc.size();
        R2Rect middle = pcell.middle();
        for (int i = 0; i < edges.size(); ++i) {
            ClippedEdge edge = edges.get(i);
            if (edge.bound.x().hi() <= middle.x().lo()) {
                S2ShapeIndex.clipVAxis(edge, middle.y(), edges00, edges01, alloc);
                continue;
            }
            if (edge.bound.x().lo() >= middle.x().hi()) {
                S2ShapeIndex.clipVAxis(edge, middle.y(), edges10, edges11, alloc);
                continue;
            }
            if (edge.bound.y().hi() <= middle.y().lo()) {
                edges00.add(S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), alloc));
                edges10.add(S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), alloc));
                continue;
            }
            if (edge.bound.y().lo() >= middle.y().hi()) {
                edges01.add(S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), alloc));
                edges11.add(S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), alloc));
                continue;
            }
            ClippedEdge left = S2ShapeIndex.clipUBound(edge, true, middle.x().hi(), alloc);
            S2ShapeIndex.clipVAxis(left, middle.y(), edges00, edges01, alloc);
            ClippedEdge right = S2ShapeIndex.clipUBound(edge, false, middle.x().lo(), alloc);
            S2ShapeIndex.clipVAxis(right, middle.y(), edges10, edges11, alloc);
        }
        for (int pos = 0; pos < 4; ++pos) {
            List childEdges = (List)ijEdges.get(S2.posToIJ(pcell.orientation(), pos));
            if (childEdges.isEmpty() && tracker.focusCount <= 0) continue;
            S2PaddedCell childCell = pcell.childAtPos(pos);
            this.updateEdges(childCell, childEdges, tracker, alloc);
        }
        alloc.reset(allocSize);
    }

    private void makeLeafCell(S2PaddedCell pcell, List<ClippedEdge> edges, InteriorTracker tracker) {
        if (tracker.isActive() && !edges.isEmpty()) {
            if (!tracker.atCellId(pcell.id())) {
                tracker.moveTo(pcell.getEntryVertex());
            }
            tracker.drawTo(pcell.getCenter());
            for (int i = 0; i < edges.size(); ++i) {
                ClippedEdge edge = edges.get(i);
                FaceEdge orig = edge.orig;
                tracker.testEdge(orig.shapeId, orig.va, orig.vb);
            }
        }
        S2CellId cellId = pcell.id();
        int numShapes = 0;
        int edgesIndex = 0;
        int trackerIndex = 0;
        while (edgesIndex < edges.size() || trackerIndex < tracker.focusCount) {
            S2ClippedShape clipped;
            int edgeId = edgesIndex < edges.size() ? edges.get(edgesIndex).orig.shapeId : this.nextShapeId;
            int trackerId = trackerIndex < tracker.focusCount ? tracker.focusedShapes[trackerIndex] : this.nextShapeId;
            if (trackerId < edgeId) {
                clipped = S2ClippedShape.Contained.create(cellId, trackerId);
                cellId = null;
                ++trackerIndex;
            } else {
                int firstEdge = edgesIndex;
                while (edgesIndex < edges.size() && edges.get(edgesIndex).orig.shapeId == edgeId) {
                    ++edgesIndex;
                }
                boolean containsCenter = trackerId == edgeId;
                clipped = S2ClippedShape.create(cellId, edgeId, containsCenter, edges, firstEdge, edgesIndex);
                cellId = null;
                if (containsCenter) {
                    ++trackerIndex;
                }
            }
            ((InteriorTracker)tracker).tempClippedShapes[numShapes++] = clipped;
        }
        this.cells.add(Cell.create(numShapes, tracker.tempClippedShapes));
        if (tracker.isActive() && !edges.isEmpty()) {
            tracker.drawTo(pcell.getExitVertex());
            for (int i = 0; i < edges.size(); ++i) {
                ClippedEdge edge = edges.get(i);
                FaceEdge orig = edge.orig;
                tracker.testEdge(orig.shapeId, orig.va, orig.vb);
            }
            tracker.doneCellId(pcell.id());
        }
    }

    private static ClippedEdge updateBound(ClippedEdge edge, boolean uEnd, double u, boolean vEnd, double v, EdgeAllocator alloc) {
        ClippedEdge clipped = alloc.create();
        clipped.orig = edge.orig;
        if (uEnd) {
            clipped.bound.x().set(edge.bound.x().lo(), u);
        } else {
            clipped.bound.x().set(u, edge.bound.x().hi());
        }
        if (vEnd) {
            clipped.bound.y().set(edge.bound.y().lo(), v);
        } else {
            clipped.bound.y().set(v, edge.bound.y().hi());
        }
        return clipped;
    }

    private static ClippedEdge clipUBound(ClippedEdge edge, boolean uEnd, double u, EdgeAllocator alloc) {
        if (!uEnd ? edge.bound.x().lo() >= u : edge.bound.x().hi() <= u) {
            return edge;
        }
        FaceEdge e = edge.orig;
        double v = edge.bound.y().clampPoint(S2EdgeUtil.interpolateDouble(u, e.ax, e.bx, e.ay, e.by));
        boolean vEnd = e.ax > e.bx != e.ay > e.by ^ uEnd;
        return S2ShapeIndex.updateBound(edge, uEnd, u, vEnd, v, alloc);
    }

    private static ClippedEdge clipVBound(ClippedEdge edge, boolean vEnd, double v, EdgeAllocator alloc) {
        if (!vEnd ? edge.bound.y().lo() >= v : edge.bound.y().hi() <= v) {
            return edge;
        }
        FaceEdge e = edge.orig;
        double u = edge.bound.x().clampPoint(S2EdgeUtil.interpolateDouble(v, e.ay, e.by, e.ax, e.bx));
        boolean uEnd = e.ax > e.bx != e.ay > e.by ^ vEnd;
        return S2ShapeIndex.updateBound(edge, uEnd, u, vEnd, v, alloc);
    }

    private static void clipVAxis(ClippedEdge edge, R1Interval middle, List<ClippedEdge> edges0, List<ClippedEdge> edges1, EdgeAllocator alloc) {
        if (edge.bound.y().hi() <= middle.lo()) {
            edges0.add(edge);
        } else if (edge.bound.y().lo() >= middle.hi()) {
            edges1.add(edge);
        } else {
            edges0.add(S2ShapeIndex.clipVBound(edge, true, middle.hi(), alloc));
            edges1.add(S2ShapeIndex.clipVBound(edge, false, middle.lo(), alloc));
        }
    }

    @VisibleForTesting
    static final int getEdgeMaxLevel(S2Point va, S2Point vb, double cellSizeToLongEdgeRatio) {
        double cellSize = va.getDistance(vb) * cellSizeToLongEdgeRatio;
        return S2Projections.PROJ.avgEdge.getMinLevel(cellSize);
    }

    static final <T> List<T> createList(int maxSize) {
        if (maxSize < 256) {
            return new SimpleList(maxSize);
        }
        return new ShardedList(maxSize);
    }

    private strictfp static final class ShardedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private Object[][] elements;
        private int size;

        public ShardedList(int maxItems) {
            this.elements = new Object[1 + (maxItems >> 8)][];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T item) {
            int shard = this.size >> 8;
            if (shard == this.elements.length) {
                this.elements = (Object[][])Arrays.copyOf(this.elements, shard * 2);
                this.elements[shard] = new Object[256];
            } else if (this.elements[shard] == null) {
                this.elements[shard] = new Object[256];
            }
            this.elements[shard][this.size & 0xFF] = item;
            ++this.size;
            return true;
        }

        @Override
        public T get(int index) {
            Object result = this.elements[index >> 8][index & 0xFF];
            return (T)result;
        }

        @Override
        public T set(int index, T value) {
            Object[] result = this.elements[index];
            this.elements[index >> 8][index & 0xFF] = value;
            return (T)result;
        }
    }

    private strictfp static final class SimpleList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private Object[] elements;
        private int size;

        public SimpleList(int maxSize) {
            this.elements = new Object[Math.max(1, maxSize)];
        }

        @Override
        public T get(int index) {
            Object result = this.elements[index];
            return (T)result;
        }

        @Override
        public T set(int index, T value) {
            Object old = this.elements[index];
            this.elements[index] = value;
            return (T)old;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T item) {
            if (this.size == this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, this.size * 2);
            }
            this.elements[this.size++] = item;
            return true;
        }
    }

    strictfp static class InteriorTracker {
        private boolean isActive;
        private S2Point oldFocus;
        private S2Point newFocus;
        private S2Point lastEnd;
        private S2CellId nextCellId;
        private S2EdgeUtil.EdgeCrosser crosser;
        private final int[] focusedShapes;
        private int focusCount;
        private final S2ClippedShape[] tempClippedShapes;

        public InteriorTracker(int numShapes) {
            this.tempClippedShapes = new S2ClippedShape[numShapes];
            this.focusedShapes = new int[numShapes];
            this.isActive = false;
            this.nextCellId = S2CellId.begin(30);
            this.newFocus = S2.origin();
            this.drawTo(S2Point.normalize(S2Projections.faceUvToXyz(0, -1.0, -1.0)));
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void addShape(IdShape idShape) {
            this.isActive = true;
            if (idShape.shape.containsOrigin()) {
                this.toggleShape(idShape.id);
            }
        }

        public void moveTo(S2Point b) {
            this.newFocus = b;
        }

        public void drawTo(S2Point focus) {
            this.oldFocus = this.newFocus;
            this.newFocus = focus;
            this.crosser = new S2EdgeUtil.EdgeCrosser(this.oldFocus, this.newFocus);
            this.lastEnd = null;
        }

        public void testEdge(int shapeId, S2Point start, S2Point end) {
            if (start != this.lastEnd) {
                this.crosser.restartAt(start);
            }
            if (this.crosser.edgeOrVertexCrossing(end)) {
                this.toggleShape(shapeId);
            }
            this.lastEnd = end;
        }

        public void doneCellId(S2CellId cellid) {
            this.nextCellId = cellid.rangeMax().next();
        }

        public boolean atCellId(S2CellId cellid) {
            return cellid.rangeMin().id() == this.nextCellId.id();
        }

        private void toggleShape(int shapeId) {
            if (this.focusCount == 0) {
                this.focusedShapes[0] = shapeId;
                ++this.focusCount;
            } else if (this.focusedShapes[0] == shapeId) {
                if (this.focusCount-- > 1) {
                    System.arraycopy(this.focusedShapes, 1, this.focusedShapes, 0, this.focusCount);
                }
            } else {
                int pos = 0;
                while (this.focusedShapes[pos] < shapeId) {
                    if (++pos != this.focusCount) continue;
                    this.focusedShapes[this.focusCount++] = shapeId;
                    return;
                }
                if (this.focusedShapes[pos] == shapeId) {
                    --this.focusCount;
                    System.arraycopy(this.focusedShapes, pos + 1, this.focusedShapes, pos, this.focusCount - pos);
                } else {
                    System.arraycopy(this.focusedShapes, pos, this.focusedShapes, pos + 1, this.focusCount - pos);
                    this.focusedShapes[pos] = shapeId;
                    ++this.focusCount;
                }
            }
        }
    }

    private strictfp static final class EdgeAllocator {
        private int size;
        private final List<ClippedEdge> edges;

        public EdgeAllocator(int maxEdges) {
            this.edges = S2ShapeIndex.createList(maxEdges);
        }

        public ClippedEdge create() {
            if (this.size == this.edges.size()) {
                this.edges.add(new ClippedEdge());
            }
            return this.edges.get(this.size++);
        }

        public int size() {
            return this.size;
        }

        public void reset(int size) {
            this.size = size;
        }
    }

    private strictfp static class ClippedEdge {
        private FaceEdge orig;
        private final R2Rect bound = new R2Rect();

        private ClippedEdge() {
        }
    }

    private strictfp static final class FaceEdge {
        private final int shapeId;
        private final int edgeId;
        private final int maxLevel;
        private final double ax;
        private final double ay;
        private final double bx;
        private final double by;
        private final S2Point va;
        private final S2Point vb;

        private FaceEdge(int shapeId, int edgeId, S2Point va, S2Point vb, R2Vector a, R2Vector b, double cellSizeToLongEdgeRatio) {
            this.shapeId = shapeId;
            this.edgeId = edgeId;
            this.ax = a.x;
            this.ay = a.y;
            this.bx = b.x;
            this.by = b.y;
            this.va = va;
            this.vb = vb;
            this.maxLevel = S2ShapeIndex.getEdgeMaxLevel(va, vb, cellSizeToLongEdgeRatio);
        }

        public String toString() {
            return "shape " + this.shapeId + " edge " + this.edgeId;
        }
    }

    public strictfp static class CellIterator {
        private S2ShapeIndex index;
        private int pos;

        private CellIterator(S2ShapeIndex index) {
            this.index = index;
        }

        public void reset() {
            this.pos = 0;
        }

        public S2CellId id() {
            return new S2CellId(((Cell)this.index.cells.get(this.pos)).id());
        }

        public Cell cell() {
            return (Cell)this.index.cells.get(this.pos);
        }

        public S2Point center() {
            return this.id().toPoint();
        }

        public void next() {
            ++this.pos;
        }

        public void prev() {
            --this.pos;
        }

        public boolean done() {
            return this.pos == this.index.cells.size();
        }

        public boolean atBegin() {
            return this.pos == 0;
        }

        public void seek(S2CellId target) {
            this.seekFrom(0, target.id());
        }

        private void seekFrom(int start, long target) {
            int end = this.index.cells.size() - 1;
            while (start <= end) {
                int mid = (start + end) / 2;
                long cellId = ((Cell)this.index.cells.get(mid)).id();
                int result = UnsignedLongs.compare((long)cellId, (long)target);
                if (result > 0) {
                    end = mid - 1;
                    continue;
                }
                if (result < 0) {
                    start = mid + 1;
                    continue;
                }
                this.pos = mid;
                return;
            }
            this.pos = start;
        }

        public void seekForward(S2CellId target) {
            if (!this.done() && this.id().lessThan(target)) {
                this.seekFrom(this.pos + 1, target.id());
            }
        }

        public void finish() {
            this.pos = this.index.cells.size();
        }

        public boolean locate(S2Point targetPoint) {
            S2CellId target = S2CellId.fromPoint(targetPoint);
            this.seek(target);
            if (!this.done() && this.id().rangeMin().lessOrEquals(target)) {
                return true;
            }
            if (!this.atBegin()) {
                this.prev();
                if (this.id().rangeMax().greaterOrEquals(target)) {
                    return true;
                }
            }
            return false;
        }

        public CellRelation locate(S2CellId target) {
            this.seek(target.rangeMin());
            if (!this.done()) {
                if (this.id().greaterOrEquals(target) && this.id().rangeMin().lessOrEquals(target)) {
                    return CellRelation.INDEXED;
                }
                if (this.id().lessOrEquals(target.rangeMax())) {
                    return CellRelation.SUBDIVIDED;
                }
            }
            if (!this.atBegin()) {
                this.prev();
                if (this.id().rangeMax().greaterOrEquals(target)) {
                    return CellRelation.INDEXED;
                }
            }
            return CellRelation.DISJOINT;
        }

        public void position(CellIterator it) {
            this.pos = it.pos;
        }
    }

    @VisibleForTesting
    strictfp static abstract class S2ClippedShape
    extends Cell {
        private final int shapeId;

        static S2ClippedShape create(S2CellId cellId, int shapeId, boolean containsCenter, List<ClippedEdge> edges, int start, int end) {
            int numEdges = end - start;
            if (numEdges == 1) {
                return OneEdge.create(cellId, shapeId, containsCenter, edges.get(start));
            }
            int edge = edges.get(start).orig.edgeId;
            for (int i = 1; i < numEdges; ++i) {
                if (edge + i == edges.get(start + i).orig.edgeId) continue;
                return ManyEdges.create(cellId, shapeId, containsCenter, edges, start, end);
            }
            return EdgeRange.create(cellId, shapeId, containsCenter, edge, numEdges);
        }

        private S2ClippedShape(int shapeId, boolean containsCenter) {
            this.shapeId = containsCenter ? ~shapeId : shapeId;
        }

        abstract long cellId();

        final int shapeId() {
            if (this.shapeId < 0) {
                return ~this.shapeId;
            }
            return this.shapeId;
        }

        public final boolean containsCenter() {
            return this.shapeId < 0;
        }

        public abstract int numEdges();

        public abstract int edge(int var1);

        public final boolean containsEdge(int edgeId) {
            for (int e = 0; e < this.numEdges(); ++e) {
                if (this.edge(e) != edgeId) continue;
                return true;
            }
            return false;
        }

        @Override
        final int numShapes() {
            return 1;
        }

        @Override
        final S2ClippedShape clipped(int i) {
            return this;
        }

        private strictfp static abstract class EdgeRange
        extends S2ClippedShape {
            private final int offset;
            private final int count;

            static EdgeRange create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, int offset, int count) {
                if (cellId != null) {
                    final long id = cellId.id();
                    return new EdgeRange(shapeId, containsCenter, offset, count){

                        @Override
                        long cellId() {
                            return id;
                        }
                    };
                }
                return new EdgeRange(shapeId, containsCenter, offset, count){

                    @Override
                    long cellId() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            private EdgeRange(int shapeId, boolean containsCenter, int offset, int count) {
                super(shapeId, containsCenter);
                this.offset = offset;
                this.count = count;
            }

            @Override
            public final int numEdges() {
                return this.count;
            }

            @Override
            public final int edge(int i) {
                return this.offset + i;
            }
        }

        private strictfp static abstract class ManyEdges
        extends S2ClippedShape {
            private final int[] edges;

            static ManyEdges create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, List<ClippedEdge> edges, int start, int end) {
                if (cellId != null) {
                    final long id = cellId.id();
                    return new ManyEdges(shapeId, containsCenter, edges, start, end){

                        @Override
                        long cellId() {
                            return id;
                        }
                    };
                }
                return new ManyEdges(shapeId, containsCenter, (List)edges, start, end){

                    @Override
                    long cellId() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            private ManyEdges(int shapeId, boolean containsCenter, List<ClippedEdge> edges, int start, int end) {
                super(shapeId, containsCenter);
                this.edges = new int[end - start];
                for (int i = 0; i < this.edges.length; ++i) {
                    this.edges[i] = edges.get(i + start).orig.edgeId;
                }
            }

            @Override
            public final int numEdges() {
                return this.edges.length;
            }

            @Override
            public final int edge(int i) {
                return this.edges[i];
            }
        }

        private strictfp static abstract class OneEdge
        extends S2ClippedShape {
            private final int edge;

            static final OneEdge create(@Nullable S2CellId cellId, int shapeId, boolean containsCenter, ClippedEdge clippedEdge) {
                if (cellId != null) {
                    final long id = cellId.id();
                    return new OneEdge(shapeId, containsCenter, clippedEdge){

                        @Override
                        long cellId() {
                            return id;
                        }
                    };
                }
                return new OneEdge(shapeId, containsCenter, clippedEdge){

                    @Override
                    long cellId() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            private OneEdge(int shapeId, boolean containsCenter, ClippedEdge clippedEdge) {
                super(shapeId, containsCenter);
                this.edge = clippedEdge.orig.edgeId;
            }

            @Override
            public final int numEdges() {
                return 1;
            }

            @Override
            public final int edge(int i) {
                return this.edge;
            }
        }

        private strictfp static abstract class Contained
        extends S2ClippedShape {
            static Contained create(@Nullable S2CellId cellId, int shapeId) {
                if (cellId != null) {
                    final long id = cellId.id();
                    return new Contained(shapeId){

                        @Override
                        long cellId() {
                            return id;
                        }
                    };
                }
                return new Contained(shapeId){

                    @Override
                    long cellId() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            private Contained(int shapeId) {
                super(shapeId, true);
            }

            @Override
            public final int numEdges() {
                return 0;
            }

            @Override
            public final int edge(int i) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public strictfp static enum CellRelation {
        INDEXED,
        SUBDIVIDED,
        DISJOINT;

    }

    @VisibleForTesting
    strictfp static abstract class Cell {
        Cell() {
        }

        static Cell create(int size, S2ClippedShape[] tempClippedShapes) {
            switch (size) {
                case 1: {
                    return tempClippedShapes[0];
                }
                case 2: {
                    return new BinaryCell(tempClippedShapes[0], tempClippedShapes[1]);
                }
            }
            return new MultiCell(Arrays.copyOf(tempClippedShapes, size));
        }

        public long id() {
            return this.clipped(0).cellId();
        }

        abstract int numShapes();

        abstract S2ClippedShape clipped(int var1);

        S2ClippedShape findClipped(int shapeId) {
            for (int i = 0; i < this.numShapes(); ++i) {
                S2ClippedShape shape = this.clipped(i);
                if (shape.shapeId() != shapeId) continue;
                return shape;
            }
            return null;
        }

        private strictfp static final class MultiCell
        extends Cell {
            private final S2ClippedShape[] clippedShapes;

            MultiCell(S2ClippedShape[] shapes) {
                this.clippedShapes = shapes;
            }

            @Override
            int numShapes() {
                return this.clippedShapes.length;
            }

            @Override
            S2ClippedShape clipped(int i) {
                return this.clippedShapes[i];
            }
        }

        private strictfp static final class BinaryCell
        extends Cell {
            private final S2ClippedShape shape1;
            private final S2ClippedShape shape2;

            BinaryCell(S2ClippedShape shape1, S2ClippedShape shape2) {
                this.shape1 = shape1;
                this.shape2 = shape2;
            }

            @Override
            int numShapes() {
                return 2;
            }

            @Override
            S2ClippedShape clipped(int i) {
                switch (i) {
                    case 0: {
                        return this.shape1;
                    }
                    case 1: {
                        return this.shape2;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @VisibleForTesting
    strictfp static final class IdShape {
        static final Comparator<IdShape> BY_ID = new Comparator<IdShape>(){

            @Override
            public int compare(IdShape o1, IdShape o2) {
                return Integer.compare(o1.id, o2.id);
            }
        };
        final int id;
        final S2Shape shape;

        public IdShape(int id, S2Shape shape) {
            this.id = id;
            this.shape = shape;
        }
    }

    public strictfp static class Options {
        private int maxEdgesPerCell = 10;
        private double cellSizeToLongEdgeRatio = 1.0;

        public int getMaxEdgesPerCell() {
            return this.maxEdgesPerCell;
        }

        public void setMaxEdgesPerCell(int maxEdgesPerCell) {
            this.maxEdgesPerCell = maxEdgesPerCell;
        }

        public double getCellSizeToLongEdgeRatio() {
            return this.cellSizeToLongEdgeRatio;
        }

        public void setCellSizeToLongEdgeRatio(double cellSizeToLongEdgeRatio) {
            this.cellSizeToLongEdgeRatio = cellSizeToLongEdgeRatio;
        }
    }
}

