/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.apphosting.api.DatastorePb;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DatastoreHelper {
    public static final int MAX_INDEXED_STRING_CHARS = 500;
    public static final int MAX_INDEXED_BLOB_BYTES = 500;
    public static final int MAX_URL_CHARS = 2038;
    public static final int MAX_KEY_PATH_LENGTH = 100;
    public static final int MAX_PARTITION_ID_LENGTH = 100;
    public static final Pattern PARTITION_ID_REGEX = Pattern.compile(String.format("[0-9A-Za-z\\._\\-]{0,%d}", 100));
    @VisibleForTesting
    public static final int MAX_APP_ID_SECTION_LENGTH = 100;
    public static final int MAX_APP_ID_LENGTH = 306;
    private static final String APP_ID_PARTITION_STRING = String.format("[a-z\\d\\-]{1,%d}", 100);
    private static final String APP_ID_DOMAIN_STRING = String.format("[a-z\\d][a-z\\d\\-\\.]{0,%d}", 99);
    private static final String APP_ID_DISPLAY_STRING = String.format("[a-z\\d][a-z\\d\\-]{0,%d}", 99);
    private static final String PROJECT_ID_STRING = String.format("(?:(?:%s):)?(?:%s)", APP_ID_DOMAIN_STRING, APP_ID_DISPLAY_STRING);
    private static final String APP_ID_STRING = String.format("(?:(?<cluster>%s)~)?(?<project>%s)", APP_ID_PARTITION_STRING, PROJECT_ID_STRING);
    private static final String RESERVED_APP_ID_STRING = String.format("(?:(?:%s)~)?((?:%s)|(?:__%s__))", APP_ID_PARTITION_STRING, PROJECT_ID_STRING, PROJECT_ID_STRING);
    public static final Pattern RESERVED_APP_ID_REGEX = Pattern.compile(RESERVED_APP_ID_STRING);
    public static final Pattern APP_ID_REGEX = Pattern.compile(APP_ID_STRING);
    private static final String METADATA_APP_FORMAT = "%s__metadata-%s__";
    private static final Pattern METADATA_APP_ID_REGEX = Pattern.compile(String.format("(?:(?<cluster>%s)~)?(?:__metadata-(?<project>%s)__)", APP_ID_PARTITION_STRING, PROJECT_ID_STRING));
    public static final String KEY_PROPERTY_NAME = "__key__";
    public static final Pattern RESERVED_NAME = Pattern.compile("^__(.*)__$");
    public static final Set<String> ALLOWED_RESERVED_NAMES = ImmutableSet.of((Object)"__version__");
    public static final Set<DatastorePb.Query.Filter.Operator> INEQUALITY_OPERATORS = ImmutableSet.of((Object)DatastorePb.Query.Filter.Operator.GREATER_THAN, (Object)DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL, (Object)DatastorePb.Query.Filter.Operator.LESS_THAN, (Object)DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL);
    public static final int MAX_QUERY_COMPONENTS = 100;
    public static final ImmutableMap<Integer, Codes.Code> CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put((Object)DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), (Object)Codes.Code.INVALID_ARGUMENT).put((Object)DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), (Object)Codes.Code.ABORTED).put((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.NEED_INDEX.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.TIMEOUT.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.PERMISSION_DENIED.getValue(), (Object)Codes.Code.PERMISSION_DENIED).put((Object)DatastorePb.Error.ErrorCode.BIGTABLE_ERROR.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.COMMITTED_BUT_STILL_APPLYING.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.CAPABILITY_DISABLED.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.TRY_ALTERNATE_BACKEND.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.SAFE_TIME_TOO_OLD.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)90000, (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)90001, (Object)Codes.Code.INTERNAL).put((Object)90002, (Object)Codes.Code.INTERNAL).build();

    private DatastoreHelper() {
    }

    public static boolean isMetadataAppId(String appId) {
        return METADATA_APP_ID_REGEX.matcher(appId).matches();
    }

    public static String toMetadataAppId(String appId) {
        Matcher patternMatch = APP_ID_REGEX.matcher(appId);
        if (!patternMatch.matches()) {
            throw new IllegalStateException(String.format("Cannot get metadata app of an invalid app id: %s", appId));
        }
        String clusterName = patternMatch.group("cluster");
        String projectName = patternMatch.group("project");
        clusterName = clusterName == null ? "" : clusterName + "~";
        return String.format(METADATA_APP_FORMAT, clusterName, projectName);
    }

    public static String fromMetadataAppId(String metadataAppId) {
        Matcher patternMatch = METADATA_APP_ID_REGEX.matcher(metadataAppId);
        if (!patternMatch.matches()) {
            throw new IllegalStateException(String.format("Cannot get app of an invalid metadata app id: %s", metadataAppId));
        }
        String clusterName = patternMatch.group("cluster");
        String projectName = patternMatch.group("project");
        clusterName = clusterName == null ? "" : clusterName + "~";
        return clusterName + projectName;
    }

    public static Codes.Code getCanonicalCodeForAppError(int appCode) {
        Codes.Code code = (Codes.Code)CANONICAL_ERROR_MAPPING.get((Object)appCode);
        if (code != null) {
            return code;
        }
        return Codes.Code.UNKNOWN;
    }
}

