/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ApiSerializer;
import com.google.api.server.spi.config.Serializer;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public final class Serializers {
    private Serializers() {
    }

    public static <S extends Serializer<?, ?>> S instantiate(Class<S> serializerClass, Type sourceType) {
        if (!TypeToken.of(Serializers.getSourceType(serializerClass)).isAssignableFrom(sourceType)) {
            throw new IllegalArgumentException(String.format("Can not instantiate %s, the serializer source %s is not assignable from %s", serializerClass, Serializers.getSourceType(serializerClass), sourceType));
        }
        Throwable parentException = null;
        for (SerializerConstructor constructor : SerializerConstructor.values()) {
            try {
                return constructor.construct(serializerClass, sourceType);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to instantiate custom serializer constructor %s%s with source type: %s", new Object[]{serializerClass.getName(), constructor, sourceType});
                throw new IllegalStateException(errorMessage, e);
            }
        }
        String message = String.format("Failed to instantiate custom serializer %s, constructors not found: %s", serializerClass.getName(), Arrays.toString((Object[])SerializerConstructor.values()));
        throw new IllegalStateException(message, parentException);
    }

    public static List<Class<? extends Serializer<?, ?>>> getSerializerClasses(@Nullable Type type, @Nullable ApiSerializationConfig config) {
        ApiSerializationConfig.SerializerConfig serializerConfig;
        if (type == null) {
            return Collections.emptyList();
        }
        TypeToken<?> typeToken = TypeToken.of(type);
        ApiSerializer apiSerialization = typeToken.getRawType().getAnnotation(ApiSerializer.class);
        if (apiSerialization != null) {
            return Collections.singletonList(apiSerialization.value());
        }
        if (config != null && (serializerConfig = config.getSerializerConfig(type)) != null) {
            return Collections.singletonList(serializerConfig.getSerializer());
        }
        ImmutableList directParentTokens = ImmutableList.builder().addAll(typeToken.getGenericInterfaces()).addAll((Iterable)Optional.fromNullable(typeToken.getGenericSuperclass()).asSet()).build();
        ArrayList allParentSerializers = Lists.newArrayList();
        for (TypeToken token : directParentTokens) {
            allParentSerializers.addAll(Serializers.getSerializerClasses(token.getType(), config));
        }
        return allParentSerializers;
    }

    @Nullable
    public static Type getSourceType(@Nullable Class<? extends Serializer<?, ?>> clazz) {
        ParameterizedType types = Serializers.getResolvedType(clazz);
        return types == null ? null : types.getActualTypeArguments()[0];
    }

    @Nullable
    public static Type getTargetType(@Nullable Class<? extends Serializer<?, ?>> clazz) {
        ParameterizedType types = Serializers.getResolvedType(clazz);
        return types == null ? null : types.getActualTypeArguments()[1];
    }

    @Nullable
    private static ParameterizedType getResolvedType(@Nullable Class<? extends Serializer<?, ?>> clazz) {
        if (clazz == null || !Serializer.class.isAssignableFrom(clazz)) {
            return null;
        }
        Iterator i$ = TypeToken.of(clazz).getTypes().interfaces().iterator();
        while (i$.hasNext()) {
            TypeToken token = (TypeToken)i$.next();
            if (!token.getRawType().equals(Serializer.class)) continue;
            Type tokenType = token.getType();
            return tokenType instanceof ParameterizedType ? (ParameterizedType)tokenType : null;
        }
        return null;
    }

    private static enum SerializerConstructor {
        TYPE{

            @Override
            <S extends Serializer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                return (S)((Serializer)serializerClass.getDeclaredConstructor(Type.class).newInstance(sourceType));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of(Type.class);
            }
        }
        ,
        CLASS{

            @Override
            <S extends Serializer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                Class<?> sourceClass = TypeToken.of(sourceType).getRawType();
                return (S)((Serializer)serializerClass.getDeclaredConstructor(Class.class).newInstance(sourceClass));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of(Class.class);
            }
        }
        ,
        DEFAULT{

            @Override
            <S extends Serializer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                return (S)((Serializer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of();
            }
        };


        abstract <S extends Serializer<?, ?>> S construct(Class<S> var1, Type var2) throws Exception;

        abstract ImmutableList<Type> getArgs();

        public String toString() {
            return String.format("(%s)", Joiner.on((String)", ").join(this.getArgs()));
        }
    }
}

