/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiConfig;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import java.util.Arrays;

class ApiAnnotationConfig {
    private ApiConfig config;

    public ApiAnnotationConfig(ApiConfig config) {
        this.config = config;
    }

    public ApiConfig getConfig() {
        return this.config;
    }

    public void setRootIfNotEmpty(String root) {
        if (!Strings.isNullOrEmpty((String)root)) {
            this.config.setRoot(root);
        }
    }

    public void setNameIfNotEmpty(String name) {
        if (!Strings.isNullOrEmpty((String)name)) {
            this.config.setName(name);
        }
    }

    public void setCanonicalNameIfNotEmpty(String canonicalName) {
        if (!Strings.isNullOrEmpty((String)canonicalName)) {
            this.config.setCanonicalName(canonicalName);
        }
    }

    public void setVersionIfNotEmpty(String version) {
        if (!Strings.isNullOrEmpty((String)version)) {
            this.config.setVersion(version);
        }
    }

    public void setTitleIfNotEmpty(String title) {
        if (!Strings.isNullOrEmpty((String)title)) {
            this.config.setTitle(title);
        }
    }

    public void setDescriptionIfNotEmpty(String description) {
        if (!Strings.isNullOrEmpty((String)description)) {
            this.config.setDescription(description);
        }
    }

    public void setDocumentationLinkIfNotEmpty(String documentationLink) {
        if (!Strings.isNullOrEmpty((String)documentationLink)) {
            this.config.setDocumentationLink(documentationLink);
        }
    }

    public void setBackendRootIfNotEmpty(String backendRoot) {
        if (!Strings.isNullOrEmpty((String)backendRoot)) {
            this.config.setBackendRoot(backendRoot);
        }
    }

    public void setIsAbstractIfSpecified(AnnotationBoolean isAbstract) {
        if (isAbstract == AnnotationBoolean.TRUE) {
            this.config.setIsAbstract(true);
        } else if (isAbstract == AnnotationBoolean.FALSE) {
            this.config.setIsAbstract(false);
        }
    }

    public void setIsDefaultVersionIfSpecified(AnnotationBoolean defaultVersion) {
        if (defaultVersion == AnnotationBoolean.TRUE) {
            this.config.setIsDefaultVersion(true);
        } else if (defaultVersion == AnnotationBoolean.FALSE) {
            this.config.setIsDefaultVersion(false);
        }
    }

    public void setUseDatastoreIfSpecified(AnnotationBoolean useDatastore) {
        if (useDatastore == AnnotationBoolean.TRUE) {
            this.config.setUseDatastore(true);
        } else if (useDatastore == AnnotationBoolean.FALSE) {
            this.config.setUseDatastore(false);
        }
    }

    public void setResourceIfNotEmpty(String resource) {
        if (!resource.isEmpty()) {
            this.config.setResource(resource);
        }
    }

    public void setScopesIfNotEmpty(String[] scopes) {
        if (scopes.length > 0) {
            this.config.setScopes(Arrays.asList(scopes));
        }
    }

    public void setAudiencesIfNotEmpty(String[] audiences) {
        if (audiences.length > 0) {
            this.config.setAudiences(Arrays.asList(audiences));
        }
    }

    public void setClientIdsIfNotEmpty(String[] clientIds) {
        if (clientIds.length > 0) {
            this.config.setClientIds(Arrays.asList(clientIds));
        }
    }
}

