/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.guice;

import com.google.api.server.spi.ServletInitializationParameters;
import com.google.api.server.spi.SystemService;
import com.google.api.server.spi.SystemServiceServlet;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigLoader;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.guice.ServiceMap;
import com.google.api.server.spi.guice.SystemServiceModule;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.org.codehaus.jackson.map.module.SimpleModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import javax.annotation.Nullable;

@Singleton
public class GuiceSystemServiceServlet
extends SystemServiceServlet {
    private final ServiceMap services;
    private final SimpleModule jsonParserModule;

    @Inject
    public GuiceSystemServiceServlet(ServiceMap services, @Nullable @SystemServiceModule.JsonParserModule SimpleModule jsonParserModule) {
        this.services = (ServiceMap)Preconditions.checkNotNull((Object)services, (Object)"services");
        this.jsonParserModule = jsonParserModule == null ? super.getJsonParserModule() : jsonParserModule;
    }

    @Override
    protected SystemService createSystemService(ApiConfigLoader configLoader, ApiConfigValidator validator, String appName, ServletInitializationParameters initParameters) throws ApiConfigException {
        SystemService systemService = new SystemService(configLoader, validator, appName);
        for (Class<?> clazz : this.services.getClasses()) {
            this.registerClass(systemService, clazz);
        }
        return systemService;
    }

    private <T> void registerClass(SystemService systemService, Class<T> clazz) throws ApiConfigException {
        systemService.registerService(clazz, this.services.get(clazz));
    }

    @Override
    protected <T> T createService(Class<T> serviceClass) {
        return this.services.get(serviceClass);
    }

    @VisibleForTesting
    protected Collection<Object> getServices() {
        return this.services.getServices();
    }

    @Override
    protected SimpleModule getJsonParserModule() {
        return this.jsonParserModule;
    }

    @VisibleForTesting
    SystemService getSystemService() {
        return this.systemService;
    }
}

