/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.openidconnect.IdToken;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.appengine.repackaged.com.google.api.client.util.Beta;
import com.google.appengine.repackaged.com.google.api.client.util.Key;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;

@Beta
public class GoogleIdToken
extends IdToken {
    public static GoogleIdToken parse(JsonFactory jsonFactory, String idTokenString) throws IOException {
        JsonWebSignature jws = JsonWebSignature.parser(jsonFactory).setPayloadClass(Payload.class).parse(idTokenString);
        return new GoogleIdToken(jws.getHeader(), (Payload)jws.getPayload(), jws.getSignatureBytes(), jws.getSignedContentBytes());
    }

    public GoogleIdToken(JsonWebSignature.Header header, Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
        super(header, payload, signatureBytes, signedContentBytes);
    }

    public boolean verify(GoogleIdTokenVerifier verifier) throws GeneralSecurityException, IOException {
        return verifier.verify(this);
    }

    @Override
    public Payload getPayload() {
        return (Payload)super.getPayload();
    }

    @Beta
    public static class Payload
    extends IdToken.Payload {
        @Key(value="id")
        private String userId;
        @Key(value="cid")
        private String issuee;
        @Key(value="hd")
        private String hostedDomain;
        @Key(value="email")
        private String email;
        @Key(value="verified_email")
        private boolean emailVerified;

        public String getUserId() {
            return this.userId;
        }

        public Payload setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public String getIssuee() {
            return this.issuee;
        }

        public Payload setIssuee(String issuee) {
            this.issuee = issuee;
            return this;
        }

        public String getHostedDomain() {
            return this.hostedDomain;
        }

        public Payload setHostedDomain(String hostedDomain) {
            this.hostedDomain = hostedDomain;
            return this;
        }

        public String getEmail() {
            return this.email;
        }

        public Payload setEmail(String email) {
            this.email = email;
            return this;
        }

        public boolean getEmailVerified() {
            return this.emailVerified;
        }

        public Payload setEmailVerified(boolean emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        @Override
        public Payload setAuthorizationTimeSeconds(Long authorizationTimeSeconds) {
            return (Payload)super.setAuthorizationTimeSeconds(authorizationTimeSeconds);
        }

        @Override
        public Payload setAuthorizedParty(String authorizedParty) {
            return (Payload)super.setAuthorizedParty(authorizedParty);
        }

        @Override
        public Payload setNonce(String nonce) {
            return (Payload)super.setNonce(nonce);
        }

        @Override
        public Payload setAccessTokenHash(String accessTokenHash) {
            return (Payload)super.setAccessTokenHash(accessTokenHash);
        }

        @Override
        public Payload setClassReference(String classReference) {
            return (Payload)super.setClassReference(classReference);
        }

        @Override
        public Payload setMethodsReferences(List<String> methodsReferences) {
            return (Payload)super.setMethodsReferences(methodsReferences);
        }

        @Override
        public Payload setExpirationTimeSeconds(Long expirationTimeSeconds) {
            return (Payload)super.setExpirationTimeSeconds(expirationTimeSeconds);
        }

        @Override
        public Payload setNotBeforeTimeSeconds(Long notBeforeTimeSeconds) {
            return (Payload)super.setNotBeforeTimeSeconds(notBeforeTimeSeconds);
        }

        @Override
        public Payload setIssuedAtTimeSeconds(Long issuedAtTimeSeconds) {
            return (Payload)super.setIssuedAtTimeSeconds(issuedAtTimeSeconds);
        }

        @Override
        public Payload setIssuer(String issuer) {
            return (Payload)super.setIssuer(issuer);
        }

        @Override
        public Payload setAudience(Object audience) {
            return (Payload)super.setAudience(audience);
        }

        @Override
        public Payload setJwtId(String jwtId) {
            return (Payload)super.setJwtId(jwtId);
        }

        @Override
        public Payload setType(String type) {
            return (Payload)super.setType(type);
        }

        @Override
        public Payload setSubject(String subject) {
            return (Payload)super.setSubject(subject);
        }

        @Override
        public Payload set(String fieldName, Object value) {
            return (Payload)super.set(fieldName, value);
        }

        @Override
        public Payload clone() {
            return (Payload)super.clone();
        }
    }
}

