/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class EndpointMethod {
    private final Class<?> endpointClass;
    private final Method method;
    private final TypeToken<?> typeToken;
    private final ResolvedSignature resolvedMethodSignature;
    private List<String> parameterNames;

    private EndpointMethod(Class<?> endpointClass, Method method, TypeToken<?> token) {
        this.endpointClass = endpointClass;
        this.method = method;
        this.resolvedMethodSignature = new ResolvedSignature();
        this.typeToken = token;
    }

    private Type resolve(Type type) {
        return this.typeToken.resolveType(type).getType();
    }

    private Type[] resolve(Type[] types) {
        Type[] resolved = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = this.resolve(types[i]);
        }
        return resolved;
    }

    private static Class<?>[] resolveClasses(Type[] types) {
        Class[] resolved = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = EndpointMethod.getClassFromType(types[i]);
        }
        return resolved;
    }

    public static Class<?> getClassFromType(Type type) {
        Type componentType;
        Class<?> componentClass;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return EndpointMethod.getClassFromType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType && (componentClass = EndpointMethod.getClassFromType(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public Type getReturnType() {
        return this.resolve(this.method.getGenericReturnType());
    }

    public Type[] getParameterTypes() {
        return this.resolve(this.method.getGenericParameterTypes());
    }

    public Class<?>[] getParameterClasses() {
        return EndpointMethod.resolveClasses(this.getParameterTypes());
    }

    private void validateNoWildcards(Type[] types) {
        for (Type type : types) {
            Type resolved = this.typeToken.resolveType(type).getType();
            if (resolved instanceof ParameterizedType) {
                this.validateNoWildcards(((ParameterizedType)resolved).getActualTypeArguments());
                continue;
            }
            if (!(resolved instanceof WildcardType)) continue;
            throw new IllegalArgumentException(String.format("Wildcard type %s not supported", resolved));
        }
    }

    public static EndpointMethod create(Class<?> endpointClass, Method method, TypeToken<?> token) {
        Preconditions.checkNotNull(endpointClass, (Object)"endpointClass");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkArgument((boolean)method.getDeclaringClass().isAssignableFrom(endpointClass), (String)"Method '%s' does belong to interface of class '%s'", (Object[])new Object[]{method, endpointClass});
        Preconditions.checkArgument((boolean)method.getDeclaringClass().equals(token.getRawType()), (String)"Token must be of the method's declaring class '%s'.", (Object[])new Object[]{method.getDeclaringClass()});
        EndpointMethod endpointMethod = new EndpointMethod(endpointClass, method, token);
        endpointMethod.validateNoWildcards(new Type[]{endpointMethod.getReturnType()});
        endpointMethod.validateNoWildcards(endpointMethod.getParameterTypes());
        return endpointMethod;
    }

    public static EndpointMethod create(Class<?> endpointClass, Method method) {
        return EndpointMethod.create(endpointClass, method, TypeToken.of(method.getDeclaringClass()));
    }

    public ResolvedSignature getResolvedMethodSignature() {
        return this.resolvedMethodSignature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointMethod)) {
            return false;
        }
        EndpointMethod m = (EndpointMethod)o;
        return this.getMethod().equals(m.getMethod());
    }

    public String toString() {
        return "Method: " + this.getMethod().toString() + ", Resolved Return Type: " + this.getReturnType() + ", Resolved Parameter Types: " + Arrays.toString(this.getParameterTypes());
    }

    public int hashCode() {
        return Objects.hash(this.getMethod());
    }

    public List<String> getParameterNames() {
        List<String> names = this.parameterNames;
        return names == null ? null : new ArrayList<String>(names);
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public class ResolvedSignature {
        public String getSignatureName() {
            return EndpointMethod.this.getMethod().getName();
        }

        public Class<?>[] getSignatureParameterClasses() {
            return EndpointMethod.this.getParameterClasses();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolvedSignature)) {
                return false;
            }
            ResolvedSignature signature = (ResolvedSignature)o;
            return this.getSignatureName().equals(signature.getSignatureName()) && Arrays.equals(this.getSignatureParameterClasses(), signature.getSignatureParameterClasses());
        }

        public int hashCode() {
            return Objects.hash(this.getSignatureName(), Arrays.hashCode(this.getSignatureParameterClasses()));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getSignatureName()).append("(");
            for (Class<?> clazz : this.getSignatureParameterClasses()) {
                builder.append(clazz.toString()).append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            builder.append(")");
            return builder.toString();
        }
    }
}

