/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ApiSerializer;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.ResourceSerializer;
import com.google.api.server.spi.config.Serializers;
import com.google.api.server.spi.tools.ResourceSchemaProvider;
import java.util.List;
import javax.annotation.Nullable;

abstract class AbstractResourceSchemaProvider
implements ResourceSchemaProvider {
    AbstractResourceSchemaProvider() {
    }

    @Override
    @Nullable
    public ResourceSchema getResourceSchema(Class<?> clazz, ApiSerializationConfig config) {
        return this.getResourceSchemaImpl(clazz, config);
    }

    @Nullable
    private <T> ResourceSchema getResourceSchemaImpl(Class<T> clazz, ApiSerializationConfig config) {
        ApiSerializer apiSerialization = clazz.getAnnotation(ApiSerializer.class);
        List serializerClasses = Serializers.getSerializerClasses(clazz, (ApiSerializationConfig)config);
        if (!serializerClasses.isEmpty() && ResourceSerializer.class.isAssignableFrom((Class)serializerClasses.get(0))) {
            ResourceSerializer resourceSerializer = (ResourceSerializer)Serializers.instantiate((Class)((Class)serializerClasses.get(0)), clazz);
            return resourceSerializer.getResourceSchema();
        }
        return null;
    }
}

