/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.MethodHierarchyReader;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiAuthConfig;
import com.google.api.server.spi.config.ApiCacheControlConfig;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigLoader;
import com.google.api.server.spi.config.ApiConfigSource;
import com.google.api.server.spi.config.ApiFrontendLimitsConfig;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiNamespaceConfig;
import com.google.api.server.spi.config.ApiParameterConfig;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.annotationreader.ApiConfigAnnotationReader;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.tools.ApiConfigGenerator;
import com.google.api.server.spi.tools.JacksonResourceSchemaProvider;
import com.google.api.server.spi.tools.JacksonUtil;
import com.google.api.server.spi.tools.ResourceSchemaProvider;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnotationApiConfigGenerator
implements ApiConfigGenerator {
    private static final double DEFAULT_LILY_DEADLINE = 10.0;
    static final String MAP_SCHEMA_NAME = "JsonMap";
    static final String ANY_SCHEMA_NAME = "_any";
    private final TypeLoader typeLoader;
    private final ApiConfig.Factory configFactory;
    private final ApiConfigLoader configLoader;
    private final ApiConfigValidator validator;
    private final ResourceSchemaProvider resourceSchemaProvider = new JacksonResourceSchemaProvider();
    protected static final ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper();

    public AnnotationApiConfigGenerator() throws ClassNotFoundException {
        this(AnnotationApiConfigGenerator.class.getClassLoader(), new ApiConfig.Factory(), new ApiConfigValidator());
    }

    public AnnotationApiConfigGenerator(ClassLoader classLoader, ApiConfig.Factory configFactory, ApiConfigValidator validator) throws ClassNotFoundException {
        this.typeLoader = new TypeLoader(classLoader);
        this.configFactory = configFactory;
        this.configLoader = this.createConfigLoader();
        this.validator = validator;
    }

    private ApiConfigLoader createConfigLoader() {
        return new ApiConfigLoader(this.configFactory, this.typeLoader, new ApiConfigAnnotationReader(this.typeLoader.getAnnotationTypes()), new ApiConfigSource[0]);
    }

    @Override
    public Map<String, String> generateConfig(Class<?> ... serviceClasses) throws JsonGenerationException, JsonMappingException, IOException, ApiConfigException {
        return this.generateConfig(ServiceContext.create(), serviceClasses);
    }

    @Override
    public Map<String, String> generateConfig(ServiceContext serviceContext, Class<?> ... serviceClasses) throws JsonGenerationException, JsonMappingException, IOException, ApiConfigException {
        Map<String, ObjectNode> jsonApiConfigs = this.generateConfigObjects(serviceContext, serviceClasses);
        LinkedHashMap<String, String> apiConfigJsons = new LinkedHashMap<String, String>(jsonApiConfigs.size());
        for (Map.Entry<String, ObjectNode> entry : jsonApiConfigs.entrySet()) {
            apiConfigJsons.put(entry.getKey(), this.toString(entry.getValue()));
        }
        return apiConfigJsons;
    }

    public String toString(ObjectNode node) throws JsonGenerationException, JsonMappingException, IOException {
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
    }

    private void setNodePropertyNoConflict(ObjectNode node, String key, JsonNode value, String errorMessage) {
        if (!node.path(key).isMissingNode()) {
            throw new IllegalArgumentException(errorMessage);
        }
        node.put(key, value);
    }

    private void setNodePropertyNoConflict(ObjectNode node, String key, JsonNode value) {
        this.setNodePropertyNoConflict(node, key, value, "Multiple values for same key '" + key + "'");
    }

    public Map<String, ObjectNode> generateConfigObjects(Class<?> ... serviceClasses) throws ApiConfigException {
        return this.generateConfigObjects(ServiceContext.create(), serviceClasses);
    }

    public Map<String, ObjectNode> generateConfigObjects(ServiceContext serviceContext, Class<?> ... serviceClasses) throws ApiConfigException {
        final class ApiNode {
            public Collection<ApiConfig> configs;
            public Collection<Class<?>> endpointClasses;

            public ApiNode(Class<?> endpointClass, ApiConfig config) {
                this.configs = Lists.newArrayList((Object[])new ApiConfig[]{config});
                this.endpointClasses = Lists.newArrayList((Object[])new Class[]{endpointClass});
            }
        }
        HashMap<String, ApiNode> apis = new HashMap<String, ApiNode>();
        for (Class<?> serviceClass : serviceClasses) {
            ApiConfig config = this.configLoader.loadConfiguration(serviceContext, serviceClass);
            String fileName = AnnotationApiConfigGenerator.getFileName(config);
            ApiNode node = (ApiNode)apis.get(fileName);
            if (node == null) {
                apis.put(fileName, new ApiNode(serviceClass, config));
                continue;
            }
            node.configs.add(config);
            node.endpointClasses.add(serviceClass);
        }
        LinkedHashMap<String, ObjectNode> result = new LinkedHashMap<String, ObjectNode>();
        for (Map.Entry entry : apis.entrySet()) {
            ObjectNode additionalRoot;
            this.validator.validate(((ApiNode)entry.getValue()).configs);
            ObjectNode root = objectMapper.createObjectNode();
            Iterator<ApiConfig> configs = ((ApiNode)entry.getValue()).configs.iterator();
            Iterator<Class<?>> classes = ((ApiNode)entry.getValue()).endpointClasses.iterator();
            this.generateForService(serviceContext, root, classes.next(), configs.next());
            while (configs.hasNext() && classes.hasNext()) {
                additionalRoot = objectMapper.createObjectNode();
                this.generateForService(serviceContext, additionalRoot, classes.next(), configs.next());
                root = JacksonUtil.mergeObject(root, additionalRoot);
            }
            configs = ((ApiNode)entry.getValue()).configs.iterator();
            classes = ((ApiNode)entry.getValue()).endpointClasses.iterator();
            while (configs.hasNext() && classes.hasNext()) {
                additionalRoot = objectMapper.createObjectNode();
                ApiConfig config = configs.next();
                this.convertApiMethods(classes.next(), additionalRoot, (Map<EndpointMethod, ApiMethodConfig>)config.getApiClassConfig().getMethods(), config.getSerializationConfig());
                root = JacksonUtil.mergeObject(root, additionalRoot);
            }
            result.put((String)entry.getKey(), root);
        }
        return result;
    }

    private static String getFileName(ApiConfig config) {
        return config.getName() + '-' + config.getVersion() + ".api";
    }

    private void generateForService(ServiceContext serviceContext, ObjectNode root, Class<?> serviceClass, ApiConfig config) {
        this.convertApi(root, config);
        this.convertApiAuth(root, config.getAuthConfig());
        this.convertApiFrontendLimits(root, config.getFrontendLimitsConfig());
        this.convertApiCacheControl(root, config.getCacheControlConfig());
        this.convertApiNamespace(root, config.getNamespaceConfig());
    }

    private void convertApi(ObjectNode root, ApiConfig config) {
        root.put("extends", this.getParentApiFile());
        root.put("abstract", config.getIsAbstract());
        root.put("root", config.getRoot());
        root.put("name", config.getName());
        if (config.getCanonicalName() != null) {
            root.put("canonicalName", config.getCanonicalName());
        }
        root.put("version", config.getVersion());
        if (config.getTitle() != null) {
            root.put("title", config.getTitle());
        }
        if (config.getDescription() != null) {
            root.put("description", config.getDescription());
        }
        if (config.getDocumentationLink() != null) {
            root.put("documentation", config.getDocumentationLink());
        }
        root.put("defaultVersion", config.getIsDefaultVersion());
        ObjectNode adapter = objectMapper.createObjectNode();
        adapter.put("bns", config.getBackendRoot());
        adapter.put("deadline", 10.0);
        adapter.put("type", "lily");
        root.put("adapter", (JsonNode)adapter);
    }

    protected String getParentApiFile() {
        return "thirdParty.api";
    }

    private void convertApiAuth(ObjectNode root, ApiAuthConfig config) {
        ObjectNode authConfig = objectMapper.createObjectNode();
        authConfig.put("allowCookieAuth", config.getAllowCookieAuth());
        List blockedRegions = config.getBlockedRegions();
        if (!blockedRegions.isEmpty()) {
            ArrayNode blockedRegionsNode = objectMapper.createArrayNode();
            for (String region : blockedRegions) {
                blockedRegionsNode.add(region);
            }
            authConfig.put("blockedRegions", (JsonNode)blockedRegionsNode);
        }
        root.put("auth", (JsonNode)authConfig);
    }

    private void convertApiFrontendLimits(ObjectNode root, ApiFrontendLimitsConfig config) {
        ObjectNode frontendLimitsConfig = objectMapper.createObjectNode();
        frontendLimitsConfig.put("unregisteredUserQps", config.getUnregisteredUserQps());
        frontendLimitsConfig.put("unregisteredQps", config.getUnregisteredQps());
        frontendLimitsConfig.put("unregisteredDaily", config.getUnregisteredDaily());
        this.convertApiFrontendLimitRules(frontendLimitsConfig, config.getRules());
        root.put("frontendLimits", (JsonNode)frontendLimitsConfig);
    }

    private void convertApiCacheControl(ObjectNode root, ApiCacheControlConfig config) {
        ObjectNode cacheControlConfig = objectMapper.createObjectNode();
        cacheControlConfig.put("type", config.getType());
        cacheControlConfig.put("maxAge", config.getMaxAge());
        root.put("cacheControl", (JsonNode)cacheControlConfig);
    }

    private void convertApiNamespace(ObjectNode root, ApiNamespaceConfig config) {
        if (!config.getOwnerDomain().isEmpty()) {
            root.put("ownerDomain", config.getOwnerDomain());
        }
        if (!config.getOwnerName().isEmpty()) {
            root.put("ownerName", config.getOwnerName());
        }
        if (!config.getPackagePath().isEmpty()) {
            root.put("packagePath", config.getPackagePath());
        }
    }

    private void convertApiFrontendLimitRules(ObjectNode frontendLimitsConfig, List<ApiFrontendLimitsConfig.FrontendLimitsRule> rules) {
        ArrayNode rulesConfig = objectMapper.createArrayNode();
        for (ApiFrontendLimitsConfig.FrontendLimitsRule rule : rules) {
            ObjectNode ruleConfig = objectMapper.createObjectNode();
            ruleConfig.put("match", rule.getMatch());
            ruleConfig.put("qps", rule.getQps());
            ruleConfig.put("userQps", rule.getUserQps());
            ruleConfig.put("daily", rule.getDaily());
            ruleConfig.put("analyticsId", rule.getAnalyticsId());
            rulesConfig.add((JsonNode)ruleConfig);
        }
        frontendLimitsConfig.put("rules", (JsonNode)rulesConfig);
    }

    private void convertApiMethods(Class<?> serviceClass, ObjectNode root, Map<EndpointMethod, ApiMethodConfig> methodConfigs, ApiSerializationConfig serializationConfig) throws IllegalArgumentException, SecurityException {
        ObjectNode methodsNode = objectMapper.createObjectNode();
        ObjectNode descriptorNode = objectMapper.createObjectNode();
        ObjectNode descriptorSchemasNode = objectMapper.createObjectNode();
        ObjectNode descriptorMethodsNode = objectMapper.createObjectNode();
        descriptorNode.put("schemas", (JsonNode)descriptorSchemasNode);
        descriptorNode.put("methods", (JsonNode)descriptorMethodsNode);
        MethodHierarchyReader methodReader = new MethodHierarchyReader(serviceClass);
        this.convertApiMethods(methodsNode, descriptorSchemasNode, descriptorMethodsNode, methodConfigs, serializationConfig);
        root.put("methods", (JsonNode)methodsNode);
        root.put("descriptor", (JsonNode)descriptorNode);
    }

    private void convertApiMethods(ObjectNode methodsNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodsNode, Map<EndpointMethod, ApiMethodConfig> methodConfigs, ApiSerializationConfig serializationConfig) throws IllegalArgumentException, SecurityException {
        for (Map.Entry<EndpointMethod, ApiMethodConfig> methodConfig : methodConfigs.entrySet()) {
            EndpointMethod endpointMethod = methodConfig.getKey();
            ApiMethodConfig config = methodConfig.getValue();
            this.convertApiMethod(methodsNode, descriptorSchemasNode, descriptorMethodsNode, endpointMethod, config, serializationConfig);
        }
    }

    private void convertApiMethod(ObjectNode methodsNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodsNode, EndpointMethod endpointMethod, ApiMethodConfig config, ApiSerializationConfig serializationConfig) throws IllegalArgumentException, SecurityException {
        Method method = endpointMethod.getMethod();
        ObjectNode methodNode = objectMapper.createObjectNode();
        this.setNodePropertyNoConflict(methodsNode, config.getFullMethodName(), (JsonNode)methodNode);
        methodNode.put("path", config.getPath());
        methodNode.put("httpMethod", config.getHttpMethod());
        methodNode.put("scopes", (JsonNode)objectMapper.convertValue((Object)config.getScopes(), JsonNode.class));
        methodNode.put("audiences", (JsonNode)objectMapper.convertValue((Object)config.getAudiences(), JsonNode.class));
        methodNode.put("clientIds", (JsonNode)objectMapper.convertValue((Object)config.getClientIds(), JsonNode.class));
        methodNode.put("rosyMethod", config.getFullJavaName());
        ObjectNode descriptorMethodNode = objectMapper.createObjectNode();
        this.setNodePropertyNoConflict(descriptorMethodsNode, config.getFullJavaName(), (JsonNode)descriptorMethodNode);
        this.convertMethodRequest(endpointMethod, methodNode, descriptorSchemasNode, descriptorMethodNode, config, serializationConfig);
        this.convertMethodResponse(endpointMethod, methodNode, descriptorSchemasNode, descriptorMethodNode, serializationConfig);
    }

    private void convertMethodRequest(EndpointMethod endpointMethod, ObjectNode apiMethodNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config, ApiSerializationConfig serializationConfig) throws IllegalArgumentException, SecurityException {
        ObjectNode requestNode = objectMapper.createObjectNode();
        this.convertMethodRequestParameters(endpointMethod, requestNode, descriptorSchemasNode, descriptorMethodNode, config, serializationConfig);
        apiMethodNode.put("request", (JsonNode)requestNode);
    }

    private void convertMethodRequestParameters(EndpointMethod endpointMethod, ObjectNode requestNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config, ApiSerializationConfig serializationConfig) throws IllegalArgumentException, SecurityException {
        ObjectNode parametersNode = objectMapper.createObjectNode();
        Method method = endpointMethod.getMethod();
        Collection pathParameters = config.getPathParameters();
        for (ApiParameterConfig parameterConfig : config.getParameterConfigs()) {
            switch (parameterConfig.getClassification()) {
                case INJECTED: {
                    break;
                }
                case API_PARAMETER: {
                    this.convertSimpleParameter(parameterConfig, parametersNode);
                    break;
                }
                case RESOURCE: {
                    this.convertComplexParameter(parameterConfig, method, descriptorSchemasNode, descriptorMethodNode, serializationConfig);
                }
            }
        }
        if (parametersNode.size() != 0) {
            requestNode.put("parameters", (JsonNode)parametersNode);
        }
        if (descriptorMethodNode.get("request") != null) {
            requestNode.put("body", "autoTemplate(backendRequest)");
            requestNode.put("bodyName", "resource");
        } else {
            requestNode.put("body", "empty");
        }
    }

    private void convertSimpleParameter(ApiParameterConfig config, ObjectNode parametersNode) {
        Object type;
        ObjectNode parameterNode = objectMapper.createObjectNode();
        if (config.isRepeated()) {
            parameterNode.put("repeated", true);
            type = config.getRepeatedItemSerializedType();
        } else {
            type = config.getSchemaBaseType();
        }
        if (config.isEnum()) {
            ObjectNode enumValuesNode = objectMapper.createObjectNode();
            for (Object enumConstant : ((Class)type).getEnumConstants()) {
                ObjectNode enumNode = objectMapper.createObjectNode();
                enumValuesNode.put(enumConstant.toString(), (JsonNode)enumNode);
            }
            parameterNode.put("enum", (JsonNode)enumValuesNode);
            type = String.class;
        }
        parameterNode.put("type", (String)this.typeLoader.getParameterTypes().get(type));
        parameterNode.put("required", !config.getNullable() && config.getDefaultValue() == null);
        String defaultValue = config.getDefaultValue();
        if (defaultValue != null) {
            Class parameterClass = (Class)type;
            try {
                objectMapper.convertValue((Object)defaultValue, parameterClass);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid default value for type '%s'", defaultValue, type));
            }
            parameterNode.put("default", defaultValue);
        }
        parametersNode.put(config.getName(), (JsonNode)parameterNode);
    }

    private void convertComplexParameter(ApiParameterConfig config, Method method, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiSerializationConfig serializationConfig) {
        ObjectNode schemaTypeNode = objectMapper.createObjectNode();
        Type type = config.getSchemaBaseType();
        String schemaTypeName = this.addTypeToNode(descriptorSchemasNode, type, null, schemaTypeNode, serializationConfig);
        String requestTypeName = this.addTypeToSchema(descriptorSchemasNode, type, serializationConfig);
        ObjectNode requestTypeNode = objectMapper.createObjectNode();
        this.addTypeToNode(descriptorSchemasNode, type, null, requestTypeNode, serializationConfig);
        this.setNodePropertyNoConflict(descriptorMethodNode, "request", (JsonNode)requestTypeNode);
    }

    private void convertMethodResponse(EndpointMethod serviceMethod, ObjectNode methodNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiSerializationConfig serializationConfig) {
        ObjectNode responseNode = objectMapper.createObjectNode();
        methodNode.put("response", (JsonNode)responseNode);
        if (this.methodHasResourceInResponse(serviceMethod)) {
            responseNode.put("body", "autoTemplate(backendResponse)");
            Type returnType = ApiAnnotationIntrospector.getSchemaType((Type)serviceMethod.getReturnType(), (ApiSerializationConfig)serializationConfig);
            descriptorMethodNode.put("response", (JsonNode)this.convertMethodResponseType(descriptorSchemasNode, returnType, serializationConfig));
        } else {
            responseNode.put("body", "empty");
        }
    }

    private ObjectNode convertMethodResponseType(ObjectNode descriptorSchemasNode, Type returnType, ApiSerializationConfig serializationConfig) {
        ObjectNode returnTypeNode = objectMapper.createObjectNode();
        String responseTypeName = this.addTypeToNode(descriptorSchemasNode, returnType, null, returnTypeNode, serializationConfig);
        if (this.typeLoader.isSchemaType(returnType)) {
            throw new IllegalArgumentException("Type " + returnType + " cannot be used as a return type");
        }
        if (TypeLoader.getArrayItemType((Type)returnType) != null && returnType != byte[].class) {
            ObjectNode propertiesNode = objectMapper.createObjectNode();
            propertiesNode.put("items", (JsonNode)returnTypeNode);
            ObjectNode arrayWrapperNode = objectMapper.createObjectNode();
            arrayWrapperNode.put("id", responseTypeName);
            arrayWrapperNode.put("type", "object");
            arrayWrapperNode.put("properties", (JsonNode)propertiesNode);
            descriptorSchemasNode.put(responseTypeName, (JsonNode)arrayWrapperNode);
            returnTypeNode = objectMapper.createObjectNode();
            returnTypeNode.put("$ref", responseTypeName);
        }
        return returnTypeNode;
    }

    private boolean methodHasResourceInResponse(EndpointMethod serviceMethod) {
        Type returnType = serviceMethod.getReturnType();
        return returnType != Void.TYPE && returnType != Void.class;
    }

    @VisibleForTesting
    String addTypeToSchema(ObjectNode schemasNode, Type type, ApiSerializationConfig serializationConfig) {
        return this.addTypeToSchema(schemasNode, type, null, serializationConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    String addTypeToSchema(ObjectNode schemasNode, Type type, Type enclosingType, ApiSerializationConfig serializationConfig) {
        if (this.typeLoader.isSchemaType(type)) {
            return (String)this.typeLoader.getSchemaTypes().get(type);
        }
        if (type == Object.class) {
            if (schemasNode.has(ANY_SCHEMA_NAME)) return ANY_SCHEMA_NAME;
            ObjectNode anySchema = objectMapper.createObjectNode();
            anySchema.put("id", ANY_SCHEMA_NAME);
            anySchema.put("type", "any");
            schemasNode.put(ANY_SCHEMA_NAME, (JsonNode)anySchema);
            return ANY_SCHEMA_NAME;
        }
        if (this.typeLoader.isMapType(type)) {
            if (schemasNode.has(MAP_SCHEMA_NAME)) return MAP_SCHEMA_NAME;
            ObjectNode mapSchema = objectMapper.createObjectNode();
            mapSchema.put("id", MAP_SCHEMA_NAME);
            mapSchema.put("type", "object");
            schemasNode.put(MAP_SCHEMA_NAME, (JsonNode)mapSchema);
            return MAP_SCHEMA_NAME;
        }
        String typeName = TypeLoader.getSimpleName((Type)type);
        JsonNode existing = schemasNode.get(typeName);
        if (existing != null && existing.isObject()) {
            return typeName;
        }
        ObjectNode schemaNode = objectMapper.createObjectNode();
        if (type instanceof ParameterizedType) {
            Type collectionType = ((ParameterizedType)type).getRawType();
            if (this.typeLoader.isSchemaType(collectionType)) {
                return (String)this.typeLoader.getSchemaTypes().get(collectionType);
            }
            if (!((Class)this.typeLoader.getClassTypes().get("CollectionResponses")).isAssignableFrom((Class)collectionType)) throw new IllegalArgumentException("Parameterized type " + type + " not supported.");
            this.addBeanTypeToSchema(schemasNode, TypeLoader.getSimpleName((Type)type), schemaNode, type, serializationConfig);
            return typeName;
        } else {
            if (!(type instanceof Class)) throw new IllegalArgumentException(String.format("Object type %s not supported.", type));
            Class c = (Class)type;
            if (c.isEnum()) {
                schemasNode.put(typeName, (JsonNode)schemaNode);
                schemaNode.put("id", typeName);
                schemaNode.put("type", "string");
                ArrayNode enumNode = objectMapper.createArrayNode();
                for (Object enumConstant : c.getEnumConstants()) {
                    enumNode.add(enumConstant.toString());
                }
                schemaNode.put("enum", (JsonNode)enumNode);
                return typeName;
            } else {
                Type serializedType = ApiAnnotationIntrospector.getSchemaType((Type)c, (ApiSerializationConfig)serializationConfig);
                if (!c.equals(serializedType)) {
                    return this.addTypeToSchema(schemasNode, serializedType, enclosingType, serializationConfig);
                }
                this.addBeanTypeToSchema(schemasNode, typeName, schemaNode, c, serializationConfig);
            }
        }
        return typeName;
    }

    private void addBeanTypeToSchema(ObjectNode schemasNode, String typeName, ObjectNode schemaNode, Type type, ApiSerializationConfig serializationConfig) {
        schemasNode.put(typeName, (JsonNode)schemaNode);
        schemaNode.put("id", typeName);
        schemaNode.put("type", "object");
        ObjectNode propertiesNode = objectMapper.createObjectNode();
        this.addBeanProperties(schemasNode, propertiesNode, type, serializationConfig);
        schemaNode.put("properties", (JsonNode)propertiesNode);
    }

    protected void addBeanProperties(ObjectNode schemasNode, ObjectNode node, Type beanType, ApiSerializationConfig serializationConfig) {
        Class beanClass = beanType instanceof ParameterizedType ? (Class)((ParameterizedType)beanType).getRawType() : (Class)beanType;
        ResourceSchema schema = this.resourceSchemaProvider.getResourceSchema(beanClass, serializationConfig);
        for (Map.Entry entry : schema.getProperties().entrySet()) {
            String propertyName = (String)entry.getKey();
            ObjectNode propertyNode = objectMapper.createObjectNode();
            Type propertyType = ((ResourcePropertySchema)entry.getValue()).getJavaType();
            if (propertyType == null) continue;
            this.addTypeToNode(schemasNode, propertyType, beanType, propertyNode, serializationConfig);
            node.put(propertyName, (JsonNode)propertyNode);
        }
    }

    protected String addTypeToNode(ObjectNode schemasNode, Type type, Type enclosingType, ObjectNode node, ApiSerializationConfig serializationConfig) {
        Type itemType = TypeLoader.getArrayItemType((Type)type);
        if (this.typeLoader.getSchemaTypes().containsKey(type)) {
            String basicTypeName = (String)this.typeLoader.getSchemaTypes().get(type);
            this.addElementTypeToNode(schemasNode, type, basicTypeName, node);
            return basicTypeName;
        }
        if (itemType != null) {
            ObjectNode items = objectMapper.createObjectNode();
            node.put("type", "array");
            node.put("items", (JsonNode)items);
            String itemTypeName = this.addTypeToNode(schemasNode, itemType, enclosingType, items, serializationConfig);
            String arraySuffix = "Collection";
            StringBuilder sb = new StringBuilder(itemTypeName.length() + arraySuffix.length());
            sb.append(itemTypeName).append(arraySuffix);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            return sb.toString();
        }
        if (type instanceof TypeVariable) {
            if (enclosingType instanceof ParameterizedType) {
                Type[] typeArgs = ((ParameterizedType)enclosingType).getActualTypeArguments();
                Type actualArg = typeArgs.length > 0 ? typeArgs[0] : null;
                return this.addTypeToNode(schemasNode, actualArg, null, node, serializationConfig);
            }
            throw new IllegalArgumentException(String.format("Object type %s not supported.", type));
        }
        String typeName = this.addTypeToSchema(schemasNode, type, enclosingType, serializationConfig);
        this.addElementTypeToNode(schemasNode, type, typeName, node);
        return typeName;
    }

    private void addElementTypeToNode(ObjectNode schemasNode, Type type, String typeName, ObjectNode node) {
        if (schemasNode.has(typeName)) {
            node.put("$ref", typeName);
        } else {
            node.put("type", typeName);
            String format = (String)this.typeLoader.getSchemaFormats().get(type);
            if (format != null) {
                node.put("format", format);
            }
        }
    }
}

