/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiConfigException;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class EndpointsToolAction
extends Action {
    public static final String OPTION_CLASS_PATH_SHORT = "cp";
    public static final String OPTION_CLASS_PATH_LONG = "classpath";
    public static final String OPTION_OUTPUT_DIR_SHORT = "o";
    public static final String OPTION_OUTPUT_DIR_LONG = "output";
    public static final String OPTION_MISC_OUTPUT_DIR_SHORT = "O";
    public static final String OPTION_MISC_OUTPUT_DIR_LONG = "miscoutput";
    public static final String OPTION_WAR_SHORT = "w";
    public static final String OPTION_WAR_LONG = "war";
    public static final String OPTION_LANGUAGE_SHORT = "l";
    public static final String OPTION_LANGUAGE_LONG = "language";
    @VisibleForTesting
    static final String DEFAULT_WAR_PATH = "./war";
    @VisibleForTesting
    static final String DEFAULT_OUTPUT_PATH = "./";
    @VisibleForTesting
    static final String DEFAULT_WAR_OUTPUT_PATH_SUFFIX = "WEB-INF";
    @VisibleForTesting
    static final String DEFAULT_CLASS_PATH = "";
    @VisibleForTesting
    static final String DEFAULT_LANGUAGE = "java";

    public EndpointsToolAction(String name) {
        super(new String[]{name});
    }

    public abstract String getUsageString();

    public abstract boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException;

    public void apply() {
    }

    protected List<String> getHelpLines() {
        LinkedList<String> helpLines = new LinkedList<String>();
        helpLines.add(this.getNameString() + ": " + this.getShortDescription());
        helpLines.add("usage: " + this.getUsageString());
        helpLines.add(DEFAULT_CLASS_PATH);
        helpLines.add("Options:");
        for (Option option : this.getOptions()) {
            helpLines.addAll(option.getHelpLines());
        }
        return helpLines;
    }

    protected String getWarPath(Option warOption) {
        return this.getOptionOrDefault(warOption, DEFAULT_WAR_PATH);
    }

    protected String getOutputPath(Option outputOption) {
        return this.getOptionOrDefault(outputOption, DEFAULT_OUTPUT_PATH);
    }

    protected String getWarOutputPath(Option outputOption, String warPath) {
        if (outputOption.getValue() != null) {
            return outputOption.getValue();
        }
        return warPath + File.separator + DEFAULT_WAR_OUTPUT_PATH_SUFFIX;
    }

    protected String getClassPath(Option classPathOption) {
        return this.getOptionOrDefault(classPathOption, DEFAULT_CLASS_PATH);
    }

    protected String getLanguage(Option languageOption) {
        return this.getOptionOrDefault(languageOption, DEFAULT_LANGUAGE);
    }

    protected String getOptionOrDefault(Option option, String defaultValue) {
        if (option.getValue() != null) {
            return option.getValue();
        }
        return defaultValue;
    }

    protected Option makeWarOption() {
        return new EndpointsOption(OPTION_WAR_SHORT, OPTION_WAR_LONG){

            public List<String> getHelpLines() {
                return Arrays.asList(" --war=WAR_PATH               The path to a directory with a WAR", "  -w WAR_PATH                   directory layout (default: ./war).");
            }
        };
    }

    protected Option makeOutputOption() {
        return new EndpointsOption(OPTION_OUTPUT_DIR_SHORT, OPTION_OUTPUT_DIR_LONG){

            public List<String> getHelpLines() {
                return Arrays.asList(" --output=OUTPUT_DIR          The directory to store output files", "  -o OUTPUT_DIR                 (default: ./).");
            }
        };
    }

    protected Option makeMiscOutputOption() {
        return new EndpointsOption(OPTION_MISC_OUTPUT_DIR_SHORT, OPTION_MISC_OUTPUT_DIR_LONG){

            public List<String> getHelpLines() {
                return Arrays.asList(" --miscoutput=OUTPUT_DIR       The directory to store non-config files", "  -O OUTPUT_DIR                 (default: ./).");
            }
        };
    }

    protected Option makeWarOutputOption() {
        return new EndpointsOption(OPTION_OUTPUT_DIR_SHORT, OPTION_OUTPUT_DIR_LONG){

            public List<String> getHelpLines() {
                return Arrays.asList(" --output=OUTPUT_DIR          The directory to store output files", "  -o OUTPUT_DIR                 (default: {war}/WEB-INF).");
            }
        };
    }

    protected Option makeClassPathOption() {
        return new EndpointsOption(OPTION_CLASS_PATH_SHORT, OPTION_CLASS_PATH_LONG){

            public List<String> getHelpLines() {
                return Arrays.asList(" --classpath=CLASSPATH        Additional class path entries", "  -cp CLASSPATH                 (default: ).");
            }
        };
    }

    protected Option makeLanguageOption() {
        return new EndpointsOption(OPTION_LANGUAGE_SHORT, OPTION_LANGUAGE_LONG){

            public List<String> getHelpLines() {
                return Arrays.asList(" --language=LANGUAGE          The target output programming language", "  -l LANGUAGE                   (java) (default: java).");
            }
        };
    }

    public static URL[] computeClassPath(String warPath, String classPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File warDir = new File(warPath).getAbsoluteFile();
        File webInfDir = new File(warDir, DEFAULT_WAR_OUTPUT_PATH_SUFFIX);
        File classesDir = new File(webInfDir, "classes");
        urls.add(classesDir.toURI().toURL());
        File libDir = new File(webInfDir, "lib");
        String[] files = libDir.list();
        if (files != null) {
            for (String file : files) {
                File maybeJar = new File(libDir, file);
                if (!maybeJar.isFile() || !file.endsWith(".jar")) continue;
                urls.add(maybeJar.toURI().toURL());
            }
        }
        if (!Strings.isNullOrEmpty((String)classPath)) {
            for (String classPathEntry : classPath.split(File.pathSeparator)) {
                urls.add(new File(classPathEntry).toURI().toURL());
            }
        }
        return urls.toArray(new URL[0]);
    }

    protected static class EndpointsOption
    extends Option {
        public EndpointsOption(String shortName, String longName) {
            super(shortName, longName, false);
        }

        public void apply() {
        }
    }
}

