/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.tools.AnnotationApiConfigGenerator;
import com.google.api.server.spi.tools.AppEngineUtil;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GenApiConfigAction
extends EndpointsToolAction {
    public static final String NAME = "gen-api-config";
    private Option classPathOption = this.makeClassPathOption();
    private Option outputOption = this.makeWarOutputOption();
    private Option warOption = this.makeWarOption();

    public GenApiConfigAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.classPathOption, this.outputOption, this.warOption));
        this.setShortDescription("Generates API configuration files from service classes");
    }

    @Override
    public boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        if (this.getArgs().isEmpty()) {
            return false;
        }
        String warPath = this.getWarPath(this.warOption);
        this.genApiConfig(GenApiConfigAction.computeClassPath(warPath, this.getClassPath(this.classPathOption)), this.getWarOutputPath(this.outputOption, warPath), warPath, this.getArgs());
        return true;
    }

    public String[] genApiConfig(URL[] classPath, String outputDirPath, String warPath, List<String> serviceClassNames) throws ClassNotFoundException, JsonGenerationException, JsonMappingException, IOException, ApiConfigException {
        File outputDir = new File(outputDirPath);
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(outputDirPath + " is not a directory");
        }
        URLClassLoader classLoader = new URLClassLoader(classPath, GenApiConfigAction.class.getClassLoader());
        ApiConfig.Factory configFactory = new ApiConfig.Factory();
        ApiConfigValidator validator = new ApiConfigValidator();
        AnnotationApiConfigGenerator generator = new AnnotationApiConfigGenerator(classLoader, configFactory, validator);
        Map<String, String> apiConfigs = generator.generateConfig(ServiceContext.create((String)AppEngineUtil.getApplicationId(warPath), (String)"myapi"), GenApiConfigAction.loadClasses(classLoader, serviceClassNames));
        String[] apiConfigFilePaths = new String[apiConfigs.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : apiConfigs.entrySet()) {
            String apiConfigFileName = entry.getKey();
            String apiConfigFileContent = entry.getValue();
            String apiConfigFilePath = outputDir + "/" + apiConfigFileName;
            apiConfigFilePaths[i++] = apiConfigFilePath;
            IoUtil.writeFile((String)apiConfigFilePath, (String)apiConfigFileContent);
            System.out.println("API configuration written to " + apiConfigFilePath);
        }
        return apiConfigFilePaths;
    }

    private static Class<?>[] loadClasses(ClassLoader classLoader, List<String> classNames) throws ClassNotFoundException {
        Class[] classes = new Class[classNames.size()];
        for (int i = 0; i < classNames.size(); ++i) {
            classes[i] = classLoader.loadClass(classNames.get(i));
        }
        return classes;
    }

    @Override
    public String getUsageString() {
        return "gen-api-config <options> <service class>...";
    }
}

