/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.ClientLibGenerator;
import com.google.api.server.spi.tools.CloudClientLibGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class GenClientLibAction
extends EndpointsToolAction {
    public static final String NAME = "gen-client-lib";
    private static final ObjectMapper mapper = ObjectMapperUtil.createStandardObjectMapper();
    private Option languageOption = this.makeLanguageOption();
    private Option outputOption = this.makeOutputOption();

    public GenClientLibAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.languageOption, this.outputOption));
        this.setShortDescription("Generates a client library");
    }

    @Override
    public boolean execute() throws FileNotFoundException, IOException {
        if (this.getArgs().size() != 1) {
            return false;
        }
        this.genClientLib(this.getLanguage(this.languageOption), this.getOutputPath(this.outputOption), (String)this.getArgs().get(0));
        return true;
    }

    public Object genClientLib(String language, String outputDirPath, String discoveryDocPath) throws FileNotFoundException, IOException {
        String discoveryDoc = IoUtil.readFile((File)new File(discoveryDocPath));
        if (!GenClientLibAction.isRestDiscoveryDoc(discoveryDoc)) {
            throw new IllegalArgumentException("discovery doc must be in rest format");
        }
        File outputFile = new File(outputDirPath + "/" + GenClientLibAction.getApiNameVersion(discoveryDoc) + "-" + language.toLowerCase() + ".zip");
        ClientLibGenerator generator = CloudClientLibGenerator.using("https://google-api-client-libraries.appspot.com/generate");
        generator.generateClientLib(discoveryDoc, ClientLibGenerator.Language.valueOf(language.toUpperCase()), null, outputFile);
        System.out.println("API client library written to " + outputFile.getPath());
        return null;
    }

    private static boolean isRestDiscoveryDoc(String discoveryDoc) throws IOException {
        ObjectNode discoveryJson = (ObjectNode)ObjectMapperUtil.createStandardObjectMapper().readValue(discoveryDoc, ObjectNode.class);
        return "rest".equals(discoveryJson.get("protocol").asText());
    }

    private static String getApiNameVersion(String discoveryDoc) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode root = (ObjectNode)mapper.readValue(discoveryDoc, ObjectNode.class);
        return root.path("name").getTextValue() + "-" + root.path("version").getTextValue();
    }

    @Override
    public String getUsageString() {
        return "gen-client-lib <options> <discovery doc file>";
    }
}

