/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.CloudDiscoveryDocGenerator;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GenDiscoveryDocAction
extends EndpointsToolAction {
    public static final String NAME = "gen-discovery-doc";
    public static final String OPTION_FORMAT_SHORT = "f";
    public static final String OPTION_FORMAT_LONG = "format";
    @VisibleForTesting
    static final String DEFAULT_FORMAT = "rest";
    public static final String DISCOVERY_GEN_ROOT = "https://webapis-discovery.appspot.com/_ah/api";
    private Option formatOption = this.makeFormatOption();
    private Option outputOption = this.makeOutputOption();

    public GenDiscoveryDocAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.formatOption, this.outputOption));
        this.setShortDescription("Generates API Discovery document");
    }

    @Override
    public boolean execute() throws JsonParseException, JsonMappingException, IOException {
        if (this.getArgs().size() != 1) {
            return false;
        }
        DiscoveryDocGenerator.Format format = DiscoveryDocGenerator.Format.valueOf(this.getFormat(this.formatOption).toUpperCase());
        this.genDiscoveryDoc(format, this.getOutputPath(this.outputOption), (String)this.getArgs().get(0));
        return true;
    }

    public String genDiscoveryDoc(DiscoveryDocGenerator.Format format, String outputDirPath, String apiConfigFilePath) throws JsonParseException, JsonMappingException, IOException {
        File outputDir = new File(outputDirPath);
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(outputDirPath + " is not a directory");
        }
        String apiConfigJson = IoUtil.readFile((File)new File(apiConfigFilePath));
        Map apiConfig = (Map)ObjectMapperUtil.createStandardObjectMapper().readValue(apiConfigJson, Map.class);
        String root = GenDiscoveryDocAction.getNonNullValue(apiConfig, "root");
        String name = GenDiscoveryDocAction.getNonNullValue(apiConfig, "name");
        String version = GenDiscoveryDocAction.getNonNullValue(apiConfig, "version");
        DiscoveryDocGenerator generator = CloudDiscoveryDocGenerator.using(this.getDiscoveryGenRoot());
        String discoveryDoc = generator.generateDiscoveryDoc(apiConfigJson, format);
        String discoveryDocFilePath = outputDir + "/" + name + "-" + version + "-" + format.toString().toLowerCase() + ".discovery";
        IoUtil.writeFile((String)discoveryDocFilePath, (String)discoveryDoc);
        System.out.println("API Discovery Document written to " + discoveryDocFilePath);
        return discoveryDocFilePath;
    }

    private String getDiscoveryGenRoot() {
        String discoveryGenRoot = System.getenv("DISCOVERY_GEN_ROOT");
        return discoveryGenRoot == null ? DISCOVERY_GEN_ROOT : discoveryGenRoot;
    }

    private static String getNonNullValue(Map<String, ?> apiConfig, String name) {
        String value = (String)apiConfig.get(name);
        if (value == null) {
            throw new IllegalArgumentException("API " + name + " cannot be null");
        }
        return value;
    }

    @Override
    public String getUsageString() {
        return "gen-discovery-doc <options> <api config file>";
    }

    private Option makeFormatOption() {
        return new EndpointsToolAction.EndpointsOption(OPTION_FORMAT_SHORT, OPTION_FORMAT_LONG){

            public List<String> getHelpLines() {
                return Arrays.asList(" --format=FORMAT              The requested API protocol type (rest|rpc)", "  -f FORMAT                     (default: rest).");
            }
        };
    }

    private String getFormat(Option formatOption) {
        return this.getOptionOrDefault(formatOption, DEFAULT_FORMAT);
    }
}

