/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.api.server.spi.tools.GenApiConfigAction;
import com.google.api.server.spi.tools.GenClientLibAction;
import com.google.api.server.spi.tools.GenDiscoveryDocAction;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class GetClientLibAction
extends EndpointsToolAction {
    public static final String NAME = "get-client-lib";
    private Option classPathOption = this.makeClassPathOption();
    private Option languageOption = this.makeLanguageOption();
    private Option outputOption = this.makeWarOutputOption();
    private Option miscOutputOption = this.makeMiscOutputOption();
    private Option warOption = this.makeWarOption();

    public GetClientLibAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.classPathOption, this.languageOption, this.outputOption, this.miscOutputOption, this.warOption));
        this.setShortDescription("Generates a client library");
    }

    @Override
    public boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        if (this.getArgs().isEmpty()) {
            return false;
        }
        String warPath = this.getWarPath(this.warOption);
        this.getClientLib(GetClientLibAction.computeClassPath(warPath, this.getClassPath(this.classPathOption)), this.getLanguage(this.languageOption), this.getWarOutputPath(this.outputOption, warPath), warPath, this.getArgs(), this.getOutputPath(this.miscOutputOption));
        return true;
    }

    public Object getClientLib(URL[] classPath, String language, String outputDirPath, String warPath, List<String> serviceClassNames, String miscOutputDirPath) throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        String[] apiConfigFilePaths;
        for (String apiConfigFilePath : apiConfigFilePaths = new GenApiConfigAction().genApiConfig(classPath, outputDirPath, warPath, serviceClassNames)) {
            String restDiscoveryDocPath = this.generateDiscoveryDocs(miscOutputDirPath, apiConfigFilePath);
            new GenClientLibAction().genClientLib(language, miscOutputDirPath, restDiscoveryDocPath);
        }
        return null;
    }

    @VisibleForTesting
    String generateDiscoveryDocs(String outputDirPath, String apiConfigFilePath) throws JsonParseException, JsonMappingException, IOException, FileNotFoundException {
        return this.generateDiscoveryDoc(DiscoveryDocGenerator.Format.REST, outputDirPath, apiConfigFilePath);
    }

    @VisibleForTesting
    String generateDiscoveryDoc(DiscoveryDocGenerator.Format format, String outputDirPath, String apiConfigFilePath) throws JsonParseException, JsonMappingException, IOException, FileNotFoundException {
        return new GenDiscoveryDocAction().genDiscoveryDoc(format, outputDirPath, apiConfigFilePath);
    }

    @Override
    public String getUsageString() {
        return "get-client-lib <options> <service class>...";
    }
}

