/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.tools.AbstractResourceSchemaProvider;
import com.google.appengine.repackaged.org.codehaus.jackson.map.BeanDescription;
import com.google.appengine.repackaged.org.codehaus.jackson.map.BeanPropertyDefinition;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.google.appengine.repackaged.org.codehaus.jackson.type.JavaType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class JacksonResourceSchemaProvider
extends AbstractResourceSchemaProvider {
    private static final Logger logger = Logger.getLogger(JacksonResourceSchemaProvider.class.getName());

    JacksonResourceSchemaProvider() {
    }

    @Override
    public ResourceSchema getResourceSchema(Class<?> clazz, ApiSerializationConfig config) {
        ResourceSchema schema = super.getResourceSchema(clazz, config);
        if (schema != null) {
            return schema;
        }
        ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper((ApiSerializationConfig)config);
        JavaType javaType = objectMapper.getTypeFactory().constructType(clazz);
        BeanDescription beanDescription = objectMapper.getSerializationConfig().introspect(javaType);
        List definitions = beanDescription.findProperties();
        ResourceSchema.Builder schemaBuilder = ResourceSchema.builderForType(clazz);
        for (BeanPropertyDefinition definition : definitions) {
            Type type = this.getPropertyType(JacksonResourceSchemaProvider.toMethod(definition.getGetter()), JacksonResourceSchemaProvider.toMethod(definition.getSetter()), config);
            if (type != null) {
                schemaBuilder.addProperty(definition.getName(), ResourcePropertySchema.of((Type)type));
                continue;
            }
            logger.warning("No type found for property " + definition.getName() + " on class " + clazz.getName());
        }
        return schemaBuilder.build();
    }

    private static Method toMethod(AnnotatedMethod am) {
        if (am != null) {
            return am.getAnnotated();
        }
        return null;
    }

    @Nullable
    private Type getPropertyType(Method readMethod, Method writeMethod, ApiSerializationConfig config) {
        Type[] paramTypes;
        if (readMethod != null) {
            return ApiAnnotationIntrospector.getSchemaType((Type)readMethod.getGenericReturnType(), (ApiSerializationConfig)config);
        }
        if (writeMethod != null && (paramTypes = writeMethod.getGenericParameterTypes()).length == 1) {
            return ApiAnnotationIntrospector.getSchemaType((Type)paramTypes[0], (ApiSerializationConfig)config);
        }
        return null;
    }
}

