/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.util.Iterator;

public class JacksonUtil {
    public static ObjectNode mergeObject(ObjectNode object1, ObjectNode object2) {
        Iterator fieldNames = object2.getFieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode child2 = object2.get(fieldName);
            JsonNode child1 = object1.get(fieldName);
            JsonNode merged = child1 == null ? child2 : JacksonUtil.mergeNode(child1, child2);
            object1.put(fieldName, merged);
        }
        return object1;
    }

    public static ArrayNode mergeArray(ArrayNode array1, ArrayNode array2) {
        array1.addAll(array2);
        return array1;
    }

    public static JsonNode mergeNode(JsonNode node1, JsonNode node2) {
        if (node1.isArray()) {
            if (!node2.isArray()) {
                throw new IllegalArgumentException("Cannot merge array and non-array: " + node1 + ", " + node2);
            }
            return JacksonUtil.mergeArray((ArrayNode)node1, (ArrayNode)node2);
        }
        if (node1.isObject()) {
            if (!node2.isObject()) {
                throw new IllegalArgumentException("Cannot merge object and non-object: " + node1 + ", " + node2);
            }
            return JacksonUtil.mergeObject((ObjectNode)node1, (ObjectNode)node2);
        }
        if (!node1.equals((Object)node2)) {
            throw new IllegalArgumentException("Cannot merge different values: " + node1 + ", " + node2);
        }
        return node1;
    }
}

