/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.tools.devserver.ApiConfig;
import com.google.api.server.spi.tools.devserver.ApiServlet;
import com.google.api.server.spi.tools.devserver.Headers;
import com.google.api.server.spi.tools.devserver.LilyClient;
import com.google.api.server.spi.tools.devserver.RpcMethodDispatcher;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RpcApiServlet
extends ApiServlet {
    private static final Logger logger = Logger.getLogger(RpcApiServlet.class.getName());
    private RpcMethodDispatcher methodDispatcher;

    @Override
    protected LilyClient.Request marshallRequest(HttpServletRequest request, ApiConfig.Method method, ObjectNode body) throws IOException {
        return LilyRequestMarshaller.marshall(request, method, mapper.writeValueAsString((Object)body));
    }

    @Override
    protected void loadApiConfigs(List<ApiConfig> apiConfigs) {
        this.methodDispatcher = new RpcMethodDispatcher(apiConfigs);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String body = IoUtil.readStream((InputStream)request.getInputStream());
            logger.log(Level.FINE, "requestBody={0}", body);
            JsonNode root = mapper.readTree(body);
            if (root instanceof ObjectNode) {
                ObjectNode requestRoot = (ObjectNode)root;
                LilyClient.Response lilyResponse = this.doSingleBackendCall(request, response, requestRoot);
                LilyResponseMarshaller.marshall(lilyResponse, this.getRequestId(requestRoot), response);
            } else if (root instanceof ArrayNode) {
                ArrayNode batchRoot = (ArrayNode)root;
                Iterator iterator = batchRoot.getElements();
                ArrayList<LilyClient.Response> responses = new ArrayList<LilyClient.Response>(batchRoot.size());
                ArrayList<String> requestIds = new ArrayList<String>(batchRoot.size());
                while (iterator.hasNext()) {
                    ObjectNode requestRoot = (ObjectNode)iterator.next();
                    String requestId = this.getRequestId(requestRoot);
                    responses.add(this.doSingleBackendCall(request, response, requestRoot));
                    requestIds.add(requestId);
                }
                LilyResponseMarshaller.marshall(responses, requestIds, response);
            }
        }
        catch (JsonParseException e) {
            this.sendJsonError((Exception)((Object)e), response);
        }
        catch (JsonMappingException e) {
            this.sendJsonError((Exception)((Object)e), response);
        }
    }

    private LilyClient.Response doSingleBackendCall(HttpServletRequest request, HttpServletResponse response, ObjectNode root) throws IOException {
        ApiConfig.Method method = this.methodDispatcher.dispatch(root);
        if (method == null) {
            return new LilyClient.Response(404, new Headers(), "");
        }
        ObjectNode params = (ObjectNode)root.get("params");
        if (params == null) {
            params = mapper.createObjectNode();
        }
        return this.doSingleBackendCall(request, method, params);
    }

    private String getRequestId(ObjectNode root) {
        return root.path("id").asText();
    }

    private void sendJsonError(Exception e, HttpServletResponse response) throws IOException {
        response.sendError(400, "Failed to parse JSON request: " + e.getMessage());
    }

    public static class LilyResponseMarshaller {
        public static void marshall(LilyClient.Response lilyResponse, String requestId, HttpServletResponse response) throws JsonParseException, JsonMappingException, IOException {
            ApiServlet.convertFromLilyResponse(lilyResponse, response, true, requestId);
        }

        public static void marshall(List<LilyClient.Response> lilyResponses, List<String> requestIds, HttpServletResponse response) throws IOException {
            ApiServlet.convertFromLilyResponses(lilyResponses, response, true, requestIds);
        }
    }

    public static class LilyRequestMarshaller {
        public static LilyClient.Request marshall(HttpServletRequest request, ApiConfig.Method method, String params) throws MalformedURLException {
            Headers headers = ApiServlet.convertHeaders(request);
            return new LilyClient.Request(ApiServlet.getSpiEndpoint(ApiServlet.getHostPort(request), method), headers, params);
        }
    }
}

